/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class IOUtils {
    public static final int BUFFER_SIZE = 4096;

    public static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy(inputStream, outputStream, new byte[4096]);
    }

    public static void copy(Reader reader, Writer writer, char[] cArray) throws IOException {
        int n = 0;
        while ((n = reader.read(cArray)) >= 0) {
            writer.write(cArray, 0, n);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IOUtils.copy(reader, writer, new char[4096]);
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.copy((Reader)new InputStreamReader(inputStream), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        if (string == null) {
            IOUtils.copy(inputStream, writer);
        } else {
            IOUtils.copy((Reader)new InputStreamReader(inputStream, string), writer);
        }
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) throws IOException {
        if (string == null) {
            IOUtils.copy(reader, outputStream);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            IOUtils.copy(reader, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
        }
    }

    public static InputStream toInputStream(String string, String string2) throws IOException {
        return new ByteArrayInputStream(string2 != null ? string.getBytes(string2) : string.getBytes());
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, (Writer)stringWriter, string);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n = inputStream.available();
        FastByteArrayOutputStream fastByteArrayOutputStream = n > 0 ? new FastByteArrayOutputStream(n) : new FastByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)fastByteArrayOutputStream);
        return fastByteArrayOutputStream.toByteArray();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket == null) {
            return;
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    public static void closeQuietly(ImageInputStream imageInputStream) {
        block3: {
            if (imageInputStream == null) {
                return;
            }
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                StackTraceElement[] stackTraceElementArray = iOException.getStackTrace();
                if (stackTraceElementArray.length != 0 && "checkClosed".equals(stackTraceElementArray[0].getMethodName())) break block3;
                Logger.log(iOException);
            }
        }
    }
}

