/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.logging;

import VASSAL.tools.ThrowableUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class LogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int BUG = 3;
    public static final int DEBUG = 4;
    public static final int SYSTEM = 5;
    public final long timestamp;
    public final int pid;
    public final int type;
    public final String message;
    public final String trace;
    public final boolean wait;

    public LogEntry(int n, int n2, Throwable throwable, String string, boolean bl) {
        this(System.currentTimeMillis(), n, n2, throwable, string, bl);
    }

    public LogEntry(long l, int n, int n2, Throwable throwable, String string, boolean bl) {
        if (throwable == null && string == null) {
            throw new IllegalArgumentException();
        }
        this.timestamp = l;
        this.pid = n;
        this.type = n2;
        this.message = string;
        this.trace = throwable != null ? ThrowableUtils.getStackTrace(throwable) : null;
        this.wait = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        stringBuilder.append(simpleDateFormat.format(this.timestamp)).append(' ').append(this.pid);
        if (this.message != null) {
            stringBuilder.append(' ').append(this.message);
            if (this.trace != null) {
                stringBuilder.append("\n").append(this.trace);
            }
        } else if (this.trace != null) {
            stringBuilder.append(' ').append(this.trace);
        }
        return stringBuilder.toString();
    }
}

