/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.tools.version.VersionFormatException;
import VASSAL.tools.version.VersionTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVersionTokenizer
implements VersionTokenizer {
    protected String v;
    protected State state = State.NUM;
    protected static Map<String, Integer> tags = new HashMap<String, Integer>();

    public SimpleVersionTokenizer(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.v = string;
    }

    public boolean hasNext() {
        return this.v.length() > 0 || this.state == State.EOS;
    }

    public int next() throws VersionFormatException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (true) {
            block1 : switch (this.state) {
                case NUM: {
                    int n;
                    Matcher matcher = Pattern.compile("^\\d+").matcher(this.v);
                    if (!matcher.lookingAt()) {
                        throw new VersionFormatException();
                    }
                    try {
                        n = Integer.parseInt(matcher.group());
                        if (n < 0) {
                            throw new VersionFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new VersionFormatException(numberFormatException);
                    }
                    this.v = this.v.substring(matcher.end());
                    this.state = this.v.length() == 0 ? State.EOS : State.DELIM;
                    return n;
                }
                case DELIM: {
                    switch (this.v.charAt(0)) {
                        case '.': {
                            this.state = State.NUM;
                            this.v = this.v.substring(1);
                            break block1;
                        }
                    }
                    throw new VersionFormatException();
                }
                case EOS: {
                    this.state = State.END;
                    return -1;
                }
                case END: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray.length > 0 ? stringArray : new String[]{"1.2.3", "1.2.3.4", "1.2.3-svn7890", "1.2.3-beta5", "1.2.3-rc3", "foobarbaz", "1.2.foo", "1.2-foo", "1.2-svn1234.8", "3.0b6"};
        for (String string : stringArray2) {
            System.out.print(string + ":");
            SimpleVersionTokenizer simpleVersionTokenizer = new SimpleVersionTokenizer(string);
            try {
                while (simpleVersionTokenizer.hasNext()) {
                    System.out.print(" " + simpleVersionTokenizer.next());
                }
                System.out.print("\n");
            }
            catch (VersionFormatException versionFormatException) {
                System.out.print(" !\n");
            }
        }
        System.out.print("\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        NUM,
        DELIM,
        EOS,
        END;

    }
}

