/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.logging.Logger;
import VASSAL.tools.version.AbstractUpdateCheckRequest;
import VASSAL.tools.version.VassalVersion;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class UpdateCheckAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Frame frame;

    public UpdateCheckAction(Frame frame) {
        super(Resources.getString("UpdateCheckAction.update_check"));
        this.frame = frame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new Request().execute();
    }

    private class Request
    extends AbstractUpdateCheckRequest {
        private Request() {
        }

        protected void done() {
            try {
                VassalVersion vassalVersion = (VassalVersion)this.get();
                if (vassalVersion == null) {
                    JOptionPane.showMessageDialog(UpdateCheckAction.this.frame, Resources.getString("UpdateCheckAction.version_current_message"), Resources.getString("UpdateCheckAction.version_current_title"), 1);
                } else if (JOptionPane.showConfirmDialog(UpdateCheckAction.this.frame, Resources.getString("UpdateCheckAction.update_available_message"), Resources.getString("UpdateCheckAction.update_available_title"), 0, 3) == 0) {
                    BrowserSupport.openURL("https://sourceforge.net/project/showfiles.php?group_id=90612");
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                ErrorDialog.bug(interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.log(executionException);
            }
            WarningDialog.show((Component)UpdateCheckAction.this.frame, "UpdateCheckAction.check_failed", new Object[0]);
        }
    }
}

