/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.Info;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.version.VassalVersion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class VersionUtils {
    private static final String baseURL = "http://www.vassalengine.org/util/";
    private static final String currentRelease = "current-release";
    private static final String currentBeta = "current-beta";
    private static final String bugCheck = "check-version-bug.php?version=";
    private static VassalVersion release = null;
    private static VassalVersion beta = null;

    public static VassalVersion getRelease() throws IOException {
        if (release == null) {
            release = VersionUtils.getVersion("http://www.vassalengine.org/util/current-release");
        }
        return release;
    }

    public static VassalVersion getBeta() throws IOException {
        if (beta == null) {
            beta = VersionUtils.getVersion("http://www.vassalengine.org/util/current-beta");
        }
        return beta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VassalVersion getVersion(String string) throws IOException {
        VassalVersion vassalVersion;
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
            VassalVersion vassalVersion2 = new VassalVersion(IOUtils.toString(inputStream).trim());
            inputStream.close();
            vassalVersion = vassalVersion2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        return vassalVersion;
    }

    public static boolean isCurrent(VassalVersion vassalVersion) throws IOException {
        return vassalVersion.equals(VersionUtils.update(vassalVersion));
    }

    public static VassalVersion update(VassalVersion vassalVersion) throws IOException {
        VassalVersion vassalVersion2 = VersionUtils.getRelease();
        switch (VersionUtils.sgn(vassalVersion.compareTo(vassalVersion2))) {
            case -1: {
                return vassalVersion2;
            }
            case 0: {
                return vassalVersion;
            }
            case 1: {
                vassalVersion2 = VersionUtils.getBeta();
                switch (VersionUtils.sgn(vassalVersion.compareTo(vassalVersion2))) {
                    case -1: {
                        return vassalVersion2;
                    }
                    case 0: 
                    case 1: {
                        return vassalVersion;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    private static int sgn(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static void main(String[] stringArray) throws IOException {
        VassalVersion vassalVersion = new VassalVersion(Info.getVersion());
        System.out.println(vassalVersion.toString() + " is current? " + VersionUtils.isCurrent(vassalVersion));
    }
}

