/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeersSupport;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.PendingPeersSupport;
import org.litesoft.p2pchat.UserDialog;

public class ActivePeerManager
implements ActivePeersSupport,
PendingPeersSupport {
    private MyInfo zMyInfo;
    private UserDialog zUserDialog;
    private PendingPeerManager zPendingPeerManager;
    private Vector zListofPeers = new Vector();
    private int zPeerCnt = 0;

    public ActivePeerManager(MyInfo myInfo, UserDialog userDialog, PendingPeerManager pendingPeerManager) {
        this.zMyInfo = myInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zUserDialog = userDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zPendingPeerManager = pendingPeerManager;
        IllegalArgument.ifNull("PendingPeerManager", this.zPendingPeerManager);
        this.zUserDialog.setActivePeerManager(this);
        this.zPendingPeerManager.start(this);
    }

    public synchronized void removeActivePeer(ActivePeer activePeer) {
        IllegalArgument.ifNull("Requester", activePeer);
        this.zListofPeers.removeElement(activePeer);
    }

    public synchronized void clear() {
        while (!this.zListofPeers.isEmpty()) {
            ActivePeer activePeer = (ActivePeer)this.zListofPeers.lastElement();
            this.zListofPeers.removeElement(activePeer);
            activePeer.close();
        }
    }

    public synchronized PeerInfo[] getPeerInfos() {
        PeerInfo[] peerInfoArray = new PeerInfo[this.zListofPeers.size()];
        for (int i = 0; i < peerInfoArray.length; ++i) {
            peerInfoArray[i] = ((ActivePeer)this.zListofPeers.elementAt(i)).getPeerInfo();
        }
        return peerInfoArray;
    }

    public synchronized void sendToAllCHAT(String string) {
        IllegalArgument.ifNull("Message", string);
        Enumeration enumeration = this.zListofPeers.elements();
        while (enumeration.hasMoreElements()) {
            ((ActivePeer)enumeration.nextElement()).sendCHAT(string);
        }
    }

    public synchronized void sendToAllNAME() {
        Enumeration enumeration = this.zListofPeers.elements();
        while (enumeration.hasMoreElements()) {
            ((ActivePeer)enumeration.nextElement()).sendNAME();
        }
    }

    public synchronized ActivePeer getPeerListenerByID(String string) {
        if (string != null) {
            Enumeration enumeration = this.zListofPeers.elements();
            while (enumeration.hasMoreElements()) {
                ActivePeer activePeer = (ActivePeer)enumeration.nextElement();
                if (!string.equals(activePeer.getPeerInfo().getID())) continue;
                return activePeer;
            }
        }
        return null;
    }

    public synchronized ActivePeer getPeerListenerByInfo(PeerInfo peerInfo) {
        if (peerInfo != null) {
            Enumeration enumeration = this.zListofPeers.elements();
            while (enumeration.hasMoreElements()) {
                ActivePeer activePeer = (ActivePeer)enumeration.nextElement();
                if (!peerInfo.equals(activePeer.getPeerInfo())) continue;
                return activePeer;
            }
        }
        return null;
    }

    public synchronized boolean isAlreadyConnected(PeerInfo peerInfo) {
        if (peerInfo != null) {
            Enumeration enumeration = this.zListofPeers.elements();
            while (enumeration.hasMoreElements()) {
                if (!((ActivePeer)enumeration.nextElement()).getPeerInfo().equals(peerInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void addActivePeer(PeerInfo peerInfo, InputStream inputStream, OutputStream outputStream) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("InputStream", inputStream);
        IllegalArgument.ifNull("OutputStream", outputStream);
        peerInfo.setID(new Integer(++this.zPeerCnt).toString());
        this.zListofPeers.addElement(new ActivePeer(this.zMyInfo, this.zUserDialog, (ActivePeersSupport)this, (NewPeersSupport)this.zPendingPeerManager, peerInfo, inputStream, outputStream));
    }

    public synchronized void addActivePeer(PeerInfo peerInfo, PeerReader peerReader, PeerWriter peerWriter) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("PeerReader", peerReader);
        IllegalArgument.ifNull("PeerWriter", peerWriter);
        peerInfo.setID(new Integer(++this.zPeerCnt).toString());
        this.zListofPeers.addElement(new ActivePeer(this.zMyInfo, this.zUserDialog, (ActivePeersSupport)this, (NewPeersSupport)this.zPendingPeerManager, peerInfo, peerReader, peerWriter));
    }
}

