/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerInfo {
    private String zID = "";
    private String zChatName;
    private String zAddresses;
    private Integer zPort = null;
    private String[] zOldChatNames = null;
    private static final String NO_CHATNAME = "(?)";
    private int failureCount = 0;

    public PeerInfo(String string, String string2) {
        this.zChatName = string != null ? string : NO_CHATNAME;
        this.zAddresses = string2;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public PeerInfo(String string, String string2, int n) {
        this(string, string2);
        this.zPort = new Integer(n);
    }

    public void updateWith(PeerInfo peerInfo) {
        if (peerInfo != null) {
            this.setChatName(peerInfo.getChatName());
            this.setAddresses(peerInfo.getAddresses());
            this.setPort(peerInfo.getPort());
        }
    }

    public static PeerInfo deFormat(String string) {
        IllegalArgument.ifNull("Formatted", string);
        int n = string.indexOf(58);
        int n2 = string.indexOf(32);
        if (n == -1) {
            return null;
        }
        String string2 = null;
        if (n2 == -1) {
            n2 = string.length();
        } else {
            string2 = string.substring(n2 + 1);
        }
        String string3 = string.substring(0, n);
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new PeerInfo(string2, string3, n3);
    }

    public boolean isAddressable() {
        return this.zAddresses != null && this.zPort != null;
    }

    public String getID() {
        return this.zID;
    }

    public void setID(String string) {
        this.zID = string;
        IllegalArgument.ifNull("ID", this.zID);
    }

    public String getChatName() {
        return this.zChatName;
    }

    public String[] getOldChatNames() {
        return this.zOldChatNames;
    }

    public synchronized String getPrevChatName() {
        return this.zOldChatNames == null ? null : this.zOldChatNames[0];
    }

    public synchronized void setChatName(String string) {
        if (string != null && !string.equals(this.zChatName)) {
            if (this.zChatName != null && !this.zChatName.equals(NO_CHATNAME)) {
                if (this.zOldChatNames == null) {
                    this.zOldChatNames = new String[1];
                } else {
                    String[] stringArray = new String[this.zOldChatNames.length + 1];
                    System.arraycopy(this.zOldChatNames, 0, stringArray, 1, this.zOldChatNames.length);
                    this.zOldChatNames = stringArray;
                }
                this.zOldChatNames[0] = this.zChatName;
            }
            this.zChatName = string;
        }
    }

    public String getAddresses() {
        return this.zAddresses;
    }

    public void setAddresses(String string) {
        this.zAddresses = string;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public int getPort() {
        return this.zPort == null ? 0 : this.zPort;
    }

    public void setPort(int n) {
        this.zPort = new Integer(n);
    }

    public String format() {
        return this.zAddresses + ":" + this.zPort + " " + this.zChatName;
    }

    public int hashCode() {
        int n = 0;
        if (this.zAddresses != null) {
            n += this.zAddresses.hashCode();
        }
        if (this.zPort != null) {
            n += this.zPort.hashCode();
        }
        return n;
    }

    public boolean equals(String string, Integer n) {
        if (this.zAddresses != string) {
            if (this.zAddresses == null) {
                return false;
            }
            if (!this.zAddresses.equals(string)) {
                return false;
            }
        }
        if (this.zPort != n) {
            if (this.zPort == null) {
                return false;
            }
            if (!this.zPort.equals(n)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(PeerInfo peerInfo) {
        return peerInfo == null ? false : this.equals(peerInfo.zAddresses, peerInfo.zPort);
    }

    public boolean equals(Object object) {
        if (object instanceof PeerInfo) {
            return this.equals((PeerInfo)object);
        }
        return false;
    }

    public String toString() {
        String string = this.zID + " " + this.zChatName + " " + this.zAddresses + ":" + (this.zPort != null ? this.zPort.toString() : "?");
        String[] stringArray = this.getOldChatNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + " -> " + stringArray[i];
            }
        }
        return string;
    }

    public int incrementFailureCount() {
        return ++this.failureCount;
    }

    public void setFailureReason(IOException iOException) {
    }
}

