/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerReader
extends Thread {
    private Vector zLines = new Vector();
    private BufferedReader zReader;
    private boolean isOpen = true;

    public PeerReader(InputStream inputStream) {
        IllegalArgument.ifNull("Is", inputStream);
        this.zReader = new BufferedReader(new InputStreamReader(inputStream));
        this.start();
    }

    public synchronized void close() {
        this.isOpen = false;
        this.notifyAll();
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    private synchronized void add(String string) {
        if (this.isOpen) {
            this.zLines.addElement(string);
        }
        this.notifyAll();
    }

    public synchronized String readLine() {
        while (this.isOpen && this.zLines.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        String string = null;
        if (this.isOpen && this.zLines.size() > 0) {
            string = (String)this.zLines.elementAt(0);
            this.zLines.removeElementAt(0);
        }
        return string;
    }

    public void run() {
        try {
            String string;
            while (null != (string = this.zReader.readLine())) {
                this.add(string);
                if (!string.equals("BYE")) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isOpen = false;
        try {
            this.zReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

