/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TreeSearchable
extends AbstractSearchable {
    protected JXTree tree;

    public TreeSearchable(JXTree tree) {
        this.tree = tree;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult searchResult = null;
        if (backwards) {
            for (int index = startRow; index >= 0 && searchResult == null; --index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        } else {
            for (int index = startRow; index < this.getSize() && searchResult == null; ++index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        }
        this.updateState(searchResult);
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row);
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
        Matcher matcher;
        String text = this.tree.getStringAt(row);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, -1);
        }
        return null;
    }

    protected int getSize() {
        return this.tree.getRowCount();
    }

    protected boolean hasMatch(AbstractSearchable.SearchResult result) {
        return result.getFoundRow() >= 0;
    }

    protected void moveMatchMarker() {
        if (!this.hasMatch(this.lastSearchResult)) {
            return;
        }
        this.tree.setSelectionRow(this.lastSearchResult.foundRow);
        this.tree.scrollRowToVisible(this.lastSearchResult.foundRow);
    }
}

