/*
 *
 * Copyright (c) 2000-2007 by Rodney Kinney
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License (LGPL) as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, copies are available
 * at http://www.opensource.org.
 */
package VASSAL.chat.peer2peer;

import java.util.Properties;
import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.i18n.Resources;

/**
 * @author rkinney
 */
public class P2PClientFactory extends ChatServerFactory {
  public static final String P2P_TYPE="peer2peer"; //$NON-NLS-1$

  public ChatServerConnection buildServer(Properties param) {
    HttpMessageServer httpMessageServer = new HttpMessageServer(new PeerPoolInfo() {
        public String getModuleName() {
          return GameModule.getGameModule() == null ? Resources.getString("Chat.unknown_module") : GameModule.getGameModule().getGameName(); //$NON-NLS-1$
        }

        public String getUserName() {
          return GameModule.getUserId();
        }
      
    });
    P2PClient server = new P2PClient(GameModule.getGameModule(),httpMessageServer,httpMessageServer,new DirectPeerPool());
    server.addPropertyChangeListener(ChatServerConnection.INCOMING_MSG, new CommandDecoder());
    return server;
  }
}
