/*
 *
 * Copyright (c) 2000-2007 by Rodney Kinney
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License (LGPL) as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, copies are available
 * at http://www.opensource.org.
 */
package VASSAL.chat.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.SoundEncoder;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;

/**
 * Copyright (c) 2003 by Rodney Kinney. All rights reserved. Date: Jul 29, 2003
 */
public class SendSoundAction extends AbstractAction {
  private static final long serialVersionUID = 1L;

  private ChatServerConnection client;
  private Player target;
  private String soundKey;

  public SendSoundAction(String name, ChatServerConnection client, String soundKey, Player target) {
    super(name);
    this.client = client;
    this.soundKey = soundKey;
    this.target = target;
  }

  public void actionPerformed(ActionEvent e) {
    client.sendTo(target, new SoundEncoder.Cmd(soundKey));
  }

  public static PlayerActionFactory factory(final ChatServerConnection client, final String name, final String soundKey, final String defaultSoundFile) {
    if (GameModule.getGameModule() != null) {
      Prefs.getGlobalPrefs().addOption(Resources.getString("Prefs.sounds_tab"), new SoundConfigurer(soundKey, name, defaultSoundFile)); //$NON-NLS-1$
    }
    return new PlayerActionFactory() {
      public Action getAction(Player p, JTree tree) {
        return new SendSoundAction(name, client, soundKey, p);
      }
    };
  }
}
