/*
 * Decompiled with CFR 0.152.
 */
package VASSAL;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public final class Info {
    private static final String VERSION = "2.9.9";
    private static Boolean is2dEnabled;
    private static Boolean isDndEnabled;

    private Info() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isDndEnabled() {
        if (isDndEnabled == null) {
            try {
                Class.forName("java.awt.dnd.DropTarget");
                isDndEnabled = Boolean.TRUE;
            }
            catch (ClassNotFoundException classNotFoundException) {
                isDndEnabled = Boolean.FALSE;
            }
        }
        return isDndEnabled;
    }

    public static Rectangle getScreenBounds(Component component) {
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.translate(insets.left, insets.top);
        rectangle.setSize(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        return rectangle;
    }

    public static boolean is2dEnabled() {
        if (is2dEnabled == null) {
            try {
                Class.forName("java.awt.Graphics2D");
                is2dEnabled = Boolean.TRUE;
            }
            catch (ClassNotFoundException classNotFoundException) {
                is2dEnabled = Boolean.FALSE;
            }
        }
        return is2dEnabled;
    }

    public static boolean isMacOsX() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("mac") >= 0 && string.toLowerCase().indexOf("x") > 0;
    }

    public static int compareVersions(String string, String string2) {
        try {
            int n = string.indexOf("b");
            int n2 = string2.indexOf("b");
            if (n > 0) {
                if (n2 > 0) {
                    return Info.compareVersions(string.substring(0, n), string2.substring(0, n2)) < 0 ? -1 : Integer.parseInt(string.substring(n + 1)) - Integer.parseInt(string2.substring(n2 + 1));
                }
                return Info.compareVersions(string.substring(0, n), string2) > 0 ? 1 : -1;
            }
            if (n2 > 0) {
                return Info.compareVersions(string, string2.substring(0, n2)) < 0 ? -1 : 1;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                int n3 = Integer.parseInt(stringTokenizer.nextToken()) - Integer.parseInt(stringTokenizer2.nextToken());
                if (n3 == 0) continue;
                return n3;
            }
            if (stringTokenizer.hasMoreTokens()) {
                return 1;
            }
            if (stringTokenizer2.hasMoreTokens()) {
                return -1;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Invalid version format :" + string + ", " + string2);
            return 0;
        }
    }
}

