/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractBuildable
implements Buildable,
ValidityChecker {
    protected List buildComponents = new ArrayList();
    protected ValidityChecker validator;

    public void build(Element element) {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                this.setAttribute(attr.getName(), attr.getValue());
            }
            Builder.build(element, this);
        }
    }

    public abstract String[] getAttributeNames();

    public abstract void setAttribute(String var1, Object var2);

    public abstract String getAttributeValueString(String var1);

    public Enumeration getComponents(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.buildComponents.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            arrayList.add(e);
        }
        return Collections.enumeration(arrayList);
    }

    public Enumeration getAllDescendantComponents(Class clazz) {
        ArrayList arrayList = new ArrayList();
        this.addComponents(clazz, arrayList);
        return Collections.enumeration(arrayList);
    }

    private void addComponents(Class clazz, ArrayList arrayList) {
        if (clazz.isInstance(this)) {
            arrayList.add(this);
        }
        Iterator iterator = this.buildComponents.iterator();
        while (iterator.hasNext()) {
            Buildable buildable = (Buildable)iterator.next();
            if (clazz.isInstance(buildable)) {
                arrayList.add(buildable);
                continue;
            }
            if (!(buildable instanceof AbstractBuildable)) continue;
            ((AbstractBuildable)buildable).addComponents(clazz, arrayList);
        }
    }

    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.getAttributeValueString(stringArray[i]);
            if (string == null) continue;
            element.setAttribute(stringArray[i], string);
        }
        Enumeration enumeration = this.getBuildComponents();
        while (enumeration.hasMoreElements()) {
            element.appendChild(((Buildable)enumeration.nextElement()).getBuildElement(document));
        }
        return element;
    }

    public void add(Buildable buildable) {
        this.buildComponents.add(buildable);
    }

    public Enumeration getBuildComponents() {
        return Collections.enumeration(this.buildComponents);
    }

    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (this.validator != null) {
            this.validator.validate(buildable, validationReport);
        }
        Iterator iterator = this.buildComponents.iterator();
        while (iterator.hasNext()) {
            Buildable buildable2 = (Buildable)iterator.next();
            if (!(buildable2 instanceof ValidityChecker)) continue;
            ((ValidityChecker)((Object)buildable2)).validate(buildable2, validationReport);
        }
    }

    public abstract /* synthetic */ void addTo(Buildable var1);
}

