/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Builder {
    public static void build(Element element, Buildable buildable) {
        if (element != null) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                try {
                    Buildable buildable2 = Builder.create((Element)node);
                    if (buildable == null) continue;
                    buildable2.addTo(buildable);
                    buildable.add(buildable2);
                    continue;
                }
                catch (Throwable throwable) {
                    String string = throwable.getMessage();
                    if (string == null) {
                        string = throwable.getClass().getName().substring(throwable.getClass().getName().lastIndexOf(".") + 1);
                    }
                    System.err.println(node.toString());
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Unable to create class " + ((Element)node).getTagName() + " in " + GameModule.getGameModule().getDataArchive().getName() + "\n" + string, "Error", 0);
                }
            }
        }
    }

    public static Buildable create(Element element) throws Exception {
        Buildable buildable = GameModule.getGameModule() == null ? (Buildable)Class.forName(element.getTagName()).newInstance() : (Buildable)GameModule.getGameModule().getDataArchive().loadClass(element.getTagName()).newInstance();
        buildable.build(element);
        return buildable;
    }

    public static Document createDocument(InputStream inputStream) throws IOException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static Document createNewDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(writer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new IOException(transformerFactoryConfigurationError.getMessage());
        }
    }

    public static String getText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3) {
                stringBuffer.append(((Text)nodeList.item(i)).getData());
                continue;
            }
            if (nodeList.item(i).getNodeType() != 5) continue;
            stringBuffer.append(nodeList.item(i).getFirstChild().toString());
        }
        return stringBuffer.toString().trim();
    }

    public static String toString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            Builder.writeDocument(document, stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static String toString(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Builder.appendToBuffer(node, "", stringBuffer);
        return stringBuffer.toString();
    }

    static void appendToBuffer(Node node, String string, StringBuffer stringBuffer) {
        try {
            switch (node.getNodeType()) {
                case 1: {
                    int n;
                    stringBuffer.append(string).append("<").append(((Element)node).getTagName());
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        Builder.appendToBuffer(namedNodeMap.item(n), "", stringBuffer);
                    }
                    n = 0;
                    Vector<Node> vector = new Vector<Node>();
                    string = string.concat("  ");
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        if (node2.getNodeType() != 2) {
                            vector.addElement(node2);
                        }
                        n = n != 0 || node2.getNodeType() == 3 ? 1 : 0;
                    }
                    if (vector.size() == 0) {
                        stringBuffer.append("/>\n");
                    } else {
                        stringBuffer.append(n != 0 ? ">" : ">\n");
                        for (int i = 0; i < vector.size(); ++i) {
                            Builder.appendToBuffer((Node)vector.elementAt(i), string, stringBuffer);
                        }
                        if (n == 0) {
                            stringBuffer.append(string.substring(2));
                        }
                        stringBuffer.append("</").append(((Element)node).getTagName()).append(">\n");
                    }
                    string = string.substring(2);
                    vector = null;
                    break;
                }
                case 2: {
                    Attr attr = (Attr)node;
                    stringBuffer.append(" ").append(attr.getName()).append("=\"").append(Builder.encodedText(attr.getValue())).append("\"");
                    break;
                }
                case 3: {
                    String string2 = ((Text)node).getData();
                    if (string2 != null) {
                        stringBuffer.append(Builder.encodedText(string2));
                    }
                    break;
                }
                case 9: {
                    stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                    Builder.appendToBuffer(((Document)node).getDocumentElement(), "", stringBuffer);
                    break;
                }
                default: {
                    System.err.println("Not translating " + node.getClass().getName());
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("writing " + Builder.toString(node));
            System.err.println("Size is " + stringBuffer.length());
        }
    }

    static String encodedText(String string) {
        int n = string.indexOf(38);
        while (n >= 0) {
            string = string.substring(0, n).concat("&amp;").concat(string.substring(n + 1));
            n = string.indexOf(38, n + 1);
        }
        n = string.indexOf(62);
        while (n >= 0) {
            string = string.substring(0, n).concat("&gt;").concat(string.substring(n + 1));
            n = string.indexOf(62);
        }
        n = string.indexOf(60);
        while (n >= 0) {
            string = string.substring(0, n).concat("&lt;").concat(string.substring(n + 1));
            n = string.indexOf(60);
        }
        n = string.indexOf(34);
        while (n >= 0) {
            string = string.substring(0, n).concat("&quot;").concat(string.substring(n + 1));
            n = string.indexOf(34);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Document document = Builder.createNewDocument();
        Element element = document.createElement("test");
        Element element2 = document.createElement("sub1");
        element.appendChild(element2);
        Element element3 = document.createElement("sub2");
        element3.setAttribute("one", "1");
        element3.setAttribute("two", "2");
        element.appendChild(element3);
        Element element4 = document.createElement("sub3");
        Element element5 = document.createElement("sub4");
        element5.appendChild(document.createTextNode("4 > 2"));
        element4.appendChild(element5);
        element.appendChild(element4);
        document.appendChild(element);
        System.err.println(Builder.toString(document));
        System.err.println("StringBuffer");
        StringBuffer stringBuffer = new StringBuffer(300000);
        for (int i = 0; i < 500000; ++i) {
            stringBuffer.append("  ");
            if (i % 10000 != 0) continue;
            System.err.println("" + stringBuffer.length());
        }
    }
}

