/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.ServerConnection;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.GlobalPropertiesContainer;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.MandatoryComponent;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.FileChooser;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.MTRandom;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;

public abstract class GameModule
extends AbstractConfigurable
implements CommandEncoder,
ToolBarComponent,
PropertySource,
GlobalPropertiesContainer {
    protected static final String DEFAULT_NAME = "Unnamed module";
    public static final String MODULE_NAME = "name";
    public static final String MODULE_VERSION = "version";
    public static final String VASSAL_VERSION_CREATED = "VassalVersion";
    public static final String VASSAL_VERSION_RUNNING = "runningVassalVersion";
    private static GameModule theModule;
    protected String moduleVersion = "0.0";
    protected String vassalVersionCreated = "0.0";
    protected String gameName = "Unnamed module";
    protected String lastSavedConfiguration;
    protected FileChooser fileChooser;
    protected FileDialog fileDialog;
    protected java.util.Map globalProperties = new HashMap();
    protected JPanel controlPanel = new JPanel();
    private JToolBar toolBar = new JToolBar();
    private JMenu fileMenu = new JMenu("File");
    protected GameState theState;
    protected DataArchive archive;
    protected Prefs preferences;
    protected Prefs globalPrefs;
    protected Logger logger;
    protected Chatter chat;
    protected Random RNG;
    protected ServerConnection server;
    protected JFrame frame = new JFrame();
    protected Vector keyStrokeSources = new Vector();
    protected Vector keyStrokeListeners = new Vector();
    protected CommandEncoder[] commandEncoders = new CommandEncoder[0];
    public static final String REAL_NAME = "RealName";
    public static final String SECRET_NAME = "SecretName";
    public static final String PERSONAL_INFO = "Profile";
    private static final String SAVE_DIR = "SaveDir";
    private static String userId;
    private PropertyChangeListener globalPropertyListener;
    static /* synthetic */ Class class$VASSAL$build$module$Documentation;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalOptions;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$Map;
    static /* synthetic */ Class class$VASSAL$build$module$PieceWindow;
    static /* synthetic */ Class class$VASSAL$build$module$PrototypesContainer;
    static /* synthetic */ Class class$VASSAL$build$module$ToolbarMenu;
    static /* synthetic */ Class class$VASSAL$build$module$MultiActionButton;
    static /* synthetic */ Class class$VASSAL$build$module$DiceButton;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalKeyCommand;
    static /* synthetic */ Class class$VASSAL$build$module$Inventory;
    static /* synthetic */ Class class$VASSAL$build$module$RandomTextButton;
    static /* synthetic */ Class class$VASSAL$build$module$SpecialDiceButton;
    static /* synthetic */ Class class$VASSAL$build$module$PredefinedSetup;
    static /* synthetic */ Class class$VASSAL$build$module$ChartWindow;
    static /* synthetic */ Class class$VASSAL$build$module$PrivateMap;
    static /* synthetic */ Class class$VASSAL$build$module$PlayerHand;
    static /* synthetic */ Class class$VASSAL$build$module$NotesWindow;
    static /* synthetic */ Class class$VASSAL$build$module$ModuleExtension;
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperties;
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperty;

    public JFrame getFrame() {
        return this.frame;
    }

    protected GameModule(DataArchive dataArchive) {
        this.frame.setDefaultCloseOperation(0);
        this.archive = dataArchive;
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameModule.this.quit();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.setJMenuBar(new JMenuBar());
        this.fileMenu.setMnemonic('F');
        this.frame.getJMenuBar().add(this.fileMenu);
        this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
        this.frame.getContentPane().add((Component)this.toolBar, "North");
        this.controlPanel.setLayout(new BorderLayout());
        this.addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        this.frame.getContentPane().add((Component)this.controlPanel, "Center");
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, class$VASSAL$build$module$Documentation == null ? (class$VASSAL$build$module$Documentation = GameModule.class$("VASSAL.build.module.Documentation")) : class$VASSAL$build$module$Documentation), new MandatoryComponent(this, class$VASSAL$build$module$GlobalOptions == null ? (class$VASSAL$build$module$GlobalOptions = GameModule.class$("VASSAL.build.module.GlobalOptions")) : class$VASSAL$build$module$GlobalOptions));
    }

    protected abstract void build() throws IOException;

    public void setAttribute(String string, Object object) {
        if (MODULE_NAME.equals(string)) {
            this.gameName = (String)object;
            this.setConfigureName(this.gameName);
        } else if (MODULE_VERSION.equals(string)) {
            this.moduleVersion = (String)object;
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            this.vassalVersionCreated = (String)object;
            String string2 = Info.getVersion();
            if (Info.compareVersions(this.vassalVersionCreated, string2) > 0) {
                JOptionPane.showMessageDialog(null, "This module was created using version " + object + " of the VASSAL engine\nYou are using version " + string2 + "\nIt's recommended you upgrade to the latest version of the VASSAL engine.", "Older version in use", 0);
            }
        }
    }

    public String getAttributeValueString(String string) {
        if (MODULE_NAME.equals(string)) {
            return this.gameName;
        }
        if (MODULE_VERSION.equals(string)) {
            return this.moduleVersion;
        }
        if (VASSAL_VERSION_CREATED.equals(string)) {
            return this.vassalVersionCreated;
        }
        if (VASSAL_VERSION_RUNNING.equals(string)) {
            return Info.getVersion();
        }
        return null;
    }

    public static int compareVersions(String string, String string2) {
        return Info.compareVersions(string, string2);
    }

    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Module";
    }

    public void removeFrom(Buildable buildable) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm");
    }

    public String[] getAttributeNames() {
        return new String[]{MODULE_NAME, MODULE_VERSION, VASSAL_VERSION_CREATED};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Game Name", "Version No."};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = GameModule.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = GameModule.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray = new Class[]{class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = GameModule.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map, class$VASSAL$build$module$PieceWindow == null ? (class$VASSAL$build$module$PieceWindow = GameModule.class$("VASSAL.build.module.PieceWindow")) : class$VASSAL$build$module$PieceWindow, class$VASSAL$build$module$PrototypesContainer == null ? (class$VASSAL$build$module$PrototypesContainer = GameModule.class$("VASSAL.build.module.PrototypesContainer")) : class$VASSAL$build$module$PrototypesContainer, class$VASSAL$build$module$ToolbarMenu == null ? (class$VASSAL$build$module$ToolbarMenu = GameModule.class$("VASSAL.build.module.ToolbarMenu")) : class$VASSAL$build$module$ToolbarMenu, class$VASSAL$build$module$MultiActionButton == null ? (class$VASSAL$build$module$MultiActionButton = GameModule.class$("VASSAL.build.module.MultiActionButton")) : class$VASSAL$build$module$MultiActionButton, class$VASSAL$build$module$DiceButton == null ? (class$VASSAL$build$module$DiceButton = GameModule.class$("VASSAL.build.module.DiceButton")) : class$VASSAL$build$module$DiceButton, class$VASSAL$build$module$GlobalKeyCommand == null ? (class$VASSAL$build$module$GlobalKeyCommand = GameModule.class$("VASSAL.build.module.GlobalKeyCommand")) : class$VASSAL$build$module$GlobalKeyCommand, class$VASSAL$build$module$Inventory == null ? (class$VASSAL$build$module$Inventory = GameModule.class$("VASSAL.build.module.Inventory")) : class$VASSAL$build$module$Inventory, class$VASSAL$build$module$RandomTextButton == null ? (class$VASSAL$build$module$RandomTextButton = GameModule.class$("VASSAL.build.module.RandomTextButton")) : class$VASSAL$build$module$RandomTextButton, class$VASSAL$build$module$SpecialDiceButton == null ? (class$VASSAL$build$module$SpecialDiceButton = GameModule.class$("VASSAL.build.module.SpecialDiceButton")) : class$VASSAL$build$module$SpecialDiceButton, class$VASSAL$build$module$PredefinedSetup == null ? (class$VASSAL$build$module$PredefinedSetup = GameModule.class$("VASSAL.build.module.PredefinedSetup")) : class$VASSAL$build$module$PredefinedSetup, class$VASSAL$build$module$ChartWindow == null ? (class$VASSAL$build$module$ChartWindow = GameModule.class$("VASSAL.build.module.ChartWindow")) : class$VASSAL$build$module$ChartWindow, class$VASSAL$build$module$PrivateMap == null ? (class$VASSAL$build$module$PrivateMap = GameModule.class$("VASSAL.build.module.PrivateMap")) : class$VASSAL$build$module$PrivateMap, class$VASSAL$build$module$PlayerHand == null ? (class$VASSAL$build$module$PlayerHand = GameModule.class$("VASSAL.build.module.PlayerHand")) : class$VASSAL$build$module$PlayerHand, class$VASSAL$build$module$NotesWindow == null ? (class$VASSAL$build$module$NotesWindow = GameModule.class$("VASSAL.build.module.NotesWindow")) : class$VASSAL$build$module$NotesWindow};
        return classArray;
    }

    public void addKeyStrokeSource(KeyStrokeSource keyStrokeSource) {
        this.keyStrokeSources.addElement(keyStrokeSource);
        for (int i = 0; i < this.keyStrokeListeners.size(); ++i) {
            ((KeyStrokeListener)this.keyStrokeListeners.elementAt(i)).addKeyStrokeSource(keyStrokeSource);
        }
    }

    public void addKeyStrokeListener(KeyStrokeListener keyStrokeListener) {
        this.keyStrokeListeners.addElement(keyStrokeListener);
        for (int i = 0; i < this.keyStrokeSources.size(); ++i) {
            keyStrokeListener.addKeyStrokeSource((KeyStrokeSource)this.keyStrokeSources.elementAt(i));
        }
    }

    public void fireKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            Iterator iterator = ((AbstractList)this.keyStrokeListeners).iterator();
            while (iterator.hasNext()) {
                KeyStrokeListener keyStrokeListener = (KeyStrokeListener)iterator.next();
                keyStrokeListener.keyPressed(keyStroke);
            }
        }
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getGameVersion() {
        return this.moduleVersion;
    }

    public Prefs getPrefs() {
        if (this.preferences == null) {
            this.setPrefs(new Prefs(this.globalPrefs.getEditor(), this.gameName));
        }
        return this.preferences;
    }

    public Prefs getGlobalPrefs() {
        return this.globalPrefs;
    }

    public void addCommandEncoder(CommandEncoder commandEncoder) {
        CommandEncoder[] commandEncoderArray = this.commandEncoders;
        this.commandEncoders = new CommandEncoder[commandEncoderArray.length + 1];
        System.arraycopy(commandEncoderArray, 0, this.commandEncoders, 0, commandEncoderArray.length);
        this.commandEncoders[commandEncoderArray.length] = commandEncoder;
    }

    public void removeCommandEncoder(CommandEncoder commandEncoder) {
        for (int i = 0; i < this.commandEncoders.length; ++i) {
            if (!commandEncoder.equals(this.commandEncoders[i])) continue;
            CommandEncoder[] commandEncoderArray = this.commandEncoders;
            this.commandEncoders = new CommandEncoder[commandEncoderArray.length - 1];
            System.arraycopy(commandEncoderArray, 0, this.commandEncoders, 0, i);
            if (i >= this.commandEncoders.length) break;
            System.arraycopy(commandEncoderArray, i + 1, this.commandEncoders, i, this.commandEncoders.length - i);
            break;
        }
    }

    public GamePiece createPiece(String string) {
        for (int i = 0; i < this.commandEncoders.length; ++i) {
            GamePiece gamePiece;
            if (!(this.commandEncoders[i] instanceof BasicCommandEncoder) || (gamePiece = ((BasicCommandEncoder)this.commandEncoders[i]).createPiece(string)) == null) continue;
            return gamePiece;
        }
        return null;
    }

    public GamePiece createPiece(String string, GamePiece gamePiece) {
        for (int i = 0; i < this.commandEncoders.length; ++i) {
            Decorator decorator;
            if (!(this.commandEncoders[i] instanceof BasicCommandEncoder) || (decorator = ((BasicCommandEncoder)this.commandEncoders[i]).createDecorator(string, gamePiece)) == null) continue;
            return decorator;
        }
        return null;
    }

    public void warn(String string) {
        this.chat.show(" - " + string);
    }

    public Random getRNG() {
        if (this.RNG == null) {
            this.RNG = new MTRandom();
        }
        return this.RNG;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setChatter(Chatter chatter) {
        this.chat = chatter;
    }

    public JComponent getControlPanel() {
        return this.controlPanel;
    }

    public Chatter getChatter() {
        return this.chat;
    }

    public void setPrefs(Prefs prefs) {
        this.preferences = prefs;
        this.preferences.getEditor().initDialog(this.getFrame());
    }

    public void setGlobalPrefs(Prefs prefs) {
        this.globalPrefs = prefs;
    }

    public Command decode(String string) {
        if (string == null) {
            return null;
        }
        Command command = null;
        for (int i = 0; i < this.commandEncoders.length && command == null; ++i) {
            command = this.commandEncoders[i].decode(string);
        }
        if (command == null) {
            System.err.println("Failed to decode " + string);
        }
        return command;
    }

    public String encode(Command command) {
        if (command == null) {
            return null;
        }
        String string = null;
        for (int i = 0; i < this.commandEncoders.length && string == null; ++i) {
            string = this.commandEncoders[i].encode(command);
        }
        if (string == null) {
            System.err.println("Failed to encode " + command);
        }
        return string;
    }

    public FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.getPrefs().addOption(null, new DirectoryConfigurer(SAVE_DIR, null));
            this.fileChooser = FileChooser.createFileChooser(this.getFrame());
            File file = (File)this.getPrefs().getValue(SAVE_DIR);
            if (file != null) {
                this.fileChooser.setCurrentDirectory(file);
            }
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    public FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.getPrefs().addOption(null, new DirectoryConfigurer(SAVE_DIR, null));
            this.fileDialog = new FileDialog(this.getFrame());
            File file = (File)this.getPrefs().getValue(SAVE_DIR);
            if (file != null) {
                this.fileDialog.setDirectory(file.getPath());
            }
            this.fileDialog.setModal(true);
        } else {
            this.fileDialog.setDirectory(this.fileDialog.getDirectory());
        }
        return this.fileDialog;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public void appendToTitle(String string) {
        if (string == null) {
            this.frame.setTitle(this.gameName + " controls");
        } else {
            this.frame.setTitle(this.frame.getTitle() + string);
        }
        Enumeration enumeration = this.getComponents(class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = GameModule.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map);
        while (enumeration.hasMoreElements()) {
            ((Map)enumeration.nextElement()).appendToTitle(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        boolean bl = false;
        try {
            this.getGameState().setup(false);
            bl = this.getGameState().isGameStarted();
            if (!bl) {
                if (this.fileChooser != null) {
                    this.getPrefs().getOption(SAVE_DIR).setValue(this.fileChooser.getCurrentDirectory());
                }
                this.getPrefs().write();
                if (this.getDataArchive() instanceof ArchiveWriter && !this.buildString().equals(this.lastSavedConfiguration)) {
                    switch (JOptionPane.showConfirmDialog(this.frame, "Save Module?", "", 1)) {
                        case 0: {
                            this.save();
                            break;
                        }
                        case 2: {
                            bl = true;
                        }
                    }
                } else if (this.getArchiveWriter() != null) {
                    Enumeration enumeration = this.getComponents(class$VASSAL$build$module$ModuleExtension == null ? (class$VASSAL$build$module$ModuleExtension = GameModule.class$("VASSAL.build.module.ModuleExtension")) : class$VASSAL$build$module$ModuleExtension);
                    while (enumeration.hasMoreElements()) {
                        ModuleExtension moduleExtension = (ModuleExtension)enumeration.nextElement();
                        bl = !moduleExtension.confirmExit();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (!bl) {
                System.exit(0);
            }
        }
    }

    public void sendAndLog(Command command) {
        if (command != null && !command.isNull()) {
            this.getServer().sendToOthers(command);
            this.getLogger().log(command);
        }
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String string) {
        userId = string;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public static void init(GameModule gameModule) throws IOException {
        if (theModule != null) {
            throw new IOException("Module " + theModule.getDataArchive().getName() + " is already open");
        }
        theModule = gameModule;
        try {
            theModule.build();
        }
        catch (IOException iOException) {
            theModule = null;
            throw iOException;
        }
        if (theModule.getDataArchive() instanceof ArchiveWriter) {
            GameModule.theModule.lastSavedConfiguration = theModule.buildString();
        }
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public ArchiveWriter getArchiveWriter() {
        return this.archive.getWriter();
    }

    public static GameModule getGameModule() {
        return theModule;
    }

    public GameState getGameState() {
        return this.theState;
    }

    public void saveAs() {
        this.save(true);
    }

    public void save() {
        this.save(false);
    }

    protected void save(boolean bl) {
        this.vassalVersionCreated = Info.getVersion();
        try {
            String string = this.buildString();
            this.getArchiveWriter().addFile("buildFile", new ByteArrayInputStream(string.getBytes("UTF-8")));
            if (bl) {
                this.getArchiveWriter().saveAs();
            } else {
                this.getArchiveWriter().write();
            }
            this.lastSavedConfiguration = string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Couldn't save module.\n" + iOException.getMessage(), "Unable to save", 0);
        }
    }

    protected String buildString() {
        Document document = Builder.createNewDocument();
        document.appendChild(this.getBuildElement(document));
        return Builder.toString(document);
    }

    public Object getProperty(Object object) {
        if ("playerSide".equals(object)) {
            String string = PlayerRoster.getMySide();
            return string == null ? "" : string;
        }
        if ("playerName".equals(object)) {
            return this.getPrefs().getValue(REAL_NAME);
        }
        if ("playerId".equals(object)) {
            return GlobalOptions.getInstance().getPlayerId();
        }
        return this.globalProperties.get(object);
    }

    public PropertyChangeListener getPropertyListener() {
        if (this.globalPropertyListener == null) {
            this.globalPropertyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GameModule.this.globalProperties.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
                    Iterator iterator = Map.getAllMaps();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        map.repaint();
                    }
                }
            };
        }
        return this.globalPropertyListener;
    }

    public GlobalProperty getGlobalProperty(String string) {
        GlobalProperty globalProperty = null;
        Enumeration enumeration = this.getComponents(class$VASSAL$build$module$properties$GlobalProperties == null ? (class$VASSAL$build$module$properties$GlobalProperties = GameModule.class$("VASSAL.build.module.properties.GlobalProperties")) : class$VASSAL$build$module$properties$GlobalProperties);
        if (enumeration != null) {
            Enumeration enumeration2 = ((GlobalProperties)enumeration.nextElement()).getComponents(class$VASSAL$build$module$properties$GlobalProperty == null ? (class$VASSAL$build$module$properties$GlobalProperty = GameModule.class$("VASSAL.build.module.properties.GlobalProperty")) : class$VASSAL$build$module$properties$GlobalProperty);
            while (enumeration2.hasMoreElements() && globalProperty == null) {
                GlobalProperty globalProperty2 = (GlobalProperty)enumeration2.nextElement();
                if (!globalProperty2.getConfigureName().equals(string)) continue;
                globalProperty = globalProperty2;
            }
        }
        return globalProperty;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        userId = null;
    }
}

