/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpFile;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class Widget
extends AbstractConfigurable {
    public static final String NAME = "entryName";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    protected Element buildElement;
    protected Widget parent;

    protected Widget() {
    }

    public void build(Element element) {
        this.buildElement = element;
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                ((AbstractBuildable)this).setAttribute(attr.getName(), attr.getValue());
            }
        }
    }

    protected void rebuild() {
        if (this.buildElement != null) {
            Builder.build(this.buildElement, this);
            this.buildElement = null;
        }
    }

    public Element getBuildElement(Document document) {
        this.rebuild();
        return super.getBuildElement(document);
    }

    public Class[] getAllowableConfigureComponents() {
        return this.parent.getAllowableConfigureComponents();
    }

    public void addTo(Buildable buildable) {
        this.parent = (Widget)buildable;
    }

    public void removeFrom(Buildable buildable) {
    }

    public Widget getParent() {
        return this.parent;
    }

    public Configurable[] getConfigureComponents() {
        this.rebuild();
        return super.getConfigureComponents();
    }

    public abstract Component getComponent();

    public HelpFile getHelpFile() {
        return null;
    }

    public static class MyCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Configurable) {
                this.setText(((Configurable)object).getConfigureName());
            }
            return this;
        }
    }
}

