/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.FileChooser;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.Obfuscator;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicLogger
implements Logger,
Buildable,
GameComponent,
CommandEncoder {
    public static final String BEGIN = "begin_log";
    public static final String END = "end_log";
    public static final String LOG = "LOG\t";
    protected static final String STEP_ICON = "/images/StepForward16.gif";
    protected static final String UNDO_ICON = "/images/Undo16.gif";
    protected List logInput;
    protected List logOutput;
    protected int nextInput = 0;
    protected int nextUndo = -1;
    protected Command beginningState;
    protected File outputFile;
    protected Action stepAction = new StepAction();
    protected Action undoAction = new UndoAction();
    protected Action endLogAction = new AbstractAction("End Logfile"){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BasicLogger.this.write();
                GameModule.getGameModule().warn("Logfile written.");
                BasicLogger.this.newLogAction.setEnabled(true);
                GameModule.getGameModule().appendToTitle(null);
            }
            catch (IOException iOException) {
                String string = "Unable to write to " + BasicLogger.this.outputFile;
                if (iOException.getMessage() != null) {
                    string = string + ".\n" + iOException.getMessage();
                }
                JOptionPane.showMessageDialog(GameModule.getGameModule().getFrame(), string, "Save failed", 0);
            }
        }
    };
    protected Action newLogAction = new AbstractAction("Begin Logfile"){

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.beginOutput();
        }
    };

    public BasicLogger() {
        this.stepAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.endLogAction.setEnabled(false);
        this.newLogAction.setEnabled(false);
        this.logInput = new ArrayList();
        this.logOutput = new ArrayList();
    }

    public void build(Element element) {
    }

    public void addTo(Buildable buildable) {
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getFileMenu().add(this.newLogAction).setMnemonic('B');
        JButton jButton = GameModule.getGameModule().getToolBar().add(this.undoAction);
        jButton.setToolTipText("Undo last move");
        jButton.setAlignmentY(0.0f);
        jButton = GameModule.getGameModule().getToolBar().add(this.stepAction);
        jButton.setToolTipText("Step forward through logfile [Page Down]");
        jButton.setAlignmentY(0.0f);
        GameModule.getGameModule().getFileMenu().add(this.endLogAction).setMnemonic('E');
        final KeyStrokeListener keyStrokeListener = new KeyStrokeListener(this.stepAction, KeyStroke.getKeyStroke(34, 0));
        GameModule.getGameModule().addKeyStrokeListener(keyStrokeListener);
        KeyStrokeListener keyStrokeListener2 = new KeyStrokeListener(this.newLogAction, KeyStroke.getKeyStroke(87, 8));
        GameModule.getGameModule().addKeyStrokeListener(keyStrokeListener2);
        GameModule.getGameModule().getFrame().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                GameModule.getGameModule().getFrame().removeComponentListener(this);
                IconConfigurer iconConfigurer = new IconConfigurer("stepIcon", "Step forward button icon", BasicLogger.STEP_ICON);
                iconConfigurer.setValue(BasicLogger.STEP_ICON);
                GlobalOptions.getInstance().addOption(iconConfigurer);
                iconConfigurer.addPropertyChangeListener(new PropertyChangeListener(this, iconConfigurer){
                    private final /* synthetic */ IconConfigurer val$stepIconConfig;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$stepIconConfig = iconConfigurer;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        1.access$000(this.this$1).stepAction.putValue("SmallIcon", this.val$stepIconConfig.getIconValue());
                    }
                });
                iconConfigurer.fireUpdate();
                IconConfigurer iconConfigurer2 = new IconConfigurer("undoIcon", "Undo button icon", BasicLogger.UNDO_ICON);
                iconConfigurer2.setValue(BasicLogger.UNDO_ICON);
                GlobalOptions.getInstance().addOption(iconConfigurer2);
                iconConfigurer2.addPropertyChangeListener(new PropertyChangeListener(this, iconConfigurer2){
                    private final /* synthetic */ IconConfigurer val$undoIconConfig;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$undoIconConfig = iconConfigurer;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        1.access$000(this.this$1).undoAction.putValue("SmallIcon", this.val$undoIconConfig.getIconValue());
                    }
                });
                iconConfigurer2.fireUpdate();
                HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer("stepHotKey", "Step forward hotkey", keyStrokeListener.getKeyStroke());
                GlobalOptions.getInstance().addOption(hotKeyConfigurer);
                hotKeyConfigurer.addPropertyChangeListener(new PropertyChangeListener(this, hotKeyConfigurer){
                    private final /* synthetic */ HotKeyConfigurer val$stepKeyConfig;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$stepKeyConfig = hotKeyConfigurer;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        1.access$100(this.this$1).setKeyStroke((KeyStroke)this.val$stepKeyConfig.getValue());
                        1.access$000(this.this$1).stepAction.putValue("ShortDescription", "Step Forward through logfile [" + HotKeyConfigurer.getString(1.access$100(this.this$1).getKeyStroke()) + "]");
                    }
                });
                hotKeyConfigurer.fireUpdate();
            }

            static /* synthetic */ BasicLogger access$000(1 var0) {
                return var0.BasicLogger.this;
            }

            static /* synthetic */ KeyStrokeListener access$100(1 var0) {
                return var0.keyStrokeListener;
            }
        });
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void add(Buildable buildable) {
    }

    public void remove(Buildable buildable) {
    }

    public void setup(boolean bl) {
        this.newLogAction.setEnabled(bl);
        if (bl) {
            this.logOutput.clear();
            this.nextInput = 0;
            this.nextUndo = -1;
            this.beginningState = GameModule.getGameModule().getGameState().getRestoreCommand();
        } else {
            if (this.endLogAction.isEnabled() && JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), "You are writing a logfile.\nSave now?", "Unsaved log", 0) == 0) {
                try {
                    this.write();
                }
                catch (IOException iOException) {
                    String string = "Unable to write to " + this.outputFile;
                    if (iOException.getMessage() != null) {
                        string = string + ".\n" + iOException.getMessage();
                    }
                    JOptionPane.showMessageDialog(GameModule.getGameModule().getFrame(), string, "Save failed", 0);
                }
            }
            this.logInput.clear();
            this.beginningState = null;
            this.undoAction.setEnabled(false);
            this.endLogAction.setEnabled(false);
            this.stepAction.setEnabled(false);
        }
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void enableDrawing(boolean bl) {
    }

    protected void step() {
        Command command = (Command)this.logInput.get(this.nextInput++);
        command.execute();
        GameModule.getGameModule().sendAndLog(command);
        this.stepAction.setEnabled(this.nextInput < this.logInput.size());
    }

    public void write() throws IOException {
        if (this.logOutput.size() > 0) {
            Command command = this.beginningState;
            for (int i = 0; i < this.logOutput.size(); ++i) {
                command.append(new LogCommand((Command)this.logOutput.get(i), this.logInput, this.stepAction));
            }
            String string = GameModule.getGameModule().encode(command);
            ArchiveWriter archiveWriter = new ArchiveWriter(this.outputFile.getPath());
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new Obfuscator(byArray).write(byteArrayOutputStream);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            archiveWriter.addFile("savedGame", new ByteArrayInputStream(byArray));
            archiveWriter.write();
            GameModule.getGameModule().getGameState().setModified(false);
            this.undoAction.setEnabled(false);
            this.endLogAction.setEnabled(false);
        }
    }

    protected void beginOutput() {
        int n;
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        String string = fileChooser.getSelectedFile().getName();
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n) + ".log";
            fileChooser.setSelectedFile(new File(fileChooser.getSelectedFile().getParentFile(), string));
        }
        if (fileChooser.showSaveDialog() == 0) {
            this.outputFile = fileChooser.getSelectedFile();
            this.logOutput.clear();
            this.beginningState = GameModule.getGameModule().getGameState().getRestoreCommand();
            this.undoAction.setEnabled(true);
            this.endLogAction.setEnabled(true);
            GameModule.getGameModule().appendToTitle(" - logging to " + this.outputFile.getName());
            this.newLogAction.setEnabled(false);
        }
    }

    protected void undo() {
        Command command;
        Command command2 = (Command)this.logOutput.get(this.nextUndo);
        Command command3 = command = this.nextInput > this.logInput.size() || this.nextInput < 1 ? null : (Command)this.logInput.get(this.nextInput - 1);
        if (command == command2) {
            while (this.nextInput-- > 0) {
                this.stepAction.setEnabled(true);
                if (((Command)this.logInput.get(this.nextInput)).getUndoCommand() == null) continue;
            }
        }
        while (this.nextUndo-- > 0 && ((Command)this.logOutput.get(this.nextUndo)).getUndoCommand() == null) {
        }
        this.undoAction.setEnabled(this.nextUndo >= 0);
        Command command4 = command2.getUndoCommand();
        command4.execute();
        GameModule.getGameModule().getServer().sendToOthers(command4);
        this.logOutput.add(command4);
    }

    public void log(Command command) {
        if (command != null && command.isLoggable()) {
            this.logOutput.add(command);
            if (command.getUndoCommand() != null && !command.getUndoCommand().isNull()) {
                this.nextUndo = this.logOutput.size() - 1;
            }
        }
        this.undoAction.setEnabled(this.nextUndo >= 0);
    }

    public String encode(Command command) {
        if (command instanceof LogCommand) {
            return LOG + GameModule.getGameModule().encode(((LogCommand)command).getLoggedCommand());
        }
        return null;
    }

    public Command decode(String string) {
        Command command;
        if (string.startsWith(LOG) && (command = GameModule.getGameModule().decode(string.substring(LOG.length()))) != null) {
            return new LogCommand(command, this.logInput, this.stepAction);
        }
        return null;
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            URL uRL = this.getClass().getResource(BasicLogger.UNDO_ICON);
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.putValue("Name", "Undo");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.undo();
        }
    }

    public class StepAction
    extends AbstractAction {
        public StepAction() {
            URL uRL = this.getClass().getResource(BasicLogger.STEP_ICON);
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.putValue("Name", "Step");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.step();
        }
    }

    public static class LogCommand
    extends Command {
        protected Command logged;
        protected List logInput;
        protected Action stepAction;

        public LogCommand(Command command, List list, Action action) {
            if (command instanceof LogCommand) {
                throw new RuntimeException("Can't log a LogCommand");
            }
            this.logInput = list;
            this.stepAction = action;
            this.logged = command;
            Command[] commandArray = command.getSubCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                this.append(new LogCommand(commandArray[i], list, action));
            }
            this.logged.stripSubCommands();
        }

        protected void executeCommand() {
        }

        protected Command myUndoCommand() {
            return null;
        }

        public Command getLoggedCommand() {
            return this.logged;
        }

        public void execute() {
            Command command = this.assembleCommand();
            this.logInput.add(command);
            this.stepAction.setEnabled(true);
        }

        protected Command assembleCommand() {
            Command command = this.logged;
            Command[] commandArray = this.getSubCommands();
            for (int i = 0; i < commandArray.length; ++i) {
                command.append(((LogCommand)commandArray[i]).assembleCommand());
            }
            return command;
        }
    }
}

