/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.FontConfigurer;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import org.w3c.dom.Element;

public class Chatter
extends JPanel
implements CommandEncoder,
Buildable {
    protected JTextArea conversation;
    protected JTextField input;
    protected JScrollPane scroll = new ScrollPane(22, 30);
    protected static final String MY_CHAT_COLOR = "myChatColor";
    protected static final String OTHER_CHAT_COLOR = "otherChatColor";
    protected static final String GAME_MSG_COLOR = "gameMessageColor";
    protected static final String SYS_MSG_COLOR = "systemMessageColor";

    public Chatter() {
        this.setLayout(new BoxLayout(this, 1));
        this.conversation = new JTextArea(15, 60);
        for (int i = 0; i < 15; ++i) {
            this.conversation.append("\n");
        }
        this.conversation.setEditable(false);
        this.conversation.setLineWrap(true);
        this.conversation.setWrapStyleWord(true);
        this.conversation.setUI(new UI());
        this.conversation.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Chatter.this.scroll.getVerticalScrollBar().setValue(Chatter.this.scroll.getVerticalScrollBar().getMaximum());
            }
        });
        this.input = new JTextField(60);
        this.input.setFocusTraversalKeysEnabled(false);
        this.input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Chatter.this.send(Chatter.this.formatChat(actionEvent.getActionCommand()));
                Chatter.this.input.setText("");
            }
        });
        this.input.setMaximumSize(new Dimension(this.input.getMaximumSize().width, this.input.getPreferredSize().height));
        this.scroll.setViewportView(this.conversation);
        this.add(this.scroll);
        this.add(this.input);
    }

    private String formatChat(String string) {
        return "<" + GlobalOptions.getInstance().getPlayerId() + "> - " + string;
    }

    public JTextField getInputField() {
        return this.input;
    }

    public void show(String string) {
        this.conversation.append("\n" + string);
    }

    public void setHandle(String string) {
    }

    public String getHandle() {
        return GlobalOptions.getInstance().getPlayerId();
    }

    public void setFont(Font font) {
        if (this.input != null) {
            if (this.input.getText().length() == 0) {
                this.input.setText("XXX");
                this.input.setFont(font);
                this.input.setText("");
            } else {
                this.input.setFont(font);
            }
        }
        if (this.conversation != null) {
            this.conversation.setFont(font);
        }
    }

    public void build(Element element) {
    }

    public Element getBuildElement(org.w3c.dom.Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = (GameModule)buildable;
        gameModule.setChatter(this);
        gameModule.addCommandEncoder(this);
        gameModule.addKeyStrokeSource(new KeyStrokeSource(this, 1));
        FontConfigurer fontConfigurer = new FontConfigurer("ChatFont", "Chat Window Font: ");
        fontConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Chatter.this.setFont((Font)propertyChangeEvent.getNewValue());
            }
        });
        gameModule.getControlPanel().add((Component)this, "Center");
        fontConfigurer.fireUpdate();
        gameModule.getPrefs().addOption("Chat Window", fontConfigurer);
        ColorConfigurer colorConfigurer = new ColorConfigurer(GAME_MSG_COLOR, "Game messages", Color.magenta);
        gameModule.getGlobalPrefs().addOption("Chat Window", colorConfigurer);
        ColorConfigurer colorConfigurer2 = new ColorConfigurer(SYS_MSG_COLOR, "System messages", new Color(160, 160, 160));
        gameModule.getGlobalPrefs().addOption("Chat Window", colorConfigurer2);
        ColorConfigurer colorConfigurer3 = new ColorConfigurer(MY_CHAT_COLOR, "My text messages", Color.gray);
        gameModule.getGlobalPrefs().addOption("Chat Window", colorConfigurer3);
        ColorConfigurer colorConfigurer4 = new ColorConfigurer(OTHER_CHAT_COLOR, "Other's text messages", Color.black);
        gameModule.getGlobalPrefs().addOption("Chat Window", colorConfigurer4);
    }

    public void add(Buildable buildable) {
    }

    public Command decode(String string) {
        if (string.startsWith("CHAT")) {
            return new DisplayText(this, string.substring(4));
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof DisplayText) {
            return "CHAT" + ((DisplayText)command).msg;
        }
        return null;
    }

    public void send(String string) {
        if (string != null && string.length() > 0) {
            this.show(string);
            GameModule.getGameModule().sendAndLog(new DisplayText(this, string));
        }
    }

    public void keyCommand(KeyStroke keyStroke) {
        if (!(keyStroke.getKeyCode() != 0 && keyStroke.getKeyCode() != 65535 || Character.isISOControl(keyStroke.getKeyChar()))) {
            this.input.setText(this.input.getText() + keyStroke.getKeyChar());
        } else if (keyStroke.isOnKeyRelease()) {
            switch (keyStroke.getKeyCode()) {
                case 10: {
                    if (this.input.getText().length() > 0) {
                        this.send(this.formatChat(this.input.getText()));
                    }
                    this.input.setText("");
                    break;
                }
                case 8: 
                case 127: {
                    String string = this.input.getText();
                    if (string.length() <= 0) break;
                    this.input.setText(string.substring(0, string.length() - 1));
                }
            }
        }
    }

    private int drawColoredText(Graphics graphics, int n, int n2, TabExpander tabExpander, Document document, int n3, int n4, javax.swing.text.Element element) throws BadLocationException {
        Segment segment = new Segment();
        document.getText(n3, n4 - n3, segment);
        graphics.setColor(this.getColor(element));
        return Utilities.drawTabbedText(segment, n, n2, graphics, tabExpander, n3);
    }

    protected Color getColor(javax.swing.text.Element element) {
        Color color = null;
        try {
            String string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
            if (string.length() > 0) {
                switch (string.charAt(0)) {
                    case '*': {
                        color = (Color)GameModule.getGameModule().getGlobalPrefs().getValue(GAME_MSG_COLOR);
                        break;
                    }
                    case '-': {
                        color = (Color)GameModule.getGameModule().getGlobalPrefs().getValue(SYS_MSG_COLOR);
                        break;
                    }
                    default: {
                        color = string.startsWith(this.formatChat("")) ? (Color)GameModule.getGameModule().getGlobalPrefs().getValue(MY_CHAT_COLOR) : (Color)GameModule.getGameModule().getGlobalPrefs().getValue(OTHER_CHAT_COLOR);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return color == null ? Color.black : color;
    }

    public static void main(String[] stringArray) {
        Chatter chatter = new Chatter();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(chatter);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static class DisplayText
    extends Command {
        private String msg;
        private Chatter c;

        public DisplayText(Chatter chatter, String string) {
            this.c = chatter;
            this.msg = string;
        }

        public void executeCommand() {
            this.c.show(this.msg);
        }

        public Command myUndoCommand() {
            return new DisplayText(this.c, "* UNDO: " + this.msg);
        }

        public String getMessage() {
            return this.msg;
        }

        public String getDetails() {
            return this.msg;
        }
    }

    private class PView
    extends PlainView {
        private PView(javax.swing.text.Element element) {
            super(element);
        }

        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            javax.swing.text.Element element = this.getElement();
            return Chatter.this.drawColoredText(graphics, n, n2, this, this.getDocument(), n3, n4, element.getElement(element.getElementIndex(n3)));
        }
    }

    private class WrappedView
    extends WrappedPlainView {
        private WrappedView(javax.swing.text.Element element, boolean bl) {
            super(element, bl);
        }

        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            javax.swing.text.Element element = this.getElement();
            return Chatter.this.drawColoredText(graphics, n, n2, this, this.getDocument(), n3, n4, element.getElement(element.getElementIndex(n3)));
        }
    }

    private class UI
    extends BasicTextAreaUI {
        private UI() {
        }

        public View create(javax.swing.text.Element element) {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)jTextComponent;
                View view = jTextArea.getLineWrap() ? new WrappedView(element, jTextArea.getWrapStyleWord()) : new PView(element);
                return view;
            }
            return null;
        }
    }
}

