/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Random;

public class DiceButton
extends AbstractConfigurable {
    protected Random ran;
    protected int nSides = 6;
    protected int nDice = 2;
    protected int plus = 0;
    protected boolean reportTotal = false;
    protected boolean promptAlways = false;
    protected FormattedString reportFormat = new FormattedString("** $name$ = $result$ *** <$playerName$>");
    protected LaunchButton launch;
    public static final String DEPRECATED_NAME = "label";
    public static final String BUTTON_TEXT = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String N_DICE = "nDice";
    public static final String N_SIDES = "nSides";
    public static final String PLUS = "plus";
    public static final String HOTKEY = "hotkey";
    public static final String REPORT_TOTAL = "reportTotal";
    public static final String PROMPT_ALWAYS = "prompt";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String RESULT = "result";
    public static final String REPORT_NAME = "name";
    private VisibilityCondition cond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !DiceButton.this.promptAlways;
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$DiceButton$IconConfig;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$DiceButton$ReportFormatConfig;

    public DiceButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DiceButton.this.promptAlways) {
                    DiceButton.this.promptAlways = false;
                    AutoConfigurer autoConfigurer = (AutoConfigurer)DiceButton.this.getConfigurer();
                    ConfigurerWindow configurerWindow = new ConfigurerWindow(autoConfigurer, true);
                    autoConfigurer.getConfigurer("name").getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.BUTTON_TEXT).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.ICON).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.HOTKEY).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.PROMPT_ALWAYS).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.REPORT_FORMAT).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(DiceButton.REPORT_TOTAL).getControls().setVisible(false);
                    configurerWindow.pack();
                    ((Component)configurerWindow).setVisible(true);
                    autoConfigurer.getConfigurer("name").getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.BUTTON_TEXT).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.ICON).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.HOTKEY).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.PROMPT_ALWAYS).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.REPORT_FORMAT).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(DiceButton.REPORT_TOTAL).getControls().setVisible(true);
                    DiceButton.this.DR();
                    DiceButton.this.promptAlways = true;
                } else {
                    DiceButton.this.DR();
                }
            }
        };
        this.launch = new LaunchButton(null, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute("name", "2d6");
        this.setAttribute(BUTTON_TEXT, "2d6");
    }

    public static String getConfigureTypeName() {
        return "Dice Button";
    }

    protected String getReportPrefix() {
        return " *** " + this.getConfigureName() + " = ";
    }

    protected String getReportSuffix() {
        return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
    }

    protected void DR() {
        String string = "";
        int n = 0;
        for (int i = 0; i < this.nDice; ++i) {
            int n2 = (int)(this.ran.nextFloat() * (float)this.nSides + 1.0f) + this.plus;
            if (this.reportTotal) {
                n += n2;
                continue;
            }
            string = string + n2;
            if (i >= this.nDice - 1) continue;
            string = string + ",";
        }
        if (this.reportTotal) {
            string = string + n;
        }
        String string2 = this.formatResult(string);
        GameModule.getGameModule().getChatter().send(string2);
        GameModule.getGameModule().getPropertyListener().propertyChange(new PropertyChangeEvent(this, this.getConfigureName() + "_result", null, string));
    }

    protected String formatResult(String string) {
        this.reportFormat.setProperty("name", this.getConfigureName());
        this.reportFormat.setProperty(RESULT, string);
        String string2 = this.reportFormat.getText();
        String string3 = string2.startsWith("*") ? "*" + string2 : "* " + string2;
        return string3;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{"name", BUTTON_TEXT, ICON, N_DICE, N_SIDES, PLUS, REPORT_TOTAL, HOTKEY, PROMPT_ALWAYS, REPORT_FORMAT};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Button text", "Button icon", "Number of dice", "Number of sides per die", "Add to each die", "Report Total", "Hotkey", "Prompt for values when button pushed", "Report Format"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DiceButton.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DiceButton.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$DiceButton$IconConfig == null ? (class$VASSAL$build$module$DiceButton$IconConfig = DiceButton.class$("VASSAL.build.module.DiceButton$IconConfig")) : class$VASSAL$build$module$DiceButton$IconConfig, class$java$lang$Integer == null ? (class$java$lang$Integer = DiceButton.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DiceButton.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DiceButton.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DiceButton.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = DiceButton.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DiceButton.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$DiceButton$ReportFormatConfig == null ? (class$VASSAL$build$module$DiceButton$ReportFormatConfig = DiceButton.class$("VASSAL.build.module.DiceButton$ReportFormatConfig")) : class$VASSAL$build$module$DiceButton$ReportFormatConfig};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (N_DICE.equals(string) || N_SIDES.equals(string) || PLUS.equals(string) || REPORT_TOTAL.equals(string)) {
            return this.cond;
        }
        return null;
    }

    public void addTo(Buildable buildable) {
        this.ran = GameModule.getGameModule().getRNG();
        GameModule.getGameModule().getToolBar().add(this.getComponent());
    }

    protected Component getComponent() {
        return this.launch;
    }

    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute("name", object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if ("name".equals(string)) {
            this.setConfigureName((String)object);
            this.launch.setToolTipText((String)object);
        } else if (N_DICE.equals(string)) {
            if (object instanceof Integer) {
                this.nDice = (Integer)object;
            } else if (object instanceof String) {
                this.nDice = Integer.parseInt((String)object);
            }
        } else if (N_SIDES.equals(string)) {
            if (object instanceof Integer) {
                this.nSides = (Integer)object;
            } else if (object instanceof String) {
                this.nSides = Integer.parseInt((String)object);
            }
        } else if (PLUS.equals(string)) {
            if (object instanceof Integer) {
                this.plus = (Integer)object;
            } else if (object instanceof String) {
                this.plus = Integer.parseInt((String)object);
            }
        } else if (REPORT_TOTAL.equals(string)) {
            if (object instanceof Boolean) {
                this.reportTotal = (Boolean)object;
            } else if (object instanceof String) {
                this.reportTotal = "true".equals(object);
            }
        } else if (PROMPT_ALWAYS.equals(string)) {
            if (object instanceof Boolean) {
                this.promptAlways = (Boolean)object;
            } else if (object instanceof String) {
                this.promptAlways = "true".equals(object);
            }
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if ("name".equals(string)) {
            return this.getConfigureName();
        }
        if (N_DICE.equals(string)) {
            return "" + this.nDice;
        }
        if (N_SIDES.equals(string)) {
            return "" + this.nSides;
        }
        if (PLUS.equals(string)) {
            return "" + this.plus;
        }
        if (REPORT_TOTAL.equals(string)) {
            return "" + this.reportTotal;
        }
        if (PROMPT_ALWAYS.equals(string)) {
            return "" + this.promptAlways;
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        return this.launch.getAttributeValueString(string);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getToolBar().revalidate();
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "DiceButton");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{"name", DiceButton.RESULT});
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/die.gif");
        }
    }
}

