/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.InternetDiceButton;
import VASSAL.build.module.MultiRoll;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.preferences.Prefs;
import VASSAL.tools.BackgroundTask;
import VASSAL.tools.FormattedString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DieManager
extends AbstractConfigurable {
    private Hashtable servers;
    private Vector dieButtons = new Vector();
    private String desc = "Die Manager";
    private boolean useMultiRoll;
    private int defaultNDice = 2;
    private int defaultNSides = 6;
    private DieServer server;
    private String lastServerName = "";
    private MultiRoll myMultiRoll;
    final StringEnumConfigurer semail;
    public static final String USE_INTERNET_DICE = "useinternetdice";
    public static final String DICE_SERVER = "diceserver";
    public static final String SERVER_PW = "serverpw";
    public static final String USE_EMAIL = "useemail";
    public static final String PRIMARY_EMAIL = "primaryemail";
    public static final String SECONDARY_EMAIL = "secondaryemail";
    public static final String ADDRESS_BOOK = "addressbook";
    public static final String MULTI_ROLL = "multiroll";
    public static final String DIE_MANAGER = "Internet Die Roller";
    public static final String ROLL_MARKER = "VASSAL auto-generated dice roll";
    public static final String DESC = "description";
    public static final String DFLT_NSIDES = "dfltnsides";
    public static final String DFLT_NDICE = "dfltndice";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$InternetDiceButton;

    public DieManager() {
        this.servers = new Hashtable();
        ShadowDiceDieServer shadowDiceDieServer = new ShadowDiceDieServer();
        this.servers.put(shadowDiceDieServer.getName(), shadowDiceDieServer);
        this.server = shadowDiceDieServer;
        StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(DICE_SERVER, "Internet Dice Server", this.getDescriptions());
        stringEnumConfigurer.setValue(this.server.getDescription());
        StringConfigurer stringConfigurer = new StringConfigurer(SERVER_PW, "Dice Server Password");
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(USE_EMAIL, "Email results?");
        StringConfigurer stringConfigurer2 = new StringConfigurer(PRIMARY_EMAIL, "Primary Email");
        StringArrayConfigurer stringArrayConfigurer = new StringArrayConfigurer(ADDRESS_BOOK, "Address Book");
        BooleanConfigurer booleanConfigurer2 = new BooleanConfigurer(MULTI_ROLL, "Put multiple rolls into single email");
        GameModule.getGameModule().getPrefs().addOption(null, stringEnumConfigurer);
        GameModule.getGameModule().getPrefs().addOption(null, stringConfigurer);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, booleanConfigurer);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, stringArrayConfigurer);
        String[] stringArray = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail = new StringEnumConfigurer(SECONDARY_EMAIL, "Secondary Email", stringArray);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, stringConfigurer2);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, this.semail);
        GameModule.getGameModule().getPrefs().addOption(DIE_MANAGER, booleanConfigurer2);
        this.setSemailValues();
        DefaultListModel defaultListModel = stringArrayConfigurer.getModel();
        ListDataListener listDataListener = new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                DieManager.this.setSemailValues();
            }
        };
        defaultListModel.addListDataListener(listDataListener);
    }

    public void setSemailValues() {
        String string = (String)GameModule.getGameModule().getPrefs().getValue(SECONDARY_EMAIL);
        String[] stringArray = (String[])GameModule.getGameModule().getPrefs().getValue(ADDRESS_BOOK);
        this.semail.setValidValues(stringArray);
        this.semail.setValue(string);
    }

    public String[] getNames() {
        if (this.servers == null) {
            return null;
        }
        String[] stringArray = new String[this.servers.size()];
        Enumeration enumeration = this.servers.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getDescriptions() {
        if (this.servers == null) {
            return null;
        }
        String[] stringArray = new String[this.servers.size()];
        Enumeration enumeration = this.servers.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((DieServer)enumeration.nextElement()).getDescription();
            ++n;
        }
        return stringArray;
    }

    public DieServer getServerForName(String string) {
        return (DieServer)this.servers.get(string);
    }

    public DieServer getServerFromDescription(String string) {
        DieServer dieServer = null;
        Enumeration enumeration = this.servers.elements();
        while (enumeration.hasMoreElements()) {
            dieServer = (DieServer)enumeration.nextElement();
            if (!string.equals(dieServer.getDescription())) continue;
            return dieServer;
        }
        return null;
    }

    public DieServer getServer() {
        this.getPrefs();
        return this.server;
    }

    public String getServerDescription() {
        return this.getServer().getDescription();
    }

    public String getServerName() {
        return this.getServer().getName();
    }

    public int getDfltNDice() {
        return this.defaultNDice;
    }

    public int getDfltNSides() {
        return this.defaultNSides;
    }

    public MultiRoll getMultiRoll(int n, int n2) {
        String string = this.getServer().getName();
        if (this.myMultiRoll == null || !string.equals(this.lastServerName)) {
            this.myMultiRoll = new MultiRoll(this, n, n2);
        }
        this.lastServerName = string;
        return this.myMultiRoll;
    }

    public void roll(int n, int n2, int n3, boolean bl, String string, FormattedString formattedString) {
        Object object;
        RollSet rollSet;
        MultiRoll multiRoll = this.getMultiRoll(n, n2);
        this.getPrefs();
        String string2 = GameModule.getGameModule().getChatter().getInputField().getText();
        if (string2 != null && string2.length() > 0) {
            multiRoll.setDescription(string2);
        }
        if (this.useMultiRoll) {
            multiRoll.setVisible(true);
            if (multiRoll.wasCancelled()) {
                return;
            }
            rollSet = multiRoll.getRollSet();
            string2 = rollSet.getDescription();
        } else {
            object = new DieRoll[]{new DieRoll(string, n, n2, n3, bl)};
            rollSet = new RollSet(string, (DieRoll[])object);
            string2 = "";
        }
        object = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Roll sent to " + this.server.getDescription());
        if (string2 == null || string2.length() == 0) {
            string2 = GameModule.getGameModule().getChatter().getInputField().getText();
        }
        if (this.server.getUseEmail()) {
            if (string2 == null || string2.length() == 0) {
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (no subject line)"));
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Leave text in the chat input area to provide a subject line"));
            } else {
                ((Command)object).append(new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " - Emailing " + this.server.getSecondaryEmail() + " (Subject:  " + string2 + ")"));
            }
        }
        ((Command)object).execute();
        GameModule.getGameModule().sendAndLog((Command)object);
        GameModule.getGameModule().getChatter().getInputField().setText("");
        rollSet.setDescription(string2);
        this.server.roll(rollSet, formattedString);
    }

    private void getPrefs() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String string = (String)prefs.getValue(DICE_SERVER);
        this.server = this.getServerFromDescription(string);
        this.server.setPasswd((String)prefs.getValue(SERVER_PW));
        this.server.setUseEmail((Boolean)prefs.getValue(USE_EMAIL));
        this.server.setPrimaryEmail((String)prefs.getValue(PRIMARY_EMAIL));
        this.server.setSecondaryEmail((String)prefs.getValue(SECONDARY_EMAIL));
        this.useMultiRoll = (Boolean)prefs.getValue(MULTI_ROLL);
    }

    public void addDieButton(InternetDiceButton internetDiceButton) {
        this.dieButtons.add(internetDiceButton);
    }

    public void removeDieButton(InternetDiceButton internetDiceButton) {
        this.dieButtons.remove(internetDiceButton);
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Description", "Multi-roll Default Ndice", "Multi-roll Default Nsides"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = DieManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = DieManager.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DieManager.class$("java.lang.Integer")) : class$java$lang$Integer};
    }

    public String[] getAttributeNames() {
        return new String[]{DESC, DFLT_NDICE, DFLT_NSIDES};
    }

    public void setAttribute(String string, Object object) {
        if (DESC.equals(string)) {
            this.desc = (String)object;
        } else if (DFLT_NDICE.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.defaultNDice = (Integer)object;
        } else if (DFLT_NSIDES.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.defaultNSides = (Integer)object;
        }
    }

    public String getAttributeValueString(String string) {
        if (DESC.equals(string)) {
            return this.desc;
        }
        if (DFLT_NDICE.equals(string)) {
            return this.defaultNDice + "";
        }
        if (DFLT_NSIDES.equals(string)) {
            return this.defaultNSides + "";
        }
        return null;
    }

    public void removeFrom(Buildable buildable) {
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$InternetDiceButton == null ? (class$VASSAL$build$module$InternetDiceButton = DieManager.class$("VASSAL.build.module.InternetDiceButton")) : class$VASSAL$build$module$InternetDiceButton};
    }

    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Die Manager";
    }

    public void setSecondaryEmail(String string) {
        GameModule.getGameModule().getPrefs().setValue(SECONDARY_EMAIL, string);
        this.server.setSecondaryEmail(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ShadowDiceDieServer
    extends DieServer {
        public ShadowDiceDieServer() {
            this.name = "ShadowDice";
            this.description = "ShadowDice Dice Server";
            this.emailOnly = false;
            this.maxRolls = 0;
            this.maxEmails = 0;
            this.serverURL = "http://www.gamerz.net/shadowdice/shadowdice.cgi";
            this.passwdRequired = false;
            this.canDoSeperateDice = true;
        }

        public String[] buildInternetRollString(RollSet rollSet) {
            String string = "";
            String string2 = "";
            if (this.getUseEmail()) {
                string = this.extractEmail(this.getPrimaryEmail());
                string2 = this.extractEmail(this.getSecondaryEmail());
            }
            String string3 = this.hexify(rollSet.description);
            String string4 = "mto=" + string + "&mcc=" + string2 + "&yem=" + string;
            string4 = string4 + "&sbj=" + string3;
            string4 = string4 + "&msg=VASSAL auto-generated dice roll%0D%0A" + string3 + "%0D%0A";
            int n = rollSet.getMaxDescLength();
            DieRoll[] dieRollArray = rollSet.getDieRolls();
            for (int i = 0; i < dieRollArray.length; ++i) {
                int n2;
                string4 = string4 + this.hexify(dieRollArray[i].getDescription());
                for (n2 = 0; n2 < n - dieRollArray[i].getDescription().length(); ++n2) {
                    string4 = string4 + ' ';
                }
                string4 = string4 + " %23";
                n2 = dieRollArray[i].getNumDice();
                int n3 = dieRollArray[i].getNumSides();
                for (int j = 0; j < n2; ++j) {
                    string4 = string4 + "%5B1d" + n3 + "%5D";
                }
                string4 = string4 + "%0D%0A";
            }
            string4 = string4 + "&todo=Action%21&hid=1";
            string4 = string4.replace(' ', '+');
            return new String[]{string4};
        }

        public String hexify(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '#') {
                    stringBuffer.append('.');
                    continue;
                }
                if ("~!$%^&()+`={}[]|:;'<>,?/\\\"".indexOf(c) >= 0) {
                    stringBuffer.append("%" + Integer.toHexString(c).toUpperCase());
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        public void parseInternetRollString(RollSet rollSet, Vector vector) {
            Enumeration enumeration = vector.elements();
            String string = (String)enumeration.nextElement();
            while (enumeration.hasMoreElements() && !string.startsWith("! VASSAL auto-generated dice roll")) {
                string = (String)enumeration.nextElement();
            }
            string = (String)enumeration.nextElement();
            DieRoll[] dieRollArray = rollSet.getDieRolls();
            for (int i = 0; i < dieRollArray.length; ++i) {
                string = (String)enumeration.nextElement();
                int n = string.indexOf("#") - 1;
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), " ");
                for (int j = 0; j < rollSet.dieRolls[i].getNumDice(); ++j) {
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    int n2 = Integer.parseInt(string2);
                    rollSet.dieRolls[i].setResult(j, n2);
                }
            }
        }

        public void roll(RollSet rollSet, FormattedString formattedString) {
            super.doInternetRoll(rollSet, formattedString);
        }
    }

    public static abstract class DieServer {
        protected Random ran = GameModule.getGameModule().getRNG();
        protected String name;
        protected String description;
        protected boolean emailOnly;
        protected int maxRolls;
        protected int maxEmails;
        protected String serverURL;
        protected boolean passwdRequired = false;
        protected String password = "";
        protected boolean useEmail;
        protected String primaryEmail;
        protected String secondaryEmail;
        protected boolean canDoSeperateDice = false;

        public abstract String[] buildInternetRollString(RollSet var1);

        public abstract void parseInternetRollString(RollSet var1, Vector var2);

        public abstract void roll(RollSet var1, FormattedString var2);

        public int[] getnDiceList() {
            return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
        }

        public int[] getnSideList() {
            return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 20, 30, 50, 100, 1000};
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPasswdRequired() {
            return this.passwdRequired;
        }

        public String getPasswd() {
            return this.password;
        }

        public void setPasswd(String string) {
            this.password = string;
        }

        public void setPrimaryEmail(String string) {
            this.primaryEmail = string;
        }

        public String getPrimaryEmail() {
            return this.primaryEmail;
        }

        public void setSecondaryEmail(String string) {
            this.secondaryEmail = string;
        }

        public String getSecondaryEmail() {
            return this.secondaryEmail;
        }

        public void setUseEmail(boolean bl) {
            this.useEmail = bl;
        }

        public boolean getUseEmail() {
            return this.useEmail;
        }

        public int getMaxEmails() {
            return this.maxEmails;
        }

        protected String getReportPrefix(String string) {
            return " *** " + string + " = ";
        }

        protected String getReportSuffix() {
            return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
        }

        public void doInbuiltRoll(RollSet rollSet) {
            DieRoll[] dieRollArray = rollSet.getDieRolls();
            for (int i = 0; i < dieRollArray.length; ++i) {
                DieRoll dieRoll = dieRollArray[i];
                String string = dieRoll.getDescription();
                int n = dieRoll.getNumSides();
                int n2 = dieRoll.getNumDice();
                int n3 = dieRoll.getPlus();
                boolean bl = dieRoll.isReportTotal();
                String string2 = this.getReportPrefix(string);
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n5 = (int)(this.ran.nextFloat() * (float)n + 1.0f) + n3;
                    if (bl) {
                        n4 += n5;
                    } else {
                        string2 = string2 + n5;
                        if (j < n2 - 1) {
                            string2 = string2 + ",";
                        }
                    }
                    if (bl) {
                        string2 = string2 + n4;
                    }
                    string2 = string2 + this.getReportSuffix();
                    GameModule.getGameModule().getChatter().send(string2);
                }
            }
        }

        public void doInternetRoll(RollSet rollSet, FormattedString formattedString) {
            BackgroundTask backgroundTask = new BackgroundTask(this, rollSet, formattedString){
                private IOException error;
                private final /* synthetic */ RollSet val$mroll;
                private final /* synthetic */ FormattedString val$format;
                private final /* synthetic */ DieServer this$0;
                {
                    this.this$0 = dieServer;
                    this.val$mroll = rollSet;
                    this.val$format = formattedString;
                }

                public void doFirst() {
                    try {
                        this.this$0.doIRoll(this.val$mroll);
                    }
                    catch (IOException iOException) {
                        this.error = iOException;
                    }
                }

                public void doLater() {
                    if (this.error == null) {
                        this.this$0.reportResult(this.val$mroll, this.val$format);
                    } else {
                        String string = "- Internet dice roll attempt " + this.val$mroll.getDescription() + " failed.";
                        GameModule.getGameModule().getChatter().send(string);
                    }
                }
            };
            backgroundTask.start();
        }

        protected String formatResult(String string, String string2, FormattedString formattedString) {
            formattedString.setProperty("result", string2);
            formattedString.setProperty("rollDetails", string);
            String string3 = formattedString.getText();
            String string4 = string3.startsWith("*") ? "*" + string3 : "* " + string3;
            return string4;
        }

        public void reportResult(RollSet rollSet, FormattedString formattedString) {
            DieRoll[] dieRollArray = rollSet.getDieRolls();
            for (int i = 0; i < dieRollArray.length; ++i) {
                DieRoll dieRoll = dieRollArray[i];
                int n = dieRoll.getNumDice();
                boolean bl = dieRoll.isReportTotal();
                String string = "";
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    int n3 = dieRoll.getResult(j);
                    if (bl) {
                        n2 += n3;
                        continue;
                    }
                    string = string + n3;
                    if (j >= n - 1) continue;
                    string = string + ",";
                }
                if (bl) {
                    string = string + n2;
                }
                string = this.formatResult(dieRollArray[i].getDescription(), string, formattedString);
                GameModule.getGameModule().getChatter().send(string);
            }
        }

        public void doIRoll(RollSet rollSet) throws IOException {
            String string;
            String[] stringArray = this.buildInternetRollString(rollSet);
            Vector<String> vector = new Vector<String>();
            URL uRL = new URL(this.serverURL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                vector.add(n++, string);
            }
            bufferedReader.close();
            this.parseInternetRollString(rollSet, vector);
        }

        public String extractEmail(String string) {
            int n = string.indexOf("<");
            int n2 = string.indexOf(">");
            if (n >= 0 && n2 >= 0 && n2 > n) {
                return string.substring(n + 1, n2);
            }
            return string;
        }
    }

    public static class RollSet {
        public String description;
        public DieRoll[] dieRolls;

        public RollSet(String string, DieRoll[] dieRollArray) {
            this.description = string;
            this.dieRolls = dieRollArray;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public DieRoll[] getDieRolls() {
            return this.dieRolls;
        }

        public int getMaxDescLength() {
            int n = 0;
            for (int i = 0; i < this.dieRolls.length; ++i) {
                n = Math.max(n, this.dieRolls[i].getDescription().length());
            }
            return n;
        }
    }
}

