/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.util.Enumeration;
import java.util.Vector;

public class EventLog
extends AbstractBuildable
implements CommandEncoder,
GameComponent {
    public static final String EVENT_LIST = "Events";
    private Vector myEvents;
    private Vector savedEvents;

    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.addCommandEncoder(this);
        gameModule.getGameState().addGameComponent(this);
        gameModule.getPrefs().addOption(new StringConfigurer(EVENT_LIST, null));
        this.myEvents = new Vector();
        this.savedEvents = new Vector();
        Enumeration enumeration = EventLog.decodeEvents((String)gameModule.getPrefs().getValue(EVENT_LIST));
        while (enumeration.hasMoreElements()) {
            this.myEvents.addElement(enumeration.nextElement());
        }
    }

    public void clearSaved() {
        this.savedEvents.removeAllElements();
    }

    public void store(Event event) {
        this.savedEvents.addElement(event);
    }

    public void log(Event event) {
        this.myEvents.addElement(event);
        GameModule.getGameModule().getPrefs().getOption(EVENT_LIST).setValue(EventLog.encodeEvents(this.myEvents.elements()));
    }

    public Command decode(String string) {
        if (string.startsWith(EVENT_LIST)) {
            return new StoreEvents(this, string.substring(EVENT_LIST.length()));
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof StoreEvents) {
            return EVENT_LIST + ((StoreEvents)command).getEvents();
        }
        return null;
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.clearSaved();
        }
    }

    public Command getRestoreCommand() {
        return new StoreEvents(this, EventLog.encodeEvents(this.savedEvents.elements()));
    }

    public static Enumeration decodeEvents(String string) {
        Vector<Event> vector = new Vector<Event>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        while (decoder.hasMoreTokens()) {
            SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(decoder.nextToken(), ',');
            vector.addElement(new Event(Long.parseLong(decoder2.nextToken()), decoder2.nextToken(), decoder2.nextToken()));
        }
        return vector.elements();
    }

    public static String encodeEvents(Enumeration enumeration) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('|');
        while (enumeration.hasMoreElements()) {
            Event event = (Event)enumeration.nextElement();
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
            sequenceEncoder2.append("" + event.getTime()).append(event.getUser()).append(event.getAction());
            sequenceEncoder.append(sequenceEncoder2.getValue());
        }
        return sequenceEncoder.getValue();
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void setAttribute(String string, Object object) {
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public static class StoreEvents
    extends Command {
        private EventLog log;
        private String events;

        public StoreEvents(EventLog eventLog, String string) {
            this.log = eventLog;
            this.events = string;
        }

        public String getEvents() {
            return this.events;
        }

        public void executeCommand() {
            this.log.clearSaved();
            Enumeration enumeration = EventLog.decodeEvents(this.events);
            while (enumeration.hasMoreElements()) {
                this.log.store((Event)enumeration.nextElement());
            }
        }

        public Command myUndoCommand() {
            return null;
        }
    }

    public static class Event {
        private long time;
        private String user;
        private String action;

        public Event(long l, String string, String string2) {
            this.time = l;
            this.user = string;
            this.action = string2;
        }

        public long getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }

        public String getAction() {
            return this.action;
        }
    }
}

