/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.tools.ComponentPathBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionElement
implements Buildable {
    public static final String TARGET = "target";
    private Buildable extension;
    private Configurable[] targetPath;

    public ExtensionElement() {
    }

    public ExtensionElement(Buildable buildable, Configurable[] configurableArray) {
        this.extension = buildable;
        this.targetPath = configurableArray;
    }

    public void add(Buildable buildable) {
        this.extension = buildable;
    }

    public void build(Element element) {
        try {
            this.targetPath = ComponentPathBuilder.getInstance().getPath(element.getAttribute(TARGET));
        }
        catch (ComponentPathBuilder.PathFormatException pathFormatException) {
            throw new IllegalBuildException(pathFormatException.getMessage());
        }
        Element element2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            break;
        }
        if (element2 != null) {
            try {
                this.extension = Builder.create(element2);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (string == null) {
                    string = exception.getClass().getName().substring(exception.getClass().getName().lastIndexOf(46) + 1);
                }
                throw new IllegalBuildException(string);
            }
        }
    }

    public Buildable getExtension() {
        return this.extension;
    }

    public Configurable[] getTargetPath() {
        return this.targetPath;
    }

    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        element.setAttribute(TARGET, ComponentPathBuilder.getInstance().getId(this.targetPath));
        element.appendChild(this.extension.getBuildElement(document));
        return element;
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = this.targetPath.length == 0 ? GameModule.getGameModule() : this.targetPath[this.targetPath.length - 1];
        this.extension.addTo(gameModule);
        gameModule.add(this.extension);
    }
}

