/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.ModuleExtension;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ExtensionsLoader
implements CommandEncoder,
FilenameFilter {
    private static final String SPECIFY_DIR_IN_PREFS = "specifyExtensionDirInPrefs";
    private static final String EXTENSION_DIR = "extensionDIR";
    public static final String COMMAND_PREFIX = "EXT\t";
    private Set loadedExtensions = new HashSet();

    public void addTo(GameModule gameModule) {
        if ("true".equals(GlobalOptions.getInstance().getAttributeValueString(SPECIFY_DIR_IN_PREFS))) {
            DirectoryConfigurer directoryConfigurer = new DirectoryConfigurer(EXTENSION_DIR, "Extensions Directory");
            directoryConfigurer.setValue((Object)null);
            GameModule.getGameModule().getPrefs().addOption("Extensions", directoryConfigurer);
            directoryConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ExtensionsLoader.this.addExtensions();
                }
            });
        }
        gameModule.addCommandEncoder(this);
        this.addExtensions();
    }

    private void addExtensions() {
        String[] stringArray = this.getExtensionNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.loadedExtensions.contains(stringArray[i])) continue;
                try {
                    ModuleExtension moduleExtension = new ModuleExtension(new DataArchive(stringArray[i]));
                    moduleExtension.build();
                    String string = "Extension " + moduleExtension.getName() + " v" + moduleExtension.getVersion() + " loaded";
                    this.loadedExtensions.add(stringArray[i]);
                    GameModule.getGameModule().warn(string);
                    System.err.println(string);
                    continue;
                }
                catch (IOException iOException) {
                    this.reportBuildError(iOException, stringArray[i]);
                    continue;
                }
                catch (IllegalBuildException illegalBuildException) {
                    this.reportBuildError(illegalBuildException, stringArray[i]);
                }
            }
        }
    }

    private void reportBuildError(Exception exception, String string) {
        String string2 = exception.getMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = exception.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46));
        }
        GameModule.getGameModule().warn("Unable to load extension " + string + ":  " + string2);
    }

    public Command decode(String string) {
        ModuleExtension.RegCmd regCmd = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            regCmd = new ModuleExtension.RegCmd(decoder.nextToken(), decoder.nextToken());
        }
        return regCmd;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof ModuleExtension.RegCmd) {
            ModuleExtension.RegCmd regCmd = (ModuleExtension.RegCmd)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(regCmd.getName()).append(regCmd.getVersion());
            string = COMMAND_PREFIX + sequenceEncoder.getValue();
        }
        return string;
    }

    public boolean accept(File file, String string) {
        File file2 = new File(file, string);
        return !file2.isHidden() && !file2.isDirectory();
    }

    private String[] getExtensionNames() {
        String string = ExtensionsLoader.getExtensionDirectory();
        File file = new File(string);
        File[] fileArray = file.listFiles(this);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getPath();
        }
        return stringArray;
    }

    public static String getExtensionDirectory() {
        String string;
        if ("true".equals(GlobalOptions.getInstance().getAttributeValueString(SPECIFY_DIR_IN_PREFS))) {
            string = GameModule.getGameModule().getPrefs().getOption(EXTENSION_DIR).getValueString();
        } else {
            string = new File(GameModule.getGameModule().getDataArchive().getName()).getPath();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            string = string + "_ext";
        }
        return string;
    }
}

