/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.GameComponent;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.CommandFilter;
import VASSAL.command.ConditionalCommand;
import VASSAL.command.NullCommand;
import VASSAL.counters.GamePiece;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.BackgroundTask;
import VASSAL.tools.DataArchive;
import VASSAL.tools.Deobfuscator;
import VASSAL.tools.FileChooser;
import VASSAL.tools.Obfuscator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class GameState
implements CommandEncoder {
    protected Hashtable pieces = new Hashtable();
    protected Vector gameComponents = new Vector();
    protected JMenuItem loadGame;
    protected JMenuItem saveGame;
    protected JMenuItem newGame;
    protected JMenuItem closeGame;
    protected String lastSave;
    private boolean gameStarting = false;
    private boolean gameStarted = false;
    public static final String SAVEFILE_ZIP_ENTRY = "savedGame";
    public static final String BEGIN_SAVE = "begin_save";
    public static final String END_SAVE = "end_save";

    public void addTo(GameModule gameModule) {
        this.loadGame = new JMenuItem("Load Game");
        this.loadGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.loadGame();
            }
        });
        this.loadGame.setMnemonic('L');
        this.saveGame = new JMenuItem("Save Game");
        this.saveGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.saveGame();
            }
        });
        this.saveGame.setMnemonic('S');
        this.newGame = new JMenuItem("New Game");
        this.newGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
                GameState.this.setup(true);
            }
        });
        this.newGame.setMnemonic('N');
        this.closeGame = new JMenuItem("Close Game");
        this.closeGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
            }
        });
        this.closeGame.setMnemonic('C');
        gameModule.getFileMenu().insert(this.newGame, 0);
        gameModule.getFileMenu().add(this.loadGame);
        gameModule.getFileMenu().add(this.saveGame);
        gameModule.getFileMenu().add(this.closeGame);
        this.setup(false);
    }

    public boolean isModified() {
        String string = this.saveString();
        return string != null && !string.equals(this.lastSave);
    }

    public void addGameComponent(GameComponent gameComponent) {
        this.gameComponents.addElement(gameComponent);
    }

    public void removeGameComponent(GameComponent gameComponent) {
        this.gameComponents.removeElement(gameComponent);
    }

    public Enumeration getGameComponentsEnum() {
        return this.gameComponents.elements();
    }

    public void setup(boolean bl) {
        if (!bl && this.gameStarted && this.isModified()) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), "Save Game?", "Game modified", 1)) {
                case 0: {
                    this.saveGame();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.gameStarting = bl;
        if (!bl) {
            this.pieces.clear();
        }
        this.saveGame.setEnabled(bl);
        this.closeGame.setEnabled(bl);
        if (bl) {
            this.loadGame.setText("Load Continuation");
        } else {
            this.loadGame.setText("Load Game");
            GameModule.getGameModule().appendToTitle(null);
        }
        this.gameStarted = this.gameStarted && this.gameStarting;
        Enumeration enumeration = this.gameComponents.elements();
        while (enumeration.hasMoreElements()) {
            GameComponent gameComponent = (GameComponent)enumeration.nextElement();
            gameComponent.setup(this.gameStarting);
        }
        if (bl) {
            GameModule.getGameModule().getDataArchive().clearScaledImageCache();
        }
        this.gameStarted = this.gameStarted || this.gameStarting;
        this.lastSave = bl ? this.saveString() : null;
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public void loadGame() {
        block7: {
            FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
            if (fileChooser.showOpenDialog() != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file.exists()) {
                try {
                    if (this.gameStarted) {
                        this.loadContinuation(file);
                        break block7;
                    }
                    this.loadGame(file);
                }
                catch (IOException iOException) {
                    String string = "Unable to load " + file.getName();
                    if (iOException.getMessage() != null) {
                        string = string + "\n" + iOException.getMessage();
                    }
                    JOptionPane.showMessageDialog(GameModule.getGameModule().getFrame(), string, "Load Error", 0);
                }
            } else {
                GameModule.getGameModule().warn("Unable to find " + file.getPath());
            }
        }
    }

    protected String saveString() {
        return GameModule.getGameModule().encode(this.getRestoreCommand());
    }

    public void saveGame() {
        GameModule.getGameModule().warn("Saving game ...");
        try {
            File file = this.getSaveFile();
            if (file != null) {
                this.saveGame(file);
                GameModule.getGameModule().warn("Game Saved");
            } else {
                GameModule.getGameModule().warn("Save Canceled");
            }
        }
        catch (IOException iOException) {
            GameModule.getGameModule().warn("Save Failed.  Try again.");
        }
    }

    public void setModified(boolean bl) {
        this.lastSave = bl ? null : this.saveString();
    }

    private File getSaveFile() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.selectDotSavFile();
        if (fileChooser.showSaveDialog() != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public void addPiece(GamePiece gamePiece) {
        if (gamePiece.getId() == null) {
            gamePiece.setId(this.getNewPieceId());
        }
        this.pieces.put(gamePiece.getId(), gamePiece);
    }

    public GamePiece getPieceForId(String string) {
        return string == null ? null : (GamePiece)this.pieces.get(string);
    }

    public void removePiece(String string) {
        if (string != null) {
            this.pieces.remove(string);
        }
    }

    public String getNewPieceId() {
        long l = System.currentTimeMillis();
        String string = new Long(l).toString();
        while (this.pieces.get(string) != null) {
            string = new Long(++l).toString();
        }
        return string;
    }

    public void loadContinuation(File file) throws IOException {
        byte[] byArray = new Deobfuscator(this.getSaveFileInputStream(file.getPath())).getPlainText();
        Command command = GameModule.getGameModule().decode(new String(byArray, "UTF-8").trim());
        CommandFilter commandFilter = new CommandFilter(){

            protected boolean accept(Command command) {
                return command instanceof BasicLogger.LogCommand;
            }
        };
        if ((command = commandFilter.apply(command)) != null) {
            command.execute();
        }
    }

    public Enumeration getPieces() {
        return this.pieces.elements();
    }

    public Command getRestoreCommand() {
        if (!this.saveGame.isEnabled()) {
            return null;
        }
        SetupCommand setupCommand = new SetupCommand(false);
        setupCommand.append(this.checkVersionCommand());
        setupCommand.append(this.getRestorePiecesCommand());
        Enumeration enumeration = this.gameComponents.elements();
        while (enumeration.hasMoreElements()) {
            setupCommand.append(((GameComponent)enumeration.nextElement()).getRestoreCommand());
        }
        setupCommand.append(new SetupCommand(true));
        return setupCommand;
    }

    private Command checkVersionCommand() {
        String string = GameModule.getGameModule().getAttributeValueString("runningVassalVersion");
        ConditionalCommand.Lt lt = new ConditionalCommand.Lt("runningVassalVersion", string);
        ConditionalCommand conditionalCommand = new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand("Version mismatch.\nGame saved using VASSAL version " + string + "."));
        String string2 = GameModule.getGameModule().getAttributeValueString("name");
        String string3 = GameModule.getGameModule().getAttributeValueString("version");
        lt = new ConditionalCommand.Lt("version", string3);
        conditionalCommand.append(new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand("Version mismatch.\nGame saved using " + string2 + " version " + string3 + ".")));
        return conditionalCommand;
    }

    public String encode(Command command) {
        if (command instanceof SetupCommand) {
            return ((SetupCommand)command).isGameStarting() ? END_SAVE : BEGIN_SAVE;
        }
        return null;
    }

    public Command decode(String string) {
        if (BEGIN_SAVE.equals(string)) {
            return new SetupCommand(false);
        }
        if (END_SAVE.equals(string)) {
            return new SetupCommand(true);
        }
        return null;
    }

    public void saveGame(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = this.saveString();
        new Obfuscator(string.getBytes("UTF-8")).write(byteArrayOutputStream);
        byteArrayOutputStream.close();
        this.lastSave = string;
        ArchiveWriter archiveWriter = new ArchiveWriter(file.getPath());
        archiveWriter.addFile(SAVEFILE_ZIP_ENTRY, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        archiveWriter.write();
        if (archiveWriter.getArchive() != null) {
            archiveWriter.getArchive().close();
        }
    }

    public void loadGame(File file) throws IOException {
        final String string = file.getPath();
        final String string2 = file.getName();
        GameModule.getGameModule().warn("Loading " + string2 + " ...");
        new BackgroundTask(){
            private String msg;
            private Command loadCommand;

            public void doFirst() {
                try {
                    byte[] byArray = new Deobfuscator(GameState.this.getSaveFileInputStream(string)).getPlainText();
                    this.loadCommand = GameModule.getGameModule().decode(new String(byArray, "UTF-8").trim());
                    this.msg = this.loadCommand != null ? "Loaded " + string2 : "Invalid savefile " + string2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.msg = "Error loading " + string2;
                }
            }

            public void doLater() {
                if (this.loadCommand != null) {
                    this.loadCommand.execute();
                }
                GameModule.getGameModule().warn(this.msg);
            }
        }.start();
    }

    private InputStream getSaveFileInputStream(String string) throws IOException {
        InputStream inputStream;
        try {
            inputStream = DataArchive.getFileStream(new File(string), SAVEFILE_ZIP_ENTRY);
        }
        catch (IOException iOException) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    public Command getRestorePiecesCommand() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = this.pieces.elements();
        while (object2.hasMoreElements()) {
            object = (GamePiece)object2.nextElement();
            int n = 0;
            if (object.getParent() == null) {
                n = arrayList.size();
            }
            arrayList.add(n, object);
        }
        object2 = new NullCommand();
        object = arrayList.iterator();
        while (object.hasNext()) {
            GamePiece gamePiece = (GamePiece)object.next();
            ((Command)object2).append(new AddPiece(gamePiece));
        }
        return object2;
    }

    public static class SetupCommand
    extends Command {
        private boolean gameStarting;

        public SetupCommand(boolean bl) {
            this.gameStarting = bl;
        }

        public boolean isGameStarting() {
            return this.gameStarting;
        }

        protected void executeCommand() {
            GameModule.getGameModule().getGameState().setup(this.gameStarting);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

