/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringEnum;
import VASSAL.tools.FormattedString;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalOptions
extends AbstractConfigurable {
    public static final String NON_OWNER_UNMASKABLE = "nonOwnerUnmaskable";
    public static final String PROMPT_STRING = "promptString";
    public static final String CENTER_ON_MOVE = "centerOnMove";
    public static final String MARK_MOVED = "markMoved";
    public static final String AUTO_REPORT = "autoReport";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String PROMPT = "Use Preferences Setting";
    public static final String SINGLE_WINDOW = "singleWindow";
    public static final String SCALER_ALGORITHM = "scalerAlgorithm";
    public static final String PLAYER_NAME = "playerName";
    public static final String PLAYER_SIDE = "playerSide";
    public static final String PLAYER_ID = "playerId";
    public static final String PLAYER_ID_FORMAT = "playerIdFormat";
    private String promptString = "Opponents can unmask my pieces";
    private String nonOwnerUnmaskable = "Never";
    private String centerOnMoves = "Always";
    private String autoReport = "Never";
    private String markMoved = "Never";
    private Map properties = new HashMap();
    private Map optionConfigurers = new LinkedHashMap();
    private Properties optionInitialValues = new Properties();
    private FormattedString playerIdFormat = new FormattedString("$playerName$");
    private static GlobalOptions instance;
    private boolean useSingleWindow;
    private boolean scalerAlgorithm;
    static /* synthetic */ Class class$VASSAL$preferences$StringPreference;
    static /* synthetic */ Class class$VASSAL$preferences$TextPreference;
    static /* synthetic */ Class class$VASSAL$preferences$EnumPreference;
    static /* synthetic */ Class class$VASSAL$preferences$IntegerPreference;
    static /* synthetic */ Class class$VASSAL$preferences$DoublePreference;
    static /* synthetic */ Class class$VASSAL$preferences$BooleanPreference;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalOptions$Prompt;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalOptions$PlayerIdFormatConfig;

    public void addTo(Buildable buildable) {
        instance = this;
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(SINGLE_WINDOW, "Use combined application window (requires restart)", Boolean.TRUE);
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        this.useSingleWindow = !Boolean.FALSE.equals(booleanConfigurer.getValue());
        booleanConfigurer = new BooleanConfigurer(SCALER_ALGORITHM, "Smooth image scaling", Boolean.TRUE);
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        this.scalerAlgorithm = !Boolean.FALSE.equals(booleanConfigurer.getValue());
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public static GlobalOptions getInstance() {
        if (instance == null) {
            instance = new GlobalOptions();
        }
        return instance;
    }

    public boolean isUseSingleWindow() {
        return this.useSingleWindow;
    }

    public boolean isAveragedScaling() {
        return this.scalerAlgorithm;
    }

    public static String getConfigureTypeName() {
        return "Global Options";
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$preferences$StringPreference == null ? (class$VASSAL$preferences$StringPreference = GlobalOptions.class$("VASSAL.preferences.StringPreference")) : class$VASSAL$preferences$StringPreference, class$VASSAL$preferences$TextPreference == null ? (class$VASSAL$preferences$TextPreference = GlobalOptions.class$("VASSAL.preferences.TextPreference")) : class$VASSAL$preferences$TextPreference, class$VASSAL$preferences$EnumPreference == null ? (class$VASSAL$preferences$EnumPreference = GlobalOptions.class$("VASSAL.preferences.EnumPreference")) : class$VASSAL$preferences$EnumPreference, class$VASSAL$preferences$IntegerPreference == null ? (class$VASSAL$preferences$IntegerPreference = GlobalOptions.class$("VASSAL.preferences.IntegerPreference")) : class$VASSAL$preferences$IntegerPreference, class$VASSAL$preferences$DoublePreference == null ? (class$VASSAL$preferences$DoublePreference = GlobalOptions.class$("VASSAL.preferences.DoublePreference")) : class$VASSAL$preferences$DoublePreference, class$VASSAL$preferences$BooleanPreference == null ? (class$VASSAL$preferences$BooleanPreference = GlobalOptions.class$("VASSAL.preferences.BooleanPreference")) : class$VASSAL$preferences$BooleanPreference};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Allow non-owners to un-mask pieces", null, "Center on opponent's moves", "Auto-report moves", "Player Id format"};
    }

    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(NON_OWNER_UNMASKABLE, PROMPT_STRING, CENTER_ON_MOVE, AUTO_REPORT, PLAYER_ID_FORMAT));
        Iterator iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$VASSAL$build$module$GlobalOptions$Prompt == null ? (class$VASSAL$build$module$GlobalOptions$Prompt = GlobalOptions.class$("VASSAL.build.module.GlobalOptions$Prompt")) : class$VASSAL$build$module$GlobalOptions$Prompt, null, class$VASSAL$build$module$GlobalOptions$Prompt == null ? (class$VASSAL$build$module$GlobalOptions$Prompt = GlobalOptions.class$("VASSAL.build.module.GlobalOptions$Prompt")) : class$VASSAL$build$module$GlobalOptions$Prompt, class$VASSAL$build$module$GlobalOptions$Prompt == null ? (class$VASSAL$build$module$GlobalOptions$Prompt = GlobalOptions.class$("VASSAL.build.module.GlobalOptions$Prompt")) : class$VASSAL$build$module$GlobalOptions$Prompt, class$VASSAL$build$module$GlobalOptions$PlayerIdFormatConfig == null ? (class$VASSAL$build$module$GlobalOptions$PlayerIdFormatConfig = GlobalOptions.class$("VASSAL.build.module.GlobalOptions$PlayerIdFormatConfig")) : class$VASSAL$build$module$GlobalOptions$PlayerIdFormatConfig};
    }

    public void addOption(Configurer configurer) {
        this.optionConfigurers.put(configurer.getKey(), configurer);
        Object v = ((Hashtable)this.optionInitialValues).get(configurer.getKey());
        if (v instanceof String) {
            configurer.setValue((String)v);
        }
        if (this.config != null) {
            ((Container)this.config.getControls()).add(configurer.getControls());
        }
    }

    public void build(Element element) {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                this.setAttribute(attr.getName(), attr.getValue());
            }
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("option")) {
                    ((Hashtable)this.optionInitialValues).put(element2.getAttribute("name"), Builder.getText(element2));
                    continue;
                }
                Buildable buildable = null;
                try {
                    buildable = Builder.create(element2);
                    buildable.addTo(this);
                    this.add(buildable);
                    continue;
                }
                catch (Throwable throwable) {
                    String string2 = throwable.getMessage();
                    if (string2 == null) {
                        string2 = throwable.getClass().getName().substring(throwable.getClass().getName().lastIndexOf(".") + 1);
                    }
                    System.err.println(buildable.toString());
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Unable to create class " + ((Element)((Object)buildable)).getTagName() + " in " + GameModule.getGameModule().getDataArchive().getName() + "\n" + string2, "Error", 0);
                }
            }
        }
    }

    public Element getBuildElement(Document document) {
        Element element = super.getBuildElement(document);
        Iterator iterator = this.optionConfigurers.values().iterator();
        while (iterator.hasNext()) {
            Configurer configurer = (Configurer)iterator.next();
            Element element2 = document.createElement("option");
            element2.setAttribute("name", configurer.getKey());
            element2.appendChild(document.createTextNode(configurer.getValueString()));
            element.appendChild(element2);
        }
        return element;
    }

    public Configurer getConfigurer() {
        if (this.config == null) {
            Configurer configurer = super.getConfigurer();
            Iterator iterator = this.optionConfigurers.values().iterator();
            while (iterator.hasNext()) {
                Configurer configurer2 = (Configurer)iterator.next();
                ((Container)configurer.getControls()).add(configurer2.getControls());
            }
        }
        return this.config;
    }

    public String getAttributeValueString(String string) {
        if (NON_OWNER_UNMASKABLE.equals(string)) {
            return this.nonOwnerUnmaskable;
        }
        if (PROMPT_STRING.equals(string)) {
            return this.promptString;
        }
        if (CENTER_ON_MOVE.equals(string)) {
            return this.centerOnMoves;
        }
        if (AUTO_REPORT.equals(string)) {
            return this.autoReport;
        }
        if (MARK_MOVED.equals(string)) {
            return this.markMoved;
        }
        if (PLAYER_ID_FORMAT.equals(string)) {
            return this.playerIdFormat.getFormat();
        }
        if (!this.optionConfigurers.containsKey(string)) {
            Object v = this.properties.get(string);
            return v != null ? v.toString() : null;
        }
        return null;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalOptions.htm");
    }

    public void removeFrom(Buildable buildable) {
    }

    public void setAttribute(String string, Object object) {
        if (NON_OWNER_UNMASKABLE.equals(string)) {
            this.nonOwnerUnmaskable = (String)object;
            if (ALWAYS.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowAll();
            } else if (NEVER.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowNone();
            } else if (PROMPT.equals(this.nonOwnerUnmaskable)) {
                ObscurableOptions.getInstance().allowSome(this.promptString);
                GameModule.getGameModule().getGameState().addGameComponent(ObscurableOptions.getInstance());
                GameModule.getGameModule().addCommandEncoder(ObscurableOptions.getInstance());
            }
        } else if (PROMPT_STRING.equals(string)) {
            this.promptString = (String)object;
            ObscurableOptions.getInstance().setPrompt(this.promptString);
        } else if (CENTER_ON_MOVE.equals(string)) {
            this.centerOnMoves = (String)object;
            if (PROMPT.equals(this.centerOnMoves)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(CENTER_ON_MOVE, "Center on opponent's moves");
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (AUTO_REPORT.equals(string)) {
            this.autoReport = (String)object;
            if (PROMPT.equals(this.autoReport)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(AUTO_REPORT, "Auto-report moves");
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (MARK_MOVED.equals(string)) {
            this.markMoved = (String)object;
            if (PROMPT.equals(this.markMoved)) {
                BooleanConfigurer booleanConfigurer = new BooleanConfigurer(MARK_MOVED, "Mark moved pieces");
                GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
            }
        } else if (PLAYER_ID_FORMAT.equals(string)) {
            this.playerIdFormat.setFormat((String)object);
        } else if (this.optionConfigurers.containsKey(string)) {
            ((Configurer)this.optionConfigurers.get(string)).setValue(object);
        } else {
            this.properties.put(string, object);
        }
    }

    public boolean autoReportEnabled() {
        return this.isEnabled(this.autoReport, AUTO_REPORT);
    }

    public boolean centerOnOpponentsMove() {
        return this.isEnabled(this.centerOnMoves, CENTER_ON_MOVE);
    }

    public boolean isMarkMoveEnabled() {
        return this.isEnabled(this.markMoved, MARK_MOVED);
    }

    public String getPlayerId() {
        this.playerIdFormat.setProperty(PLAYER_NAME, (String)GameModule.getGameModule().getPrefs().getValue("RealName"));
        this.playerIdFormat.setProperty(PLAYER_SIDE, PlayerRoster.getMySide());
        return this.playerIdFormat.getText();
    }

    private boolean isEnabled(String string, String string2) {
        if (ALWAYS.equals(string)) {
            return true;
        }
        if (NEVER.equals(string)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(string2));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PlayerIdFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedStringConfigurer(string, string2, new String[]{GlobalOptions.PLAYER_NAME, GlobalOptions.PLAYER_SIDE});
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{GlobalOptions.ALWAYS, GlobalOptions.NEVER, GlobalOptions.PROMPT};
        }
    }
}

