/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DieManager;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;

public class InternetDiceButton
extends DiceButton
implements GameComponent,
CommandEncoder {
    protected static DieManager dieManager;
    private static final String COMMAND_PREFIX = "SEMAIL\t";
    public static final String DETAILS = "rollDetails";
    static /* synthetic */ Class class$VASSAL$build$module$DiceButton$ReportFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$InternetDiceButton$InternetReportFormatConfig;

    public static String getConfigureTypeName() {
        return "Internet Dice Button";
    }

    public Class[] getAttributeTypes() {
        Class[] classArray = super.getAttributeTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != (class$VASSAL$build$module$DiceButton$ReportFormatConfig == null ? InternetDiceButton.class$("VASSAL.build.module.DiceButton$ReportFormatConfig") : class$VASSAL$build$module$DiceButton$ReportFormatConfig)) continue;
            classArray[i] = class$VASSAL$build$module$InternetDiceButton$InternetReportFormatConfig == null ? InternetDiceButton.class$("VASSAL.build.module.InternetDiceButton$InternetReportFormatConfig") : class$VASSAL$build$module$InternetDiceButton$InternetReportFormatConfig;
        }
        return classArray;
    }

    protected void DR() {
        this.reportFormat.setProperty("name", this.getConfigureName());
        dieManager.roll(this.nDice, this.nSides, this.plus, this.reportTotal, this.getConfigureName(), this.reportFormat);
    }

    public void addTo(Buildable buildable) {
        this.initDieManager();
        dieManager.addDieButton(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        super.addTo(buildable);
    }

    protected void initDieManager() {
        if (dieManager == null) {
            dieManager = new DieManager();
            dieManager.build(null);
        }
    }

    public void removeFrom(Buildable buildable) {
        dieManager.removeDieButton(this);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        super.removeFrom(buildable);
    }

    public void setup(boolean bl) {
    }

    public Command getRestoreCommand() {
        SetSecondaryEmail setSecondaryEmail = new SetSecondaryEmail(dieManager.getServer().getSecondaryEmail());
        return setSecondaryEmail;
    }

    public Command decode(String string) {
        SetSecondaryEmail setSecondaryEmail = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            setSecondaryEmail = new SetSecondaryEmail(string.substring(COMMAND_PREFIX.length()));
        }
        return setSecondaryEmail;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof SetSecondaryEmail) {
            string = COMMAND_PREFIX + ((SetSecondaryEmail)command).msg;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "InternetDiceButton");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SetSecondaryEmail
    extends Command {
        private String msg;

        private SetSecondaryEmail(String string) {
            this.msg = string;
        }

        protected void executeCommand() {
            dieManager.setSecondaryEmail(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class InternetReportFormatConfig
    extends DiceButton.ReportFormatConfig {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            FormattedStringConfigurer formattedStringConfigurer = (FormattedStringConfigurer)super.getConfigurer(autoConfigurable, string, string2);
            String[] stringArray = formattedStringConfigurer.getOptions();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = InternetDiceButton.DETAILS;
            formattedStringConfigurer.setOptions(stringArray2);
            return formattedStringConfigurer;
        }
    }
}

