/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.Stack;
import VASSAL.preferences.PositionOption;
import VASSAL.tools.FileChooser;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Inventory
extends AbstractConfigurable
implements GameComponent,
PlayerRoster.SideChangeListener {
    protected LaunchButton launch;
    protected CounterInventory results;
    protected JTree tree;
    public static final String VERSION = "2.1";
    public static final String HOTKEY = "hotkey";
    public static final String BUTTON_TEXT = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    protected String mapSeparator = "\n";
    protected String groupSeparator = "   ";
    public static final String FILTER = "include";
    protected String piecePropertiesFilter = "";
    public static final String GROUP_BY = "groupBy";
    protected String[] groupBy = new String[]{""};
    public static final String NON_LEAF_FORMAT = "nonLeafFormat";
    protected String nonLeafFormat = "$PropertyValue$";
    public static final String CENTERONPIECE = "centerOnPiece";
    protected boolean centerOnPiece = true;
    public static final String FORWARD_KEYSTROKE = "forwardKeystroke";
    protected boolean forwardKeystroke = true;
    public static final String SHOW_MENU = "showMenu";
    protected boolean showMenu = true;
    public static final String SIDES = "sides";
    protected String[] sides = null;
    public static final String KEYSTROKE = "keystroke";
    protected KeyStroke keyStroke = null;
    public static final String CUTBELOWROOT = "cutRoot";
    protected int cutBelowRoot = 0;
    public static final String CUTABOVELEAVES = "cutLeaves";
    protected int cutAboveLeaves = 0;
    public static final String LEAF_FORMAT = "leafFormat";
    protected String pieceFormat = "$PieceName$";
    public static final String PIECE_ZOOM = "pieceZoom";
    protected double pieceZoom = 0.25;
    public static final String DRAW_PIECES = "drawPieces";
    protected boolean drawPieces = true;
    public static final String FOLDERS_ONLY = "foldersOnly";
    protected boolean foldersOnly = false;
    public static final String SORT_PIECES = "sortPieces";
    protected boolean sortPieces = true;
    public static final String SORT_FORMAT = "sortFormat";
    protected String sortFormat = "$PieceName$";
    public static final String ALPHA = "alpha";
    public static final String LENGTHALPHA = "length";
    public static final String NUMERIC = "numeric";
    public static final String[] SORT_OPTIONS = new String[]{"alpha", "length", "numeric"};
    protected String sortStrategy = "alpha";
    public static final String SORTING = "sorting";
    protected JDialog frame;
    private VisibilityCondition piecesVisible = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !Inventory.this.foldersOnly;
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$Inventory$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$Inventory$PieceFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$Inventory$SortConfig;
    static /* synthetic */ Class class$java$lang$Double;

    public Inventory() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Inventory.this.launch();
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, "Inventory");
        this.setAttribute(BUTTON_TEXT, "Inventory");
        this.setAttribute(TOOLTIP, "Show inventory of all pieces");
        this.setAttribute(ICON, "/images/inventory.gif");
        this.launch.setEnabled(false);
        this.launch.setVisible(false);
    }

    public static String getConfigureTypeName() {
        return "Game Piece Inventory Window";
    }

    public void addTo(Buildable buildable) {
        PlayerRoster.addSideChangeListener(this);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getToolBar().add(this.getComponent());
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.frame = new JDialog(GameModule.getGameModule().getFrame());
        this.frame.setTitle(this.getConfigureName());
        String string = "Inventory." + this.getConfigureName();
        GameModule.getGameModule().getPrefs().addOption(new PositionOption(string, this.frame));
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.getContentPane().add(this.initTree());
        this.frame.getContentPane().add(this.initButtons());
        ((Component)this.frame).setSize(250, 350);
    }

    protected Component initTree() {
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(this.initTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                GamePiece gamePiece;
                if (Inventory.this.centerOnPiece && (gamePiece = Inventory.this.getSelectedCounter()) != null) {
                    gamePiece.getMap().centerAt(gamePiece.getPosition());
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CounterNode counterNode;
                GamePiece gamePiece;
                TreePath treePath;
                if (Inventory.this.showMenu && mouseEvent.isMetaDown() && (treePath = Inventory.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getLastPathComponent() instanceof CounterNode && (gamePiece = (counterNode = (CounterNode)treePath.getLastPathComponent()).getCounter().getPiece()) != null) {
                    JPopupMenu jPopupMenu = MenuDisplayer.createPopup(gamePiece);
                    jPopupMenu.addPropertyChangeListener("visible", new PropertyChangeListener(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                                SwingUtilities.invokeLater(new Runnable(this){
                                    private final /* synthetic */ 4 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    public void run() {
                                        Inventory.access$200(3.access$100(4.access$000(this.this$2)));
                                    }
                                });
                            }
                        }

                        static /* synthetic */ 3 access$000(4 var0) {
                            return var0.this$1;
                        }
                    });
                    jPopupMenu.show(Inventory.this.tree, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            static /* synthetic */ Inventory access$100(3 var0) {
                return var0.Inventory.this;
            }
        });
        this.tree.addKeyListener(new HotKeySender());
        ScrollPane scrollPane = new ScrollPane(this.tree, 20, 30);
        this.refresh();
        return scrollPane;
    }

    protected TreeCellRenderer initTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -250332615261355856L;

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                GamePiece gamePiece;
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3 && !Inventory.this.foldersOnly, n, bl4);
                if (object instanceof CounterNode && (gamePiece = ((CounterNode)object).getCounter().getPiece()) != null) {
                    Rectangle rectangle = gamePiece.getShape().getBounds();
                    rectangle.x = (int)Math.round((double)rectangle.x * Inventory.this.pieceZoom);
                    rectangle.y = (int)Math.round((double)rectangle.y * Inventory.this.pieceZoom);
                    rectangle.width = (int)Math.round((double)rectangle.width * Inventory.this.pieceZoom);
                    rectangle.height = (int)Math.round((double)rectangle.height * Inventory.this.pieceZoom);
                    this.setIcon(new Icon(this, rectangle, gamePiece){
                        private final /* synthetic */ Rectangle val$r;
                        private final /* synthetic */ GamePiece val$piece;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$r = rectangle;
                            this.val$piece = gamePiece;
                        }

                        public int getIconHeight() {
                            return this.val$r.height;
                        }

                        public int getIconWidth() {
                            return this.val$r.width;
                        }

                        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            this.val$piece.draw(graphics, -this.val$r.x, -this.val$r.y, component, 6.access$300(this.this$1).pieceZoom);
                        }
                    });
                }
                return this;
            }

            static /* synthetic */ Inventory access$300(6 var0) {
                return var0.Inventory.this;
            }
        };
    }

    protected Component initButtons() {
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Save");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Inventory.this.inventoryToText();
            }
        });
        box.add(jButton);
        JButton jButton2 = new JButton("Refresh");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Inventory.this.refresh();
            }
        });
        box.add(jButton2);
        JButton jButton3 = new JButton("Close");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)Inventory.this.frame).setVisible(false);
            }
        });
        box.add(jButton3);
        return box;
    }

    protected void inventoryToText() {
        StringBuffer stringBuffer = new StringBuffer("");
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        if (fileChooser.showSaveDialog() == 1) {
            return;
        }
        this.mapSeparator = System.getProperty("line.separator");
        stringBuffer.append(this.results.getResultString());
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(fileChooser.getSelectedFile().getPath()));
            printWriter.print(stringBuffer);
            printWriter.close();
            Chatter.DisplayText displayText = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "Wrote " + fileChooser.getSelectedFile().getName());
            displayText.execute();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage());
        }
    }

    public GamePiece getSelectedCounter() {
        GamePiece gamePiece = null;
        CounterNode counterNode = (CounterNode)this.tree.getLastSelectedPathComponent();
        if (counterNode != null && counterNode.isLeaf()) {
            gamePiece = counterNode.getCounter().getPiece();
        }
        return gamePiece;
    }

    protected Component getComponent() {
        return this.launch;
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public void add(Buildable buildable) {
    }

    public void remove(Buildable buildable) {
    }

    protected void launch() {
        this.refresh();
        ((Component)this.frame).setVisible(true);
    }

    private void buildTreeModel() {
        Object object = Map.getAllMaps();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            map.getPieces();
        }
        object = new ArrayList();
        for (int i = 0; i < this.groupBy.length; ++i) {
            ((ArrayList)object).add(this.groupBy[i]);
        }
        this.results = new CounterInventory(new Counter(this.getConfigureName()), (ArrayList)object, this.sortPieces);
        PieceIterator pieceIterator = new PieceIterator(GameModule.getGameModule().getGameState().getPieces(), new Selector(this.piecePropertiesFilter));
        while (pieceIterator.hasMoreElements()) {
            Object object2;
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            GamePiece gamePiece = pieceIterator.nextPiece();
            for (n = 0; n < this.groupBy.length; ++n) {
                if (this.groupBy[n].length() <= 0 || (object2 = (String)gamePiece.getProperty(this.groupBy[n])) == null) continue;
                arrayList.add(gamePiece.getProperty(this.groupBy[n]));
            }
            n = 1;
            if (this.nonLeafFormat.length() > 0) {
                n = this.getTotalValue(gamePiece);
            }
            object2 = new Counter(gamePiece, arrayList, n, this.pieceFormat, this.sortFormat);
            this.results.insert((Counter)object2);
        }
    }

    protected int getTotalValue(GamePiece gamePiece) {
        String string = (String)gamePiece.getProperty(this.nonLeafFormat);
        int n = 1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Inventory.htm");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Button text", "Button icon", "Hotkey", "Tooltip", "Show only pieces matching these properties", "Sort and Group By Properties", "Label for folders", "Show only folders", "Label for pieces", "Sort", "Label for sort", "Sorting method", "Center on selected piece", "Forward key strokes to selected piece", "Show right-click menu of piece", "Draw piece images", "Zoom factor", "Available to these sides"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Inventory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Inventory.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$Inventory$IconConfig == null ? (class$VASSAL$build$module$Inventory$IconConfig = Inventory.class$("VASSAL.build.module.Inventory$IconConfig")) : class$VASSAL$build$module$Inventory$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Inventory.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$String == null ? (class$java$lang$String = Inventory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Inventory.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Inventory.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$String == null ? (class$java$lang$String = Inventory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$Inventory$PieceFormatConfig == null ? (class$VASSAL$build$module$Inventory$PieceFormatConfig = Inventory.class$("VASSAL.build.module.Inventory$PieceFormatConfig")) : class$VASSAL$build$module$Inventory$PieceFormatConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$Inventory$PieceFormatConfig == null ? (class$VASSAL$build$module$Inventory$PieceFormatConfig = Inventory.class$("VASSAL.build.module.Inventory$PieceFormatConfig")) : class$VASSAL$build$module$Inventory$PieceFormatConfig, class$VASSAL$build$module$Inventory$SortConfig == null ? (class$VASSAL$build$module$Inventory$SortConfig = Inventory.class$("VASSAL.build.module.Inventory$SortConfig")) : class$VASSAL$build$module$Inventory$SortConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Inventory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Double == null ? (class$java$lang$Double = Inventory.class$("java.lang.Double")) : class$java$lang$Double, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Inventory.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, ICON, HOTKEY, TOOLTIP, FILTER, GROUP_BY, NON_LEAF_FORMAT, FOLDERS_ONLY, LEAF_FORMAT, SORT_PIECES, SORT_FORMAT, SORTING, CENTERONPIECE, FORWARD_KEYSTROKE, SHOW_MENU, DRAW_PIECES, PIECE_ZOOM, SIDES};
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (FILTER.equals(string)) {
            this.piecePropertiesFilter = (String)object;
        } else if (GROUP_BY.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.groupBy = object;
        } else if (NON_LEAF_FORMAT.equals(string)) {
            this.nonLeafFormat = (String)object;
        } else if (LEAF_FORMAT.equals(string)) {
            this.pieceFormat = (String)object;
        } else if (CENTERONPIECE.equals(string)) {
            this.centerOnPiece = this.getBooleanValue(object);
        } else if (SHOW_MENU.equals(string)) {
            this.showMenu = this.getBooleanValue(object);
        } else if (DRAW_PIECES.equals(string)) {
            this.drawPieces = this.getBooleanValue(object);
        } else if (FOLDERS_ONLY.equals(string)) {
            this.foldersOnly = this.getBooleanValue(object);
            this.cutAboveLeaves = this.foldersOnly ? 1 : 0;
        } else if (PIECE_ZOOM.equals(string)) {
            if (object instanceof String) {
                object = Double.valueOf((String)object);
            }
            this.pieceZoom = (Double)object;
        } else if (FORWARD_KEYSTROKE.equals(string)) {
            this.forwardKeystroke = this.getBooleanValue(object);
        } else if (SIDES.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.sides = object;
        } else if (KEYSTROKE.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.keyStroke = (KeyStroke)object;
        } else if (CUTBELOWROOT.equals(string)) {
            this.cutBelowRoot = object instanceof String ? Integer.parseInt((String)object) : (Integer)object;
        } else if (CUTABOVELEAVES.equals(string)) {
            this.cutAboveLeaves = object instanceof String ? Integer.parseInt((String)object) : (Integer)object;
        } else if (SORT_PIECES.equals(string)) {
            this.sortPieces = this.getBooleanValue(object);
        } else if (SORT_FORMAT.equals(string)) {
            this.sortFormat = (String)object;
        } else if (SORTING.equals(string)) {
            this.sortStrategy = (String)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (PIECE_ZOOM.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Inventory.this.drawPieces && !Inventory.this.foldersOnly;
                }
            };
        }
        if (LEAF_FORMAT.equals(string) || CENTERONPIECE.equals(string) || FORWARD_KEYSTROKE.equals(string) || SHOW_MENU.equals(string) || DRAW_PIECES.equals(string)) {
            return this.piecesVisible;
        }
        return super.getAttributeVisibility(string);
    }

    protected boolean getBooleanValue(Object object) {
        if (object instanceof String) {
            object = new Boolean((String)object);
        }
        return (Boolean)object;
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILTER.equals(string)) {
            return this.piecePropertiesFilter;
        }
        if (GROUP_BY.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.groupBy);
        }
        if (NON_LEAF_FORMAT.equals(string)) {
            return this.nonLeafFormat;
        }
        if (LEAF_FORMAT.equals(string)) {
            return this.pieceFormat;
        }
        if (CENTERONPIECE.equals(string)) {
            return String.valueOf(this.centerOnPiece);
        }
        if (FORWARD_KEYSTROKE.equals(string)) {
            return String.valueOf(this.forwardKeystroke);
        }
        if (SHOW_MENU.equals(string)) {
            return String.valueOf(this.showMenu);
        }
        if (DRAW_PIECES.equals(string)) {
            return String.valueOf(this.drawPieces);
        }
        if (FOLDERS_ONLY.equals(string)) {
            return String.valueOf(this.foldersOnly);
        }
        if (PIECE_ZOOM.equals(string)) {
            return String.valueOf(this.pieceZoom);
        }
        if (SIDES.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.sides);
        }
        if (KEYSTROKE.equals(string)) {
            return HotKeyConfigurer.encode(this.keyStroke);
        }
        if (CUTBELOWROOT.equals(string)) {
            return this.cutBelowRoot + "";
        }
        if (CUTABOVELEAVES.equals(string)) {
            return this.cutAboveLeaves + "";
        }
        if (SORT_PIECES.equals(string)) {
            return this.sortPieces + "";
        }
        if (SORT_FORMAT.equals(string)) {
            return this.sortFormat;
        }
        if (SORTING.equals(string)) {
            return this.sortStrategy;
        }
        return this.launch.getAttributeValueString(string);
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void setup(boolean bl) {
        this.launch.setEnabled(bl && this.enabledForPlayersSide());
        if (bl) {
            this.setupLaunch();
        }
    }

    protected void setupLaunch() {
        this.launch.setEnabled(this.enabledForPlayersSide());
        this.launch.setVisible(this.launch.isEnabled());
    }

    public void sideChanged(String string, String string2) {
        this.setupLaunch();
    }

    protected boolean enabledForPlayersSide() {
        if (this.sides == null || this.sides.length == 0) {
            return true;
        }
        for (int i = 0; i < this.sides.length; ++i) {
            if (!this.sides[i].equalsIgnoreCase(PlayerRoster.getMySide())) continue;
            return true;
        }
        return false;
    }

    protected Command sendHotKeyToPieces(KeyStroke keyStroke) {
        Object object;
        NullCommand nullCommand = new NullCommand();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        HashSet<GamePiece> hashSet = new HashSet<GamePiece>();
        for (int i = 0; i < treePathArray.length; ++i) {
            object = (CounterNode)treePathArray[i].getLastPathComponent();
            if (((CounterNode)object).isLeaf()) {
                hashSet.add(((CounterNode)object).getCounter().getPiece());
                continue;
            }
            Iterator iterator = ((CounterNode)object).iterator();
            while (iterator.hasNext()) {
                CounterNode counterNode = (CounterNode)iterator.next();
                if (!counterNode.isLeaf()) continue;
                hashSet.add(counterNode.getCounter().getPiece());
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (GamePiece)iterator.next();
            GameModule.getGameModule().sendAndLog(object.keyEvent(keyStroke));
        }
        return nullCommand;
    }

    protected Command myUndoCommand() {
        return null;
    }

    private void refresh() {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.tree.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (!this.tree.isExpanded(n)) continue;
            hashSet.add(this.tree.getPathForRow(n).getLastPathComponent().toString());
        }
        this.buildTreeModel();
        this.tree.setModel(this.results);
        for (n = 0; n < this.tree.getRowCount(); ++n) {
            if (!hashSet.contains(this.tree.getPathForRow(n).getLastPathComponent().toString())) continue;
            this.tree.expandRow(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class CounterInventory
    implements TreeModel {
        protected Vector treeModelListeners = new Vector();
        protected java.util.Map inventory;
        protected CounterNode root;
        protected String resultString;
        protected ArrayList path;
        protected boolean changed;
        protected boolean sort;

        public CounterInventory(Counter counter, ArrayList arrayList, boolean bl) {
            this.root = new CounterNode(counter.getName(), counter);
            this.path = arrayList;
            this.inventory = new HashMap();
            this.sort = bl;
            this.changed = true;
        }

        public void insert(Counter counter) {
            String[] stringArray = counter.getPath();
            StringBuffer stringBuffer = new StringBuffer();
            CounterNode counterNode = this.root;
            CounterNode counterNode2 = null;
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (this.inventory.get(stringBuffer.toString()) == null) {
                    counterNode2 = new CounterNode(stringArray[i], new Counter(stringArray[i]), counterNode.getLevel() + 1);
                    this.inventory.put(stringBuffer.toString(), counterNode2);
                    counterNode.addChild(counterNode2, this.sort);
                }
                counterNode = (CounterNode)this.inventory.get(stringBuffer.toString());
            }
            counterNode2 = new CounterNode(counter.toString(), counter, counterNode.getLevel() + 1);
            counterNode.addChild(counterNode2, this.sort);
            this.changed = true;
        }

        private void updateEntries() {
            this.root.updateValues();
        }

        public String getResultString() {
            if (this.changed) {
                this.updateTree();
            }
            this.changed = false;
            return this.root.toResultString();
        }

        public String[] getResultStringArray() {
            return new String[]{this.getResultString()};
        }

        public Object getRoot() {
            if (this.changed) {
                this.updateTree();
            }
            return this.root;
        }

        private void updateTree() {
            this.updateEntries();
            if (Inventory.this.cutBelowRoot > 0) {
                this.root.cutLevel(Inventory.this.cutBelowRoot);
            }
            for (int i = Inventory.this.cutAboveLeaves; i > 0; --i) {
                this.root.cutLeaves();
            }
            this.changed = false;
        }

        public int getChildCount(Object object) {
            CounterNode counterNode = (CounterNode)object;
            return counterNode.getChildCount();
        }

        public boolean isLeaf(Object object) {
            CounterNode counterNode = (CounterNode)object;
            return counterNode.isLeaf();
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.add(treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.remove(treeModelListener);
        }

        public void fireNodesRemoved(Object[] objectArray, int[] nArray, Object[] objectArray2) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
            Enumeration enumeration = this.treeModelListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((TreeModelListener)enumeration.nextElement()).treeNodesRemoved(treeModelEvent);
            }
        }

        public Object getChild(Object object, int n) {
            CounterNode counterNode = (CounterNode)object;
            return counterNode.getChild(n);
        }

        public int getIndexOfChild(Object object, Object object2) {
            CounterNode counterNode = (CounterNode)object;
            return counterNode.getIndexOfChild(object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            throw new RuntimeException("No idea what to do!");
        }
    }

    public class CounterNode
    implements Comparable {
        protected final String entry;
        protected final Counter counter;
        protected List children;
        protected int level = 0;

        public CounterNode(String string, Counter counter, int n) {
            this(string, counter);
            this.level = n;
        }

        protected CounterNode(String string, Counter counter) {
            this.entry = string;
            this.counter = counter;
            counter.setNode(this);
            this.children = new ArrayList();
        }

        public String toString() {
            if (this.counter != null) {
                return this.counter.toString();
            }
            return this.getEntry();
        }

        protected String separator() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLevel() > 0) {
                stringBuffer.append(Inventory.this.mapSeparator);
            }
            for (int i = 0; i < this.getLevel(); ++i) {
                stringBuffer.append(Inventory.this.groupSeparator);
            }
            return stringBuffer.toString();
        }

        public String toResultString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.separator());
            if (this.counter != null) {
                stringBuffer.append(this.counter.toString());
            } else {
                stringBuffer.append(this.getEntry());
            }
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                CounterNode counterNode = (CounterNode)iterator.next();
                stringBuffer.append(counterNode.toResultString());
            }
            return stringBuffer.toString();
        }

        public String getEntry() {
            return this.entry;
        }

        public Counter getCounter() {
            return this.counter;
        }

        public void addChild(CounterNode counterNode, boolean bl) {
            this.children.add(counterNode);
            if (bl) {
                this.sortChildren();
            }
        }

        public void addChild(int n, CounterNode counterNode, boolean bl) {
            this.children.add(n, counterNode);
            if (bl) {
                this.sortChildren();
            }
        }

        protected void sortChildren() {
            if (Inventory.this.sortStrategy.equals(Inventory.ALPHA)) {
                Collections.sort(this.children);
            } else if (Inventory.this.sortStrategy.equals(Inventory.LENGTHALPHA)) {
                Collections.sort(this.children, new LengthAlpha());
            } else if (Inventory.this.sortStrategy.equals(Inventory.NUMERIC)) {
                Collections.sort(this.children, new Numerical());
            } else {
                Collections.sort(this.children);
            }
        }

        public void removeChild(CounterNode counterNode) {
            this.children.remove(counterNode);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public Object getChild(int n) {
            return this.children.get(n);
        }

        public int getIndexOfChild(Object object) {
            return this.children.indexOf(object);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public int updateValues() {
            int n = 0;
            if (this.counter != null) {
                n = this.counter.getValue();
            }
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                CounterNode counterNode = (CounterNode)iterator.next();
                n += counterNode.updateValues();
            }
            this.counter.setValue(n);
            return this.counter.getValue();
        }

        public Iterator iterator() {
            return this.children.iterator();
        }

        public void cutLevel(int n) {
            if (n == 0) {
                this.children.clear();
                return;
            }
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                CounterNode counterNode = (CounterNode)iterator.next();
                counterNode.cutLevel(n - 1);
            }
        }

        public void cutLeaves() {
            CounterNode counterNode;
            ArrayList<CounterNode> arrayList = new ArrayList<CounterNode>();
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                counterNode = (CounterNode)iterator.next();
                if (counterNode.isLeaf()) {
                    arrayList.add(counterNode);
                    continue;
                }
                counterNode.cutLeaves();
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                counterNode = (CounterNode)iterator.next();
                this.children.remove(counterNode);
            }
        }

        public int compareTo(Object object) {
            CounterNode counterNode = (CounterNode)object;
            return this.toSortKey().compareTo(counterNode.toSortKey());
        }

        protected String toSortKey() {
            String string = this.getEntry();
            if (this.counter != null) {
                string = this.counter.toSortKey();
            }
            if (!this.children.isEmpty()) {
                string = this.toString();
            }
            return string;
        }

        protected class LengthAlpha
        extends CompareCounterNodes
        implements Comparator {
            protected LengthAlpha() {
            }

            public int compare(Object object, Object object2) {
                int n;
                if (!this.argsOK(object, object2)) {
                    return this.compareStrangeArgs(object, object2);
                }
                CounterNode counterNode = (CounterNode)object;
                CounterNode counterNode2 = (CounterNode)object2;
                int n2 = counterNode.toSortKey().length();
                if (n2 < (n = counterNode2.toSortKey().length())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return counterNode.compareTo(counterNode2);
            }
        }

        protected class Numerical
        extends CompareCounterNodes
        implements Comparator {
            protected final String regex = "\\d+";
            protected final Pattern p = Pattern.compile("\\d+");

            protected Numerical() {
            }

            protected int getInt(String string) {
                int n = Integer.MIN_VALUE;
                Matcher matcher = this.p.matcher(string);
                if (!matcher.find()) {
                    return n;
                }
                int n2 = matcher.start();
                n = Integer.parseInt(string.substring(n2, matcher.end()));
                if (n2 > 0 && string.charAt(n2 - 1) == '-') {
                    n *= -1;
                }
                return n;
            }

            public int compare(Object object, Object object2) {
                int n;
                if (!this.argsOK(object, object2)) {
                    return this.compareStrangeArgs(object, object2);
                }
                CounterNode counterNode = (CounterNode)object;
                CounterNode counterNode2 = (CounterNode)object2;
                int n2 = this.getInt(counterNode.toSortKey());
                if (n2 < (n = this.getInt(counterNode2.toSortKey()))) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        }

        protected class Alpha
        extends CompareCounterNodes
        implements Comparator {
            protected Alpha() {
            }

            public int compare(Object object, Object object2) {
                if (!this.argsOK(object, object2)) {
                    return this.compareStrangeArgs(object, object2);
                }
                CounterNode counterNode = (CounterNode)object;
                CounterNode counterNode2 = (CounterNode)object2;
                return counterNode.compareTo(counterNode2);
            }
        }

        protected class CompareCounterNodes {
            protected CompareCounterNodes() {
            }

            protected boolean argsOK(Object object, Object object2) {
                return object != null && object2 != null && object instanceof CounterNode && object2 instanceof CounterNode;
            }

            protected int compareStrangeArgs(Object object, Object object2) {
                if (object2.equals(object2)) {
                    return 0;
                }
                if (object == null) {
                    return 1;
                }
                if (object2 == null) {
                    return -1;
                }
                if (object instanceof CounterNode && !(object2 instanceof CounterNode)) {
                    return -1;
                }
                if (object2 instanceof CounterNode && !(object instanceof CounterNode)) {
                    return 1;
                }
                throw new RuntimeException("These CounterNodes are not strange!");
            }
        }
    }

    protected class Selector
    implements PieceFilter {
        protected PieceFilter filter;

        public Selector(String string) {
            if (string != null && string.length() > 0) {
                this.filter = PropertiesPieceFilter.parse(string);
            }
        }

        public boolean accept(GamePiece gamePiece) {
            if (Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                return false;
            }
            if (gamePiece instanceof Stack) {
                return false;
            }
            if (gamePiece.getMap() == null) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.accept(gamePiece);
            }
            return true;
        }
    }

    public class Counter
    implements PropertySource {
        protected GamePiece piece;
        protected ArrayList groups;
        protected int value;
        protected String localName;
        protected FormattedString format;
        protected FormattedString sortingFormat;
        protected CounterNode node;

        public Counter(String string) {
            this(null, null, 0, inventory.nonLeafFormat, inventory.sortFormat);
            this.localName = string;
        }

        public Counter(GamePiece gamePiece, ArrayList arrayList, int n, String string, String string2) {
            this.piece = gamePiece;
            this.value = n;
            this.groups = arrayList;
            this.format = new FormattedString(string);
            this.sortingFormat = new FormattedString(string2);
        }

        public String getName() {
            if (this.piece != null) {
                return this.piece.getName();
            }
            return this.localName;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.format.getText(this);
        }

        public String toSortKey() {
            return this.sortingFormat.getText(this);
        }

        public String[] getPath() {
            String[] stringArray = new String[this.groups.size()];
            for (int i = 0; i < this.groups.size(); ++i) {
                stringArray[i] = (String)this.groups.get(i);
            }
            return stringArray;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public GamePiece getPiece() {
            return this.piece;
        }

        public void setPiece(GamePiece gamePiece) {
            this.piece = gamePiece;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Counter)) {
                return false;
            }
            Counter counter = (Counter)object;
            return this.getPath().equals(counter.getPath());
        }

        public Object getProperty(Object object) {
            Object object2 = null;
            String string = (String)object;
            if (string.startsWith("sum_")) {
                if (this.piece != null) {
                    object2 = this.piece.getProperty(string.substring(4));
                } else {
                    int n = 0;
                    int n2 = Inventory.this.results.getChildCount(this.node);
                    for (int i = 0; i < n2; ++i) {
                        try {
                            CounterNode counterNode = (CounterNode)Inventory.this.results.getChild(this.node, i);
                            n += Integer.parseInt((String)counterNode.getCounter().getProperty(object));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            ++n;
                        }
                    }
                    object2 = String.valueOf(n);
                }
            } else {
                if ("PropertyValue".equals(string)) {
                    return this.localName;
                }
                if (this.piece != null) {
                    object2 = this.piece.getProperty(object);
                }
            }
            return object2;
        }

        public void setNode(CounterNode counterNode) {
            this.node = counterNode;
        }
    }

    public class HotKeySender
    implements KeyListener {
        BoundsTracker tracker;

        public void keyCommand(KeyStroke keyStroke) {
            Command command;
            CounterNode counterNode;
            if (Inventory.this.forwardKeystroke && (counterNode = (CounterNode)Inventory.this.tree.getLastSelectedPathComponent()) != null && (command = this.getCommand(counterNode, keyStroke)) != null && !command.isNull()) {
                this.tracker.repaint();
                GameModule.getGameModule().sendAndLog(command);
                this.tracker = null;
                Inventory.this.refresh();
            }
        }

        protected Command getCommand(CounterNode counterNode, KeyStroke keyStroke) {
            GamePiece gamePiece = counterNode.getCounter() == null ? null : counterNode.getCounter().getPiece();
            Command command = null;
            if (gamePiece != null) {
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
                if (this.tracker == null) {
                    this.tracker = new BoundsTracker();
                    this.tracker.addPiece(gamePiece);
                }
                command = gamePiece.keyEvent(keyStroke);
            } else {
                command = new NullCommand();
                int n = counterNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    command = command.append(this.getCommand((CounterNode)counterNode.getChild(i), keyStroke));
                }
            }
            return command;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.keyCommand(KeyStroke.getKeyStrokeForEvent(keyEvent));
        }
    }

    public static class SortConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new StringEnumConfigurer(string, string2, SORT_OPTIONS);
        }
    }

    public static class PieceFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new GamePieceFormattedStringConfigurer(string, string2);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/inventory.gif");
        }
    }
}

