/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DefaultPieceCollection;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.ForwardToChatter;
import VASSAL.build.module.map.ForwardToKeyBuffer;
import VASSAL.build.module.map.ImageSaver;
import VASSAL.build.module.map.KeyBufferer;
import VASSAL.build.module.map.MapCenterer;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.module.map.Scroller;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.build.module.map.StackExpander;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.GlobalPropertiesContainer;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.MapWidget;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.MandatoryComponent;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.preferences.PositionOption;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.WrapLayout;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class Map
extends AbstractConfigurable
implements GameComponent,
FocusListener,
MouseListener,
MouseMotionListener,
DropTargetListener,
Configurable,
UniqueIdManager.Identifyable,
ToolBarComponent,
GlobalPropertiesContainer,
PropertySource,
PlayerRoster.SideChangeListener,
Runnable {
    private String mapID = "";
    private String mapName = "";
    private static final String MAIN_WINDOW_HEIGHT = "mainWindowHeight";
    private static UniqueIdManager idMgr = new UniqueIdManager("Map");
    protected JPanel theMap;
    private Vector drawComponents = new Vector();
    protected JScrollPane scroll;
    protected ComponentSplitter.SplitPane mainWindowDock;
    protected BoardPicker picker;
    protected JToolBar toolBar = new JToolBar();
    protected Zoomer zoom;
    protected StackMetrics metrics;
    protected Dimension edgeBuffer = new Dimension(0, 0);
    protected LaunchButton launchButton;
    protected boolean useLaunchButton = false;
    protected String markMovedOption = "Always";
    protected String markUnmovedIcon = "/images/unmoved.gif";
    protected MouseListener multicaster = null;
    protected Vector mouseListenerStack = new Vector();
    protected Vector boards = new Vector();
    private int[][] boardWidths;
    private int[][] boardHeights;
    protected PieceCollection pieces = new DefaultPieceCollection();
    protected java.util.Map globalProperties = new HashMap();
    protected Highlighter highlighter = new ColoredBorder();
    protected ArrayList highlighters = new ArrayList();
    private boolean clearFirst = false;
    private boolean hideCounters = false;
    protected float pieceOpacity = 1.0f;
    private boolean allowMultiple = false;
    private VisibilityCondition visibilityCondition;
    private DragGestureListener dragGestureListener;
    private String moveWithinFormat;
    private String moveToFormat;
    private String createFormat;
    private String changeFormat = "$message$";
    protected KeyStroke moveKey;
    protected JPanel root;
    private PropertyChangeListener globalPropertyListener;
    public static final String NAME = "mapName";
    public static final String MARK_MOVED = "markMoved";
    public static final String MARK_UNMOVED_ICON = "markUnmovedIcon";
    public static final String EDGE_WIDTH = "edgeWidth";
    public static final String EDGE_HEIGHT = "edgeHeight";
    public static final String HIGHLIGHT_COLOR = "color";
    public static final String HIGHLIGHT_THICKNESS = "thickness";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String USE_LAUNCH_BUTTON = "launch";
    public static final String BUTTON_NAME = "buttonName";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String SUPPRESS_AUTO = "suppressAuto";
    public static final String MOVE_WITHIN_FORMAT = "moveWithinFormat";
    public static final String MOVE_TO_FORMAT = "moveToFormat";
    public static final String CREATE_FORMAT = "createFormat";
    public static final String CHANGE_FORMAT = "changeFormat";
    public static final String MOVE_KEY = "moveKey";
    protected Thread scrollDelayThread;
    protected int scrollDelay = 200;
    protected long scrollExpirationTime;
    protected int scroll_dist;
    protected int scroll_dx;
    protected int scroll_dy;
    public static final String LOCATION = "location";
    public static final String OLD_LOCATION = "previousLocation";
    public static final String OLD_MAP = "previousMap";
    public static final String MAP_NAME = "mapName";
    public static final String PIECE_NAME = "pieceName";
    public static final String MESSAGE = "message";
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperties;
    static /* synthetic */ Class class$VASSAL$build$module$map$SelectionHighlighters;
    static /* synthetic */ Class class$VASSAL$build$module$map$BoardPicker;
    static /* synthetic */ Class class$VASSAL$build$module$map$StackMetrics;
    static /* synthetic */ Class class$VASSAL$build$module$map$DrawPile;
    static /* synthetic */ Class class$VASSAL$counters$Stack;
    static /* synthetic */ Class class$VASSAL$build$module$Map;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$GlobalOptions$Prompt;
    static /* synthetic */ Class class$VASSAL$build$module$Map$UnmovedIconConfig;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$Map$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$VASSAL$build$module$Map$MoveWithinFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$Map$MoveToFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$Map$CreateFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$Map$ChangeFormatConfig;
    static /* synthetic */ Class class$VASSAL$build$module$map$GlobalMap;
    static /* synthetic */ Class class$VASSAL$build$module$map$LOS_Thread;
    static /* synthetic */ Class class$VASSAL$build$module$ToolbarMenu;
    static /* synthetic */ Class class$VASSAL$build$module$MultiActionButton;
    static /* synthetic */ Class class$VASSAL$build$module$map$HidePiecesButton;
    static /* synthetic */ Class class$VASSAL$build$module$map$Zoomer;
    static /* synthetic */ Class class$VASSAL$build$module$map$CounterDetailViewer;
    static /* synthetic */ Class class$VASSAL$build$module$map$HighlightLastMoved;
    static /* synthetic */ Class class$VASSAL$build$module$map$LayeredPieceCollection;
    static /* synthetic */ Class class$VASSAL$build$module$map$ImageSaver;
    static /* synthetic */ Class class$VASSAL$build$module$map$TextSaver;
    static /* synthetic */ Class class$VASSAL$build$module$map$SetupStack;
    static /* synthetic */ Class class$VASSAL$build$module$map$MassKeyCommand;
    static /* synthetic */ Class class$VASSAL$build$module$map$MapShader;
    static /* synthetic */ Class class$VASSAL$build$module$map$PieceRecenterer;
    static /* synthetic */ Class class$VASSAL$build$module$ChartWindow;
    static /* synthetic */ Class class$VASSAL$build$widget$MapWidget;
    static /* synthetic */ Class class$VASSAL$build$module$properties$GlobalProperty;

    public Map() {
        this.getView();
        this.theMap.addMouseListener(this);
        this.theMap.addMouseMotionListener(this);
        this.theMap.addFocusListener(this);
        this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
    }

    public void setAttribute(String string, Object object) {
        if ("mapName".equals(string)) {
            this.setMapName((String)object);
        } else if (MARK_MOVED.equals(string)) {
            this.markMovedOption = (String)object;
        } else if (MARK_UNMOVED_ICON.equals(string)) {
            this.markUnmovedIcon = (String)object;
        } else if ("edge".equals(string)) {
            String string2 = (String)object;
            int n = string2.indexOf(",");
            if (n > 0) {
                this.edgeBuffer = new Dimension(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
            }
        } else if (EDGE_WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            try {
                this.edgeBuffer = new Dimension((Integer)object, this.edgeBuffer.height);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (EDGE_HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            try {
                this.edgeBuffer = new Dimension(this.edgeBuffer.width, (Integer)object);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (ALLOW_MULTIPLE.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.allowMultiple = (Boolean)object;
            if (this.picker != null) {
                this.picker.setAllowMultiple(this.allowMultiple);
            }
        } else if (HIGHLIGHT_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                ((ColoredBorder)this.highlighter).setColor((Color)object);
            }
        } else if (HIGHLIGHT_THICKNESS.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            if (this.highlighter instanceof ColoredBorder) {
                ((ColoredBorder)this.highlighter).setThickness((Integer)object);
            }
        } else if (USE_LAUNCH_BUTTON.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            this.useLaunchButton = (Boolean)object;
            this.launchButton.setVisible(this.useLaunchButton);
        } else if (SUPPRESS_AUTO.equals(string)) {
            if (object instanceof String) {
                object = new Boolean((String)object);
            }
            if (Boolean.TRUE.equals(object)) {
                this.moveWithinFormat = "";
            }
        } else if (MOVE_WITHIN_FORMAT.equals(string)) {
            this.moveWithinFormat = (String)object;
        } else if (MOVE_TO_FORMAT.equals(string)) {
            this.moveToFormat = (String)object;
        } else if (CREATE_FORMAT.equals(string)) {
            this.createFormat = (String)object;
        } else if (CHANGE_FORMAT.equals(string)) {
            this.changeFormat = (String)object;
        } else if (MOVE_KEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.moveKey = (KeyStroke)object;
        } else {
            this.launchButton.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if ("mapName".equals(string)) {
            return this.getMapName();
        }
        if (MARK_MOVED.equals(string)) {
            return this.markMovedOption;
        }
        if (MARK_UNMOVED_ICON.equals(string)) {
            return this.markUnmovedIcon;
        }
        if (EDGE_WIDTH.equals(string)) {
            return "" + this.edgeBuffer.width;
        }
        if (EDGE_HEIGHT.equals(string)) {
            return "" + this.edgeBuffer.height;
        }
        if (ALLOW_MULTIPLE.equals(string)) {
            return "" + this.picker.isAllowMultiple();
        }
        if (HIGHLIGHT_COLOR.equals(string)) {
            if (this.highlighter instanceof ColoredBorder) {
                return ColorConfigurer.colorToString(((ColoredBorder)this.highlighter).getColor());
            }
            return null;
        }
        if (HIGHLIGHT_THICKNESS.equals(string)) {
            if (this.highlighter instanceof ColoredBorder) {
                return "" + ((ColoredBorder)this.highlighter).getThickness();
            }
            return null;
        }
        if (USE_LAUNCH_BUTTON.equals(string)) {
            return String.valueOf(this.useLaunchButton);
        }
        if (MOVE_WITHIN_FORMAT.equals(string)) {
            return this.getMoveWithinFormat();
        }
        if (MOVE_TO_FORMAT.equals(string)) {
            return this.getMoveToFormat();
        }
        if (CREATE_FORMAT.equals(string)) {
            return this.getCreateFormat();
        }
        if (CHANGE_FORMAT.equals(string)) {
            return this.getChangeFormat();
        }
        if (MOVE_KEY.equals(string)) {
            return HotKeyConfigurer.encode(this.moveKey);
        }
        return this.launchButton.getAttributeValueString(string);
    }

    public void build(Element element) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Map.this.mainWindowDock == null && Map.this.launchButton.isEnabled() && Map.this.theMap.getTopLevelAncestor() != null) {
                    Map.this.theMap.getTopLevelAncestor().setVisible(!Map.this.theMap.getTopLevelAncestor().isVisible());
                }
            }
        };
        this.launchButton = new LaunchButton("Map", BUTTON_NAME, HOTKEY, ICON, actionListener);
        this.launchButton.setEnabled(false);
        this.launchButton.setVisible(false);
        if (element != null) {
            super.build(element);
        } else {
            this.getBoardPicker();
            this.getStackMetrics();
            this.addChild(new ForwardToKeyBuffer());
            this.addChild(new Scroller());
            this.addChild(new ForwardToChatter());
            this.addChild(new MenuDisplayer());
            this.addChild(new MapCenterer());
            this.addChild(new StackExpander());
            this.addChild(new PieceMover());
            this.addChild(new KeyBufferer());
            this.addChild(new ImageSaver());
            this.addChild(new CounterDetailViewer());
            this.setMapName("Main Map");
        }
        if (!this.getComponents(class$VASSAL$build$module$properties$GlobalProperties == null ? (class$VASSAL$build$module$properties$GlobalProperties = Map.class$("VASSAL.build.module.properties.GlobalProperties")) : class$VASSAL$build$module$properties$GlobalProperties).hasMoreElements()) {
            this.addChild(new GlobalProperties());
        }
        if (!this.getComponents(class$VASSAL$build$module$map$SelectionHighlighters == null ? (class$VASSAL$build$module$map$SelectionHighlighters = Map.class$("VASSAL.build.module.map.SelectionHighlighters")) : class$VASSAL$build$module$map$SelectionHighlighters).hasMoreElements()) {
            this.addChild(new SelectionHighlighters());
        }
        this.setup(false);
    }

    private void addChild(Buildable buildable) {
        this.add(buildable);
        buildable.addTo(this);
    }

    public void setBoardPicker(BoardPicker boardPicker) {
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(boardPicker);
            GameModule.getGameModule().getGameState().addGameComponent(boardPicker);
        }
        this.picker = boardPicker;
        if (boardPicker != null) {
            boardPicker.setAllowMultiple(this.allowMultiple);
            GameModule.getGameModule().addCommandEncoder(boardPicker);
            GameModule.getGameModule().getGameState().addGameComponent(boardPicker);
        }
    }

    public BoardPicker getBoardPicker() {
        if (this.picker == null) {
            this.picker = new BoardPicker();
            this.picker.build(null);
            this.add(this.picker);
            this.picker.addTo(this);
        }
        return this.picker;
    }

    public void setZoomer(Zoomer zoomer) {
        this.zoom = zoomer;
    }

    public Zoomer getZoomer() {
        return this.zoom;
    }

    public void setStackMetrics(StackMetrics stackMetrics) {
        this.metrics = stackMetrics;
    }

    public StackMetrics getStackMetrics() {
        if (this.metrics == null) {
            this.metrics = new StackMetrics();
            this.metrics.build(null);
            this.add(this.metrics);
            this.metrics.addTo(this);
        }
        return this.metrics;
    }

    public double getZoom() {
        return this.zoom == null ? 1.0 : this.zoom.getZoomFactor();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public PropertyChangeListener getPropertyListener() {
        if (this.globalPropertyListener == null) {
            this.globalPropertyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Map.this.globalProperties.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
                    Map.this.repaint();
                }
            };
        }
        return this.globalPropertyListener;
    }

    public void addDrawComponent(Drawable drawable) {
        this.drawComponents.addElement(drawable);
    }

    public void removeDrawComponent(Drawable drawable) {
        this.drawComponents.removeElement(drawable);
    }

    public void addTo(Buildable buildable) {
        idMgr.add(this);
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, class$VASSAL$build$module$map$BoardPicker == null ? (class$VASSAL$build$module$map$BoardPicker = Map.class$("VASSAL.build.module.map.BoardPicker")) : class$VASSAL$build$module$map$BoardPicker), new MandatoryComponent(this, class$VASSAL$build$module$map$StackMetrics == null ? (class$VASSAL$build$module$map$StackMetrics = Map.class$("VASSAL.build.module.map.StackMetrics")) : class$VASSAL$build$module$map$StackMetrics)).append(idMgr);
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (Map.this.mouseListenerStack.size() == 0 && Map.this.dragGestureListener != null) {
                    Map.this.dragGestureListener.dragGestureRecognized(dragGestureEvent);
                }
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.theMap, 2, dragGestureListener);
        this.theMap.setDropTarget(PieceMover.DragHandler.makeDropTarget(this.theMap, 2, this));
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getToolBar().add(this.launchButton);
        if (this.shouldDockIntoMainWindow()) {
            IntConfigurer intConfigurer = new IntConfigurer(MAIN_WINDOW_HEIGHT, null, new Integer(-1));
            GameModule.getGameModule().getGlobalPrefs().addOption(null, intConfigurer);
            this.root = new JPanel(new BorderLayout());
            this.root.add((Component)this.scroll, "Center");
            ComponentSplitter componentSplitter = new ComponentSplitter();
            this.mainWindowDock = componentSplitter.splitBottom(componentSplitter.getSplitAncestor(GameModule.getGameModule().getControlPanel(), -1), this.root, true);
            GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.theMap, 0));
        } else {
            GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.theMap, 2));
        }
        PlayerRoster.addSideChangeListener(this);
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        Window window = SwingUtilities.getWindowAncestor(this.theMap);
        if (window != null) {
            window.dispose();
        }
        GameModule.getGameModule().getToolBar().remove(this.launchButton);
        idMgr.remove(this);
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(this.picker);
            GameModule.getGameModule().getGameState().addGameComponent(this.picker);
        }
        PlayerRoster.removeSideChangeListener(this);
    }

    public void sideChanged(String string, String string2) {
        this.repaint();
    }

    public synchronized void setBoards(Enumeration enumeration) {
        this.boards.removeAllElements();
        System.gc();
        while (enumeration.hasMoreElements()) {
            Board board = (Board)enumeration.nextElement();
            board.setMap(this);
            this.boards.addElement(board);
        }
        this.setBoardBoundaries();
    }

    public Command getRestoreCommand() {
        return null;
    }

    public Board findBoard(Point point) {
        for (int i = 0; i < this.boards.size(); ++i) {
            Board board = (Board)this.boards.elementAt(i);
            if (!board.bounds().contains(point)) continue;
            return board;
        }
        return null;
    }

    public Zone findZone(Point point) {
        MapGrid mapGrid;
        Board board = this.findBoard(point);
        if (board != null && (mapGrid = board.getGrid()) != null && mapGrid instanceof ZonedGrid) {
            Rectangle rectangle = board.bounds();
            point.translate(-rectangle.x, -rectangle.y);
            return ((ZonedGrid)mapGrid).findZone(point);
        }
        return null;
    }

    public Zone findZone(String string) {
        Iterator iterator = ((AbstractList)this.boards).iterator();
        while (iterator.hasNext()) {
            Board board = (Board)iterator.next();
            if (!(board.getGrid() instanceof ZonedGrid)) continue;
            return ((ZonedGrid)board.getGrid()).findZone(string);
        }
        return null;
    }

    public Board getBoardByName(String string) {
        Board board = null;
        if (string != null) {
            Enumeration enumeration = this.getAllBoards();
            while (enumeration.hasMoreElements()) {
                Board board2 = (Board)enumeration.nextElement();
                if (!string.equals(board2.getName())) continue;
                board = board2;
                break;
            }
        }
        return board;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(this.getZoom() * (double)this.mapSize().width), (int)(this.getZoom() * (double)this.mapSize().height));
    }

    public synchronized Dimension mapSize() {
        Rectangle rectangle = new Rectangle(0, 0);
        for (int i = 0; i < this.boards.size(); ++i) {
            Board board = (Board)this.boards.elementAt(i);
            rectangle = rectangle.union(board.bounds());
        }
        rectangle.width += this.edgeBuffer.width;
        rectangle.height += this.edgeBuffer.height;
        return rectangle.getSize();
    }

    public boolean isLocationRestricted(Point point) {
        Board board = this.findBoard(point);
        if (board != null) {
            Rectangle rectangle = board.bounds();
            Point point2 = new Point(point);
            point2.translate(-rectangle.x, -rectangle.y);
            return board.isLocationRestricted(point2);
        }
        return false;
    }

    public Point snapTo(Point point) {
        Point point2 = new Point(point);
        Board board = this.findBoard(point);
        if (board == null) {
            return point2;
        }
        Rectangle rectangle = board.bounds();
        point2.translate(-rectangle.x, -rectangle.y);
        point2 = board.snapTo(point2);
        point2.translate(rectangle.x, rectangle.y);
        if (this.findBoard(point2) == null) {
            point2.translate(-rectangle.x, -rectangle.y);
            if (point2.x == rectangle.width) {
                point2.x = rectangle.width - 1;
            } else if (point2.x == -1) {
                point2.x = 0;
            }
            if (point2.y == rectangle.height) {
                point2.y = rectangle.height - 1;
            } else if (point2.y == -1) {
                point2.y = 0;
            }
            point2.translate(rectangle.x, rectangle.y);
        }
        return point2;
    }

    public Dimension getEdgeBuffer() {
        return new Dimension(this.edgeBuffer);
    }

    public Point mapCoordinates(Point point) {
        Point point2 = new Point(point.x, point.y);
        point2.x = (int)((double)point2.x / this.getZoom());
        point2.y = (int)((double)point2.y / this.getZoom());
        return point2;
    }

    public Rectangle mapRectangle(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        rectangle.x = (int)((double)rectangle.x / this.getZoom());
        rectangle.y = (int)((double)rectangle.y / this.getZoom());
        rectangle.width = (int)((double)rectangle.width / this.getZoom());
        rectangle.height = (int)((double)rectangle.height / this.getZoom());
        return rectangle;
    }

    public Point componentCoordinates(Point point) {
        Point point2 = new Point(point.x, point.y);
        point2.x = (int)((double)point2.x * this.getZoom());
        point2.y = (int)((double)point2.y * this.getZoom());
        return point2;
    }

    public Rectangle componentRectangle(Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        rectangle.x = (int)((double)rectangle.x * this.getZoom());
        rectangle.y = (int)((double)rectangle.y * this.getZoom());
        rectangle.width = (int)((double)rectangle.width * this.getZoom());
        rectangle.height = (int)((double)rectangle.height * this.getZoom());
        return rectangle;
    }

    public String locationName(Point point) {
        Board board;
        String string = this.getDeckNameAt(point);
        if (string == null && (board = this.findBoard(point)) != null) {
            string = board.locationName(new Point(point.x - board.bounds().x, point.y - board.bounds().y));
        }
        if (string == null) {
            string = "offboard";
        }
        return string;
    }

    public String getFullLocationName(Point point, boolean bl) {
        String string = "";
        if (bl && this.getMapName() != null && this.getMapName().length() > 0) {
            string = "[" + this.getMapName() + "]";
        }
        if (this.isVisibleToAll() && point != null) {
            String string2 = this.getDeckNameContaining(point);
            if (string2 == null) {
                if (this.locationName(point) != null) {
                    string = this.locationName(point) + string;
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    public boolean isVisibleToAll() {
        return !(this instanceof PrivateMap) || this.getAttributeValueString("visible").equals("true");
    }

    public String getDeckNameContaining(Point point) {
        String string = null;
        if (point != null) {
            Enumeration enumeration = this.getComponents(class$VASSAL$build$module$map$DrawPile == null ? (class$VASSAL$build$module$map$DrawPile = Map.class$("VASSAL.build.module.map.DrawPile")) : class$VASSAL$build$module$map$DrawPile);
            while (enumeration.hasMoreElements()) {
                DrawPile drawPile = (DrawPile)enumeration.nextElement();
                Rectangle rectangle = drawPile.boundingBox();
                if (rectangle == null || !rectangle.contains(point)) continue;
                string = drawPile.getConfigureName();
                break;
            }
        }
        return string;
    }

    public String getDeckNameAt(Point point) {
        String string = null;
        if (point != null) {
            Enumeration enumeration = this.getComponents(class$VASSAL$build$module$map$DrawPile == null ? (class$VASSAL$build$module$map$DrawPile = Map.class$("VASSAL.build.module.map.DrawPile")) : class$VASSAL$build$module$map$DrawPile);
            while (enumeration.hasMoreElements()) {
                DrawPile drawPile = (DrawPile)enumeration.nextElement();
                if (!drawPile.getPosition().equals(point)) continue;
                string = drawPile.getConfigureName();
                break;
            }
        }
        return string;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            boolean bl = false;
            ArrayList arrayList = new ArrayList();
            Object object = KeyBuffer.getBuffer().getPieces();
            while (object.hasMoreElements()) {
                arrayList.add(object.nextElement());
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                GamePiece gamePiece = (GamePiece)object.next();
                if (gamePiece.getMap() != this) continue;
                KeyBuffer.getBuffer().remove(gamePiece);
                bl = true;
            }
            if (bl) {
                this.theMap.repaint();
            }
        }
    }

    public void addLocalMouseListener(MouseListener mouseListener) {
        this.multicaster = AWTEventMulticaster.add(this.multicaster, mouseListener);
    }

    public void removeLocalMouseListener(MouseListener mouseListener) {
        this.multicaster = AWTEventMulticaster.remove(this.multicaster, mouseListener);
    }

    public void pushMouseListener(MouseListener mouseListener) {
        this.mouseListenerStack.addElement(mouseListener);
    }

    public void popMouseListener() {
        this.mouseListenerStack.removeElement(this.mouseListenerStack.lastElement());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mouseListenerStack.size() > 0) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            ((MouseListener)this.mouseListenerStack.lastElement()).mouseClicked(mouseEvent);
        } else if (this.multicaster != null) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.multicaster.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseListenerStack.size() > 0) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            ((MouseListener)this.mouseListenerStack.lastElement()).mousePressed(mouseEvent);
        } else if (this.multicaster != null) {
            Point point = this.mapCoordinates(mouseEvent.getPoint());
            mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
            this.multicaster.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.translate(this.theMap.getLocation().x, this.theMap.getLocation().y);
        if (this.theMap.getBounds().contains(point)) {
            if (this.mouseListenerStack.size() > 0) {
                point = this.mapCoordinates(mouseEvent.getPoint());
                mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
                ((MouseListener)this.mouseListenerStack.lastElement()).mouseReleased(mouseEvent);
            } else if (this.multicaster != null) {
                point = this.mapCoordinates(mouseEvent.getPoint());
                mouseEvent.translatePoint(point.x - mouseEvent.getX(), point.y - mouseEvent.getY());
                this.multicaster.mouseReleased(mouseEvent);
            }
            this.theMap.requestFocus();
        }
        this.clearFirst = true;
        this.theMap.repaint();
    }

    public void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    public DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.restartDelay();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.scrollAtEdge(dropTargetDragEvent.getLocation(), 15);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.scroll_dx = 0;
        this.scroll_dy = 0;
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.getDropTargetContext().getComponent() == this.theMap) {
            MouseEvent mouseEvent = new MouseEvent(this.theMap, 502, System.currentTimeMillis(), 0, dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y, 1, false);
            this.theMap.dispatchEvent(mouseEvent);
            dropTargetDropEvent.dropComplete(true);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this.scrollAtEdge(mouseEvent.getPoint(), 15);
        } else {
            this.restartDelay();
        }
    }

    public void scrollAtEdge(Point point, int n) {
        Point point2 = new Point(point.x - this.scroll.getViewport().getViewPosition().x, point.y - this.scroll.getViewport().getViewPosition().y);
        int n2 = 0;
        int n3 = 0;
        if (point2.x < n && point2.x >= 0) {
            n2 = -1;
        }
        if (point2.x >= this.scroll.getViewport().getSize().width - n && point2.x < this.scroll.getViewport().getSize().width) {
            n2 = 1;
        }
        if (point2.y < n && point2.y >= 0) {
            n3 = -1;
        }
        if (point2.y >= this.scroll.getViewport().getSize().height - n && point2.y < this.scroll.getViewport().getSize().height) {
            n3 = 1;
        }
        this.scroll_dx = n2;
        this.scroll_dy = n3;
        this.scroll_dist = n;
        if (n2 != 0 || n3 != 0) {
            if (this.scrollDelayThread == null || !this.scrollDelayThread.isAlive()) {
                this.scrollDelayThread = new Thread(this);
                this.scrollDelayThread.start();
            }
        } else {
            this.restartDelay();
        }
    }

    protected void restartDelay() {
        this.scrollExpirationTime = System.currentTimeMillis() + (long)this.scrollDelay;
    }

    public void run() {
        while (System.currentTimeMillis() < this.scrollExpirationTime) {
            try {
                Thread.sleep(Math.max(0L, this.scrollExpirationTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.scroll_dx != 0 || this.scroll_dy != 0) {
            this.scroll(2 * this.scroll_dist * this.scroll_dx, 2 * this.scroll_dist * this.scroll_dy);
        }
    }

    public void repaint(boolean bl) {
        this.clearFirst = bl;
        this.theMap.repaint();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, 0, 0);
    }

    public void paintRegion(Graphics graphics, Rectangle rectangle) {
        this.clearMapBorder(graphics);
        this.drawBoardsInRegion(graphics, rectangle);
        this.drawDrawable(graphics, false);
        this.drawPiecesInRegion(graphics, rectangle);
        this.drawDrawable(graphics, true);
    }

    public void drawBoardsInRegion(Graphics graphics, Rectangle rectangle) {
        for (int i = 0; i < this.boards.size(); ++i) {
            Board board = (Board)this.boards.elementAt(i);
            Point point = this.getLocation(board, this.getZoom());
            board.drawRegion(graphics, point, rectangle, this.getZoom(), this.theMap);
        }
    }

    public void repaint() {
        this.theMap.repaint();
    }

    public void drawPiecesInRegion(Graphics graphics, Rectangle rectangle) {
        if (!this.hideCounters) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
            GamePiece[] gamePieceArray = this.pieces.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                Point point = this.componentCoordinates(gamePieceArray[i].getPosition());
                if (gamePieceArray[i].getClass() == (class$VASSAL$counters$Stack == null ? Map.class$("VASSAL.counters.Stack") : class$VASSAL$counters$Stack)) {
                    this.getStackMetrics().draw((Stack)gamePieceArray[i], point, graphics, this, this.getZoom(), rectangle);
                    continue;
                }
                gamePieceArray[i].draw(graphics, point.x, point.y, this.theMap, this.getZoom());
                if (!Boolean.TRUE.equals(gamePieceArray[i].getProperty("Selected"))) continue;
                this.highlighter.draw(gamePieceArray[i], graphics, point.x, point.y, this.theMap, this.getZoom());
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawPieces(Graphics graphics, int n, int n2) {
        if (!this.hideCounters) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
            GamePiece[] gamePieceArray = this.pieces.getPieces();
            for (int i = 0; i < gamePieceArray.length; ++i) {
                Point point = this.componentCoordinates(gamePieceArray[i].getPosition());
                gamePieceArray[i].draw(graphics, point.x + n, point.y + n2, this.theMap, this.getZoom());
                if (!Boolean.TRUE.equals(gamePieceArray[i].getProperty("Selected"))) continue;
                this.highlighter.draw(gamePieceArray[i], graphics, point.x - n, point.y - n2, this.theMap, this.getZoom());
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawDrawable(Graphics graphics, boolean bl) {
        Enumeration enumeration = this.drawComponents.elements();
        while (enumeration.hasMoreElements()) {
            Drawable drawable = (Drawable)enumeration.nextElement();
            if (bl ^ drawable.drawAboveCounters()) continue;
            drawable.draw(graphics, this);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.drawBoards(graphics, n, n2, this.getZoom(), this.theMap);
        this.drawDrawable(graphics, false);
        this.drawPieces(graphics, n, n2);
        this.drawDrawable(graphics, true);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    public void addHighlighter(Highlighter highlighter) {
        this.highlighters.add(highlighter);
    }

    public void removeHighlighter(Highlighter highlighter) {
        ((AbstractCollection)this.highlighters).remove(highlighter);
    }

    public Iterator getHighlighters() {
        return ((AbstractList)this.highlighters).iterator();
    }

    public Enumeration getAllBoards() {
        return this.boards.elements();
    }

    public int getBoardCount() {
        return this.boards.size();
    }

    public Rectangle boundingBoxOf(GamePiece gamePiece) {
        Rectangle rectangle = null;
        if (gamePiece.getMap() == this) {
            Object object;
            rectangle = gamePiece.boundingBox();
            Point point = gamePiece.getPosition();
            rectangle.translate(point.x, point.y);
            if (Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) {
                rectangle = rectangle.union(this.highlighter.boundingBox(gamePiece));
                object = this.getHighlighters();
                while (object.hasNext()) {
                    rectangle = rectangle.union(((Highlighter)object).boundingBox(gamePiece));
                }
            }
            if (gamePiece.getParent() != null) {
                object = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
                rectangle.translate(((Point)object).x, ((Point)object).y);
            }
        }
        return rectangle;
    }

    public Rectangle selectionBoundsOf(GamePiece gamePiece) {
        if (gamePiece.getMap() != this) {
            throw new RuntimeException("Piece is not on this map");
        }
        Rectangle rectangle = gamePiece.getShape().getBounds();
        rectangle.translate(gamePiece.getPosition().x, gamePiece.getPosition().y);
        if (gamePiece.getParent() != null) {
            Point point = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
            rectangle.translate(point.x, point.y);
        }
        return rectangle;
    }

    public Point positionOf(GamePiece gamePiece) {
        if (gamePiece.getMap() != this) {
            throw new RuntimeException("Piece is not on this map");
        }
        Point point = gamePiece.getPosition();
        if (gamePiece.getParent() != null) {
            Point point2 = this.getStackMetrics().relativePosition(gamePiece.getParent(), gamePiece);
            point.translate(point2.x, point2.y);
        }
        return point;
    }

    public GamePiece[] getPieces() {
        return this.pieces.getPieces();
    }

    public GamePiece[] getAllPieces() {
        return this.pieces.getAllPieces();
    }

    public void setPieceCollection(PieceCollection pieceCollection) {
        this.pieces = pieceCollection;
    }

    public PieceCollection getPieceCollection() {
        return this.pieces;
    }

    protected void clearMapBorder(Graphics graphics) {
        if (this.clearFirst || this.boards.size() == 0) {
            graphics.clearRect(0, 0, this.theMap.getSize().width, this.theMap.getSize().height);
            this.clearFirst = false;
        } else {
            Dimension dimension = new Dimension((int)(this.getZoom() * (double)this.edgeBuffer.width), (int)(this.getZoom() * (double)this.edgeBuffer.height));
            graphics.clearRect(0, 0, dimension.width, this.theMap.getSize().height);
            graphics.clearRect(0, 0, this.theMap.getSize().width, dimension.height);
            graphics.clearRect(this.theMap.getSize().width - dimension.width, 0, dimension.width, this.theMap.getSize().height);
            graphics.clearRect(0, this.theMap.getSize().height - dimension.height, this.theMap.getSize().width, dimension.height);
        }
    }

    protected void setBoardBoundaries() {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.boards.size();
        for (n = 0; n < n4; ++n) {
            object2 = ((Board)this.boards.get(n)).relativePosition();
            n2 = Math.max(n2, ((Point)object2).x);
            n3 = Math.max(n3, ((Point)object2).y);
        }
        this.boardWidths = new int[n2 + 1][n3 + 1];
        this.boardHeights = new int[n2 + 1][n3 + 1];
        n4 = this.boards.size();
        for (n = 0; n < n4; ++n) {
            object2 = (Board)this.boards.get(n);
            object = ((Board)object2).relativePosition();
            this.boardWidths[((Point)object).x][((Point)object).y] = ((Board)object2).bounds().width;
            this.boardHeights[((Point)object).x][((Point)object).y] = ((Board)object2).bounds().height;
        }
        Point point = new Point(this.edgeBuffer.width, this.edgeBuffer.height);
        int n5 = this.boards.size();
        for (n4 = 0; n4 < n5; ++n4) {
            object = (Board)this.boards.get(n4);
            Point point2 = ((Board)object).relativePosition();
            Point point3 = this.getLocation(point2.x, point2.y, 1.0);
            ((Board)object).setLocation(point3.x, point3.y);
            ((Board)object).translate(point.x, point.y);
        }
        this.theMap.revalidate();
    }

    protected Point getLocation(Board board, double d) {
        Point point;
        if (d == 1.0) {
            point = board.bounds().getLocation();
        } else {
            Point point2 = board.relativePosition();
            point = this.getLocation(point2.x, point2.y, d);
            point.translate((int)(d * (double)this.edgeBuffer.width), (int)(d * (double)this.edgeBuffer.height));
        }
        return point;
    }

    protected Point getLocation(int n, int n2, double d) {
        int n3;
        Point point = new Point();
        for (n3 = 0; n3 < n; ++n3) {
            point.translate((int)Math.floor(d * (double)this.boardWidths[n3][n2]), 0);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            point.translate(0, (int)Math.floor(d * (double)this.boardHeights[n][n3]));
        }
        return point;
    }

    public void drawBoards(Graphics graphics, int n, int n2, double d, Component component) {
        for (int i = 0; i < this.boards.size(); ++i) {
            Board board = (Board)this.boards.elementAt(i);
            Point point = this.getLocation(board, d);
            point.translate(n, n2);
            board.draw(graphics, point.x, point.y, d, component);
        }
    }

    public void repaint(Rectangle rectangle) {
        rectangle.setLocation(this.componentCoordinates(new Point(rectangle.x, rectangle.y)));
        rectangle.setSize((int)((double)rectangle.width * this.getZoom()), (int)((double)rectangle.height * this.getZoom()));
        this.theMap.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setPiecesVisible(boolean bl) {
        this.hideCounters = !bl;
    }

    public boolean isPiecesVisible() {
        return !this.hideCounters && this.pieceOpacity != 0.0f;
    }

    public float getPieceOpacity() {
        return this.pieceOpacity;
    }

    public void setPieceOpacity(float f) {
        this.pieceOpacity = f;
    }

    public Object getProperty(Object object) {
        Object object2 = null;
        object2 = this.globalProperties.get(object);
        if (object2 == null) {
            object2 = GameModule.getGameModule().getProperty(object);
        }
        return object2;
    }

    public KeyStroke getMoveKey() {
        return this.moveKey;
    }

    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame());
            jDialog.setDefaultCloseOperation(0);
            jDialog.setTitle(this.getDefaultWindowTitle());
            return jDialog;
        }
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(0);
        jFrame.setTitle(this.getDefaultWindowTitle());
        return jFrame;
    }

    public boolean shouldDockIntoMainWindow() {
        boolean bl = false;
        if (GlobalOptions.getInstance().isUseSingleWindow() && !this.useLaunchButton) {
            Map map;
            bl = true;
            Enumeration enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = Map.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map);
            while (enumeration.hasMoreElements() && (map = (Map)enumeration.nextElement()) != this) {
                if (!map.shouldDockIntoMainWindow()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void setup(boolean bl) {
        if (bl) {
            if (this.shouldDockIntoMainWindow()) {
                this.mainWindowDock.showComponent();
                int n = (Integer)GameModule.getGameModule().getGlobalPrefs().getValue(MAIN_WINDOW_HEIGHT);
                if (n > 0) {
                    Container container = this.mainWindowDock.getTopLevelAncestor();
                    container.setSize(container.getSize().width, n);
                }
                if (this.toolBar.getParent() == null) {
                    GameModule.getGameModule().getToolBar().addSeparator();
                    GameModule.getGameModule().getToolBar().add(this.toolBar);
                }
                this.toolBar.setVisible(true);
            } else {
                if (SwingUtilities.getWindowAncestor(this.theMap) == null) {
                    final Window window = this.createParentFrame();
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            if (Map.this.useLaunchButton) {
                                ((Component)window).setVisible(false);
                            } else {
                                GameModule.getGameModule().getGameState().setup(false);
                            }
                        }
                    });
                    ((RootPaneContainer)((Object)window)).getContentPane().add("North", this.getToolBar());
                    ((RootPaneContainer)((Object)window)).getContentPane().add("Center", this.scroll);
                    ((Component)window).setSize(600, 400);
                    PositionOption positionOption = new PositionOption(PositionOption.key + this.getIdentifier(), window);
                    GameModule.getGameModule().getPrefs().addOption(positionOption);
                }
                this.theMap.getTopLevelAncestor().setVisible(!this.useLaunchButton);
                this.theMap.revalidate();
            }
        } else {
            this.pieces.clear();
            this.boards.removeAllElements();
            System.gc();
            if (this.mainWindowDock != null) {
                if (this.mainWindowDock.getHideableComponent().isVisible()) {
                    GameModule.getGameModule().getGlobalPrefs().getOption(MAIN_WINDOW_HEIGHT).setValue(new Integer(this.mainWindowDock.getTopLevelAncestor().getSize().height));
                }
                this.mainWindowDock.hideComponent();
                this.toolBar.setVisible(false);
            } else if (this.theMap.getTopLevelAncestor() != null) {
                this.theMap.getTopLevelAncestor().setVisible(false);
            }
        }
        this.launchButton.setEnabled(bl);
        this.launchButton.setVisible(this.useLaunchButton);
    }

    public void appendToTitle(String string) {
        if (this.mainWindowDock == null) {
            Container container = this.theMap.getTopLevelAncestor();
            if (string == null) {
                if (container instanceof JFrame) {
                    ((JFrame)container).setTitle(this.getDefaultWindowTitle());
                }
                if (container instanceof JDialog) {
                    ((JDialog)container).setTitle(this.getDefaultWindowTitle());
                }
            } else {
                if (container instanceof JFrame) {
                    ((JFrame)container).setTitle(((JFrame)container).getTitle() + string);
                }
                if (container instanceof JDialog) {
                    ((JDialog)container).setTitle(((JDialog)container).getTitle() + string);
                }
            }
        }
    }

    protected String getDefaultWindowTitle() {
        return this.getMapName().length() > 0 ? this.getMapName() : GameModule.getGameModule().getGameName() + " map";
    }

    public GamePiece findPiece(Point point, PieceFinder pieceFinder) {
        GamePiece[] gamePieceArray = this.pieces.getPieces();
        for (int i = gamePieceArray.length - 1; i >= 0; --i) {
            GamePiece gamePiece = pieceFinder.select(this, gamePieceArray[i], point);
            if (gamePiece == null) continue;
            return gamePiece;
        }
        return null;
    }

    public GamePiece findAnyPiece(Point point, PieceFinder pieceFinder) {
        GamePiece[] gamePieceArray = this.pieces.getAllPieces();
        for (int i = gamePieceArray.length - 1; i >= 0; --i) {
            GamePiece gamePiece = pieceFinder.select(this, gamePieceArray[i], point);
            if (gamePiece == null) continue;
            return gamePiece;
        }
        return null;
    }

    public Command placeAt(GamePiece gamePiece, Point point) {
        Command command = null;
        if (GameModule.getGameModule().getGameState().getPieceForId(gamePiece.getId()) == null) {
            gamePiece.setPosition(point);
            this.addPiece(gamePiece);
            GameModule.getGameModule().getGameState().addPiece(gamePiece);
            command = new AddPiece(gamePiece);
        } else {
            MoveTracker moveTracker = new MoveTracker(gamePiece);
            gamePiece.setPosition(point);
            this.addPiece(gamePiece);
            command = moveTracker.getMoveCommand();
        }
        return command;
    }

    public Command apply(PieceVisitorDispatcher pieceVisitorDispatcher) {
        GamePiece[] gamePieceArray = this.pieces.getPieces();
        Command command = null;
        for (int i = 0; i < gamePieceArray.length && command == null; ++i) {
            command = (Command)pieceVisitorDispatcher.accept(gamePieceArray[i]);
        }
        return command;
    }

    public Command placeOrMerge(GamePiece gamePiece, Point point) {
        Command command = this.apply(new DeckVisitorDispatcher(new Merger(this, point, gamePiece)));
        if (command == null || command.isNull()) {
            command = this.placeAt(gamePiece, point);
        }
        return command;
    }

    public void addPiece(GamePiece gamePiece) {
        if (this.indexOf(gamePiece) < 0) {
            if (gamePiece.getParent() != null) {
                gamePiece.getParent().remove(gamePiece);
                gamePiece.setParent(null);
            }
            if (gamePiece.getMap() != null && gamePiece.getMap() != this) {
                gamePiece.getMap().removePiece(gamePiece);
            }
            this.pieces.add(gamePiece);
            gamePiece.setMap(this);
            this.theMap.repaint();
        }
    }

    public void reposition(GamePiece gamePiece, int n) {
    }

    public int indexOf(GamePiece gamePiece) {
        return this.pieces.indexOf(gamePiece);
    }

    public void removePiece(GamePiece gamePiece) {
        this.pieces.remove(gamePiece);
        this.theMap.repaint();
    }

    public void centerAt(Point point) {
        this.centerAt(point, 0, 0);
    }

    public void centerAt(Point point, int n, int n2) {
        if (this.scroll != null) {
            point = this.componentCoordinates(point);
            point.translate(-this.scroll.getViewport().getSize().width / 2, -this.scroll.getViewport().getSize().height / 2);
            Rectangle rectangle = new Rectangle(point, this.scroll.getViewport().getSize());
            rectangle.width = n > rectangle.width ? 0 : rectangle.width - n;
            rectangle.height = n2 > rectangle.height ? 0 : rectangle.height - n2;
            this.theMap.scrollRectToVisible(rectangle);
        }
    }

    public void ensureVisible(Rectangle rectangle) {
        if (this.scroll != null) {
            Point point = this.componentCoordinates(rectangle.getLocation());
            rectangle = new Rectangle(point.x, point.y, (int)(this.getZoom() * (double)rectangle.width), (int)(this.getZoom() * (double)rectangle.height));
            this.theMap.scrollRectToVisible(rectangle);
        }
    }

    public void scroll(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.scroll.getViewport().getViewRect());
        rectangle.translate(n, n2);
        rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), this.getPreferredSize()));
        this.theMap.scrollRectToVisible(rectangle);
    }

    public static String getConfigureTypeName() {
        return "Map Window";
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String string) {
        this.mapName = string;
        this.setConfigureName(this.mapName);
        this.launchButton.setToolTipText(string != null ? "Show/hide " + string + " window" : "Show/hide Map window");
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm");
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Map Name", "Mark pieces that move (if they possess the proper trait)", "\"Mark unmoved\" button icon", "Horizontal Padding", "Vertical Padding", "Can contain multiple boards", "Border color for selected counters", "Border thickness for selected counters", "Include toolbar button to show/hide", "Toolbar button name", "Toolbar button icon", "Hotkey", "Auto-report format for movement within this map", "Auto-report format for movement to this map", "Auto-report format for units created in this map", "Auto-report format for units modified on this map", "Key Command to apply to all units ending movement on this map"};
    }

    public String[] getAttributeNames() {
        return new String[]{"mapName", MARK_MOVED, MARK_UNMOVED_ICON, EDGE_WIDTH, EDGE_HEIGHT, ALLOW_MULTIPLE, HIGHLIGHT_COLOR, HIGHLIGHT_THICKNESS, USE_LAUNCH_BUTTON, BUTTON_NAME, ICON, HOTKEY, MOVE_WITHIN_FORMAT, MOVE_TO_FORMAT, CREATE_FORMAT, CHANGE_FORMAT, MOVE_KEY};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Map.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$GlobalOptions$Prompt == null ? (class$VASSAL$build$module$GlobalOptions$Prompt = Map.class$("VASSAL.build.module.GlobalOptions$Prompt")) : class$VASSAL$build$module$GlobalOptions$Prompt, class$VASSAL$build$module$Map$UnmovedIconConfig == null ? (class$VASSAL$build$module$Map$UnmovedIconConfig = Map.class$("VASSAL.build.module.Map$UnmovedIconConfig")) : class$VASSAL$build$module$Map$UnmovedIconConfig, class$java$lang$Integer == null ? (class$java$lang$Integer = Map.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = Map.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Map.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = Map.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = Map.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Map.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = Map.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$Map$IconConfig == null ? (class$VASSAL$build$module$Map$IconConfig = Map.class$("VASSAL.build.module.Map$IconConfig")) : class$VASSAL$build$module$Map$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Map.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$VASSAL$build$module$Map$MoveWithinFormatConfig == null ? (class$VASSAL$build$module$Map$MoveWithinFormatConfig = Map.class$("VASSAL.build.module.Map$MoveWithinFormatConfig")) : class$VASSAL$build$module$Map$MoveWithinFormatConfig, class$VASSAL$build$module$Map$MoveToFormatConfig == null ? (class$VASSAL$build$module$Map$MoveToFormatConfig = Map.class$("VASSAL.build.module.Map$MoveToFormatConfig")) : class$VASSAL$build$module$Map$MoveToFormatConfig, class$VASSAL$build$module$Map$CreateFormatConfig == null ? (class$VASSAL$build$module$Map$CreateFormatConfig = Map.class$("VASSAL.build.module.Map$CreateFormatConfig")) : class$VASSAL$build$module$Map$CreateFormatConfig, class$VASSAL$build$module$Map$ChangeFormatConfig == null ? (class$VASSAL$build$module$Map$ChangeFormatConfig = Map.class$("VASSAL.build.module.Map$ChangeFormatConfig")) : class$VASSAL$build$module$Map$ChangeFormatConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = Map.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public String getCreateFormat() {
        Board board;
        if (this.createFormat != null) {
            return this.createFormat;
        }
        String string = "$pieceName$ created in $location$";
        if (this.boards.size() > 0 && ((board = (Board)this.boards.firstElement()).getGrid() == null || board.getGrid().getGridNumbering() == null)) {
            string = "";
        }
        return string;
    }

    public String getChangeFormat() {
        return this.changeFormat;
    }

    public String getMoveToFormat() {
        Board board;
        if (this.moveToFormat != null) {
            return this.moveToFormat;
        }
        String string = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (this.boards.size() > 0 && ((board = (Board)this.boards.firstElement()).getGrid() == null || board.getGrid().getGridNumbering() != null)) {
            string = "";
        }
        return string;
    }

    public String getMoveWithinFormat() {
        Board board;
        if (this.moveWithinFormat != null) {
            return this.moveWithinFormat;
        }
        String string = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (this.boards.size() > 0 && (board = (Board)this.boards.firstElement()).getGrid() == null) {
            string = "";
        }
        return string;
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray = new Class[]{class$VASSAL$build$module$map$GlobalMap == null ? (class$VASSAL$build$module$map$GlobalMap = Map.class$("VASSAL.build.module.map.GlobalMap")) : class$VASSAL$build$module$map$GlobalMap, class$VASSAL$build$module$map$LOS_Thread == null ? (class$VASSAL$build$module$map$LOS_Thread = Map.class$("VASSAL.build.module.map.LOS_Thread")) : class$VASSAL$build$module$map$LOS_Thread, class$VASSAL$build$module$ToolbarMenu == null ? (class$VASSAL$build$module$ToolbarMenu = Map.class$("VASSAL.build.module.ToolbarMenu")) : class$VASSAL$build$module$ToolbarMenu, class$VASSAL$build$module$MultiActionButton == null ? (class$VASSAL$build$module$MultiActionButton = Map.class$("VASSAL.build.module.MultiActionButton")) : class$VASSAL$build$module$MultiActionButton, class$VASSAL$build$module$map$HidePiecesButton == null ? (class$VASSAL$build$module$map$HidePiecesButton = Map.class$("VASSAL.build.module.map.HidePiecesButton")) : class$VASSAL$build$module$map$HidePiecesButton, class$VASSAL$build$module$map$Zoomer == null ? (class$VASSAL$build$module$map$Zoomer = Map.class$("VASSAL.build.module.map.Zoomer")) : class$VASSAL$build$module$map$Zoomer, class$VASSAL$build$module$map$CounterDetailViewer == null ? (class$VASSAL$build$module$map$CounterDetailViewer = Map.class$("VASSAL.build.module.map.CounterDetailViewer")) : class$VASSAL$build$module$map$CounterDetailViewer, class$VASSAL$build$module$map$HighlightLastMoved == null ? (class$VASSAL$build$module$map$HighlightLastMoved = Map.class$("VASSAL.build.module.map.HighlightLastMoved")) : class$VASSAL$build$module$map$HighlightLastMoved, class$VASSAL$build$module$map$LayeredPieceCollection == null ? (class$VASSAL$build$module$map$LayeredPieceCollection = Map.class$("VASSAL.build.module.map.LayeredPieceCollection")) : class$VASSAL$build$module$map$LayeredPieceCollection, class$VASSAL$build$module$map$ImageSaver == null ? (class$VASSAL$build$module$map$ImageSaver = Map.class$("VASSAL.build.module.map.ImageSaver")) : class$VASSAL$build$module$map$ImageSaver, class$VASSAL$build$module$map$TextSaver == null ? (class$VASSAL$build$module$map$TextSaver = Map.class$("VASSAL.build.module.map.TextSaver")) : class$VASSAL$build$module$map$TextSaver, class$VASSAL$build$module$map$DrawPile == null ? (class$VASSAL$build$module$map$DrawPile = Map.class$("VASSAL.build.module.map.DrawPile")) : class$VASSAL$build$module$map$DrawPile, class$VASSAL$build$module$map$SetupStack == null ? (class$VASSAL$build$module$map$SetupStack = Map.class$("VASSAL.build.module.map.SetupStack")) : class$VASSAL$build$module$map$SetupStack, class$VASSAL$build$module$map$MassKeyCommand == null ? (class$VASSAL$build$module$map$MassKeyCommand = Map.class$("VASSAL.build.module.map.MassKeyCommand")) : class$VASSAL$build$module$map$MassKeyCommand, class$VASSAL$build$module$map$MapShader == null ? (class$VASSAL$build$module$map$MapShader = Map.class$("VASSAL.build.module.map.MapShader")) : class$VASSAL$build$module$map$MapShader, class$VASSAL$build$module$map$PieceRecenterer == null ? (class$VASSAL$build$module$map$PieceRecenterer = Map.class$("VASSAL.build.module.map.PieceRecenterer")) : class$VASSAL$build$module$map$PieceRecenterer};
        return classArray;
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (this.visibilityCondition == null) {
            this.visibilityCondition = new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Map.this.useLaunchButton;
                }
            };
        }
        if (HOTKEY.equals(string)) {
            return this.visibilityCondition;
        }
        if (BUTTON_NAME.equals(string)) {
            return this.visibilityCondition;
        }
        return super.getAttributeVisibility(string);
    }

    public void setId(String string) {
        this.mapID = string;
    }

    public static Map getMapById(String string) {
        return (Map)idMgr.findInstance(string);
    }

    public static Iterator getAllMaps() {
        AbstractConfigurable abstractConfigurable;
        ArrayList<Map> arrayList = new ArrayList<Map>();
        Enumeration enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$Map == null ? (class$VASSAL$build$module$Map = Map.class$("VASSAL.build.module.Map")) : class$VASSAL$build$module$Map);
        while (enumeration.hasMoreElements()) {
            abstractConfigurable = (Map)enumeration.nextElement();
            arrayList.add((Map)abstractConfigurable);
        }
        enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$ChartWindow == null ? (class$VASSAL$build$module$ChartWindow = Map.class$("VASSAL.build.module.ChartWindow")) : class$VASSAL$build$module$ChartWindow);
        while (enumeration.hasMoreElements()) {
            abstractConfigurable = (ChartWindow)enumeration.nextElement();
            Enumeration enumeration2 = abstractConfigurable.getAllDescendantComponents(class$VASSAL$build$widget$MapWidget == null ? Map.class$("VASSAL.build.widget.MapWidget") : class$VASSAL$build$widget$MapWidget);
            while (enumeration2.hasMoreElements()) {
                arrayList.add(((MapWidget)enumeration2.nextElement()).getMap());
            }
        }
        return arrayList.iterator();
    }

    public GlobalProperty getGlobalProperty(String string) {
        GlobalProperty globalProperty = null;
        Enumeration enumeration = this.getComponents(class$VASSAL$build$module$properties$GlobalProperties == null ? (class$VASSAL$build$module$properties$GlobalProperties = Map.class$("VASSAL.build.module.properties.GlobalProperties")) : class$VASSAL$build$module$properties$GlobalProperties);
        if (enumeration != null) {
            Enumeration enumeration2 = ((GlobalProperties)enumeration.nextElement()).getComponents(class$VASSAL$build$module$properties$GlobalProperty == null ? (class$VASSAL$build$module$properties$GlobalProperty = Map.class$("VASSAL.build.module.properties.GlobalProperty")) : class$VASSAL$build$module$properties$GlobalProperty);
            while (enumeration2.hasMoreElements() && globalProperty == null) {
                GlobalProperty globalProperty2 = (GlobalProperty)enumeration2.nextElement();
                if (!globalProperty2.getConfigureName().equals(string)) continue;
                globalProperty = globalProperty2;
            }
        }
        return globalProperty;
    }

    public String getId() {
        return this.mapID;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.scroll = new AdjustableSpeedScrollPane(this.theMap, 20, 30);
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        }
        return this.theMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class View
    extends JPanel {
        protected Map map;

        public View(Map map) {
            this.setFocusTraversalKeysEnabled(false);
            this.map = map;
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getVisibleRect();
            graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.map.paintRegion(graphics, rectangle);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return this.map.getPreferredSize();
        }

        public Map getMap() {
            return this.map;
        }
    }

    public static class Merger
    implements DeckVisitor {
        private Point pt;
        private Map map;
        private GamePiece p;

        public Merger(Map map, Point point, GamePiece gamePiece) {
            this.map = map;
            this.pt = point;
            this.p = gamePiece;
        }

        public Object visitDeck(Deck deck) {
            if (deck.getPosition().equals(this.pt)) {
                return this.map.getStackMetrics().merge(deck, this.p);
            }
            return null;
        }

        public Object visitStack(Stack stack) {
            if (stack.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && stack.topPiece() != null && this.map.getPieceCollection().canMerge(stack, this.p)) {
                return this.map.getStackMetrics().merge(stack, this.p);
            }
            return null;
        }

        public Object visitDefault(GamePiece gamePiece) {
            if (gamePiece.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible")) && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && this.map.getPieceCollection().canMerge(gamePiece, this.p)) {
                return this.map.getStackMetrics().merge(gamePiece, this.p);
            }
            return null;
        }
    }

    public static class ChangeFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.MESSAGE, "menuCommand", "oldPieceName", "newPieceName", "mapName", Map.LOCATION});
        }
    }

    public static class CreateFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, "mapName", Map.LOCATION});
        }
    }

    public static class MoveToFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, Map.LOCATION, Map.OLD_MAP, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class MoveWithinFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{Map.PIECE_NAME, Map.LOCATION, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class UnmovedIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/unmoved.gif");
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/map.gif");
        }
    }
}

