/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;

public class ModuleExtension
extends AbstractBuildable
implements GameComponent {
    public static final String BASE_MODULE_NAME = "module";
    public static final String BASE_MODULE_VERSION = "moduleVersion";
    public static final String VERSION = "version";
    public static final String VASSAL_VERSION_CREATED = "vassalVersion";
    private DataArchive archive;
    private String version = "0.0";
    private String lastSave;
    private String vassalVersionCreated;
    private AbstractAction editAction;
    static /* synthetic */ Class class$VASSAL$build$module$ModuleExtension;

    public ModuleExtension(DataArchive dataArchive) {
        this.archive = dataArchive;
    }

    public String getVersion() {
        return this.version;
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public void build() {
        String string = "buildFile";
        InputStream inputStream = null;
        if (this.archive != null) {
            try {
                inputStream = this.archive.getFileStream(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        GameModule.getGameModule().getDataArchive().addExtension(this.archive);
        try {
            if (inputStream == null) {
                this.build(null);
            } else {
                Document document = Builder.createDocument(inputStream);
                this.build(document.getDocumentElement());
            }
        }
        catch (IOException iOException) {
            throw new IllegalBuildException(iOException.getMessage());
        }
        GameModule.getGameModule().add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        if (this.archive instanceof ArchiveWriter) {
            this.lastSave = this.buildString();
        }
    }

    public Command getRestoreCommand() {
        return new RegCmd(this.getName(), this.version);
    }

    public void setup(boolean bl) {
    }

    public String[] getAttributeNames() {
        return new String[]{VERSION, BASE_MODULE_NAME, BASE_MODULE_VERSION, VASSAL_VERSION_CREATED};
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public void removeFrom(Buildable buildable) {
        throw new IllegalBuildException("Cannot remove Extension");
    }

    public boolean confirmExit() {
        boolean bl = true;
        if (this.archive instanceof ArchiveWriter && !this.buildString().equals(this.lastSave)) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), "Save Extension?", "", 1)) {
                case 0: {
                    try {
                        this.save();
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                    break;
                }
                case 2: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public String getAttributeValueString(String string) {
        String string2 = null;
        if (BASE_MODULE_NAME.equals(string)) {
            string2 = GameModule.getGameModule().getGameName();
        } else if (BASE_MODULE_VERSION.equals(string)) {
            string2 = GameModule.getGameModule().getGameVersion();
        } else if (VERSION.equals(string)) {
            string2 = this.version;
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            string2 = this.vassalVersionCreated;
        }
        return string2;
    }

    public void setAttribute(String string, Object object) {
        if (BASE_MODULE_NAME.equals(string)) {
            if (!GameModule.getGameModule().getGameName().equals(object)) {
                throw new IllegalBuildException("Extension '" + this.getName() + "' was built for module '" + object + "'");
            }
        } else if (BASE_MODULE_VERSION.equals(string)) {
            String string2 = (String)object;
            if (Info.compareVersions(GameModule.getGameModule().getGameVersion(), string2) < 0) {
                GameModule.getGameModule().warn("Extension '" + this.getName() + "' was built for module version " + string2 + ".  You are running version " + GameModule.getGameModule().getGameVersion() + ".  It's recommended you upgrade to the latest version of " + GameModule.getGameModule().getGameName());
            }
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            this.vassalVersionCreated = (String)object;
            String string3 = Info.getVersion();
            if (Info.compareVersions(this.vassalVersionCreated, string3) > 0) {
                GameModule.getGameModule().warn("Extension " + this.getName() + " was created using version " + object + " of the VASSAL engine\nYou are using version " + string3 + ".  It's recommended you upgrade to the latest version of the VASSAL engine.");
            }
        } else if (VERSION.equals(string)) {
            this.version = (String)object;
        }
    }

    public void addTo(Buildable buildable) {
    }

    public String getName() {
        String string = "Extension";
        if (this.archive != null) {
            string = this.archive.getName();
            int n = string.lastIndexOf(File.separatorChar);
            if (n < string.length()) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(46)) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public String buildString() {
        Document document = Builder.createNewDocument();
        document.appendChild(this.getBuildElement(document));
        return Builder.toString(document);
    }

    public void save() throws IOException {
        this.vassalVersionCreated = Info.getVersion();
        if (!(this.archive instanceof ArchiveWriter)) {
            throw new IOException("Read-only extension");
        }
        String string = this.buildString();
        ((ArchiveWriter)this.archive).addFile("buildFile", new ByteArrayInputStream(string.getBytes("UTF-8")));
        ((ArchiveWriter)this.archive).write();
        this.lastSave = string;
    }

    public void saveAs() throws IOException {
        this.vassalVersionCreated = Info.getVersion();
        if (!(this.archive instanceof ArchiveWriter)) {
            throw new IOException("Read-only extension");
        }
        String string = this.buildString();
        ((ArchiveWriter)this.archive).addFile("buildFile", new ByteArrayInputStream(string.getBytes("UTF-8")));
        ((ArchiveWriter)this.archive).saveAs();
        this.lastSave = string;
    }

    public void remove(ExtensionElement extensionElement) {
        this.buildComponents.remove(extensionElement);
    }

    public Action getEditAction(final JDialog jDialog) {
        if (this.editAction == null) {
            jDialog.setName(this.getName());
            final StringConfigurer stringConfigurer = new StringConfigurer(VERSION, "Version", this.version);
            jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
            jDialog.getContentPane().add(stringConfigurer.getControls());
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("Save");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ModuleExtension.this.setAttribute(ModuleExtension.VERSION, stringConfigurer.getValue());
                    jDialog.dispose();
                }
            });
            box.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            box.add(jButton2);
            jDialog.getContentPane().add(box);
            jDialog.pack();
            jDialog.setLocationRelativeTo(jDialog.getParent());
            this.editAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)jDialog).setVisible(true);
                }
            };
            URL uRL = this.getClass().getResource("/images/Edit16.gif");
            if (uRL != null) {
                this.editAction.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.editAction.putValue("Name", "Edit");
            }
            this.editAction.putValue("ShortDescription", "Extension Properties");
        }
        return this.editAction;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RegCmd
    extends Command {
        private String name;
        private String version;

        public RegCmd(String string, String string2) {
            this.name = string;
            this.version = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        protected void executeCommand() {
            boolean bl = false;
            String string = null;
            Enumeration enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$ModuleExtension == null ? (class$VASSAL$build$module$ModuleExtension = ModuleExtension.class$("VASSAL.build.module.ModuleExtension")) : class$VASSAL$build$module$ModuleExtension);
            while (enumeration.hasMoreElements()) {
                ModuleExtension moduleExtension = (ModuleExtension)enumeration.nextElement();
                if (!moduleExtension.getName().equals(this.name)) continue;
                bl = true;
                if (Info.compareVersions(moduleExtension.getVersion(), this.version) >= 0) break;
                string = "Game saved with version " + this.version + " of extension '" + this.name + "', you are running version " + moduleExtension.getVersion() + ". Please upgrade to the latest version of this extension.";
                GameModule.getGameModule().warn(string);
                break;
            }
            if (!bl) {
                string = "This game was saved with extension '" + this.name + "' loaded. You do not have this extension loaded." + "Place the file into the '" + ExtensionsLoader.getExtensionDirectory() + "' folder to load it.";
                GameModule.getGameModule().warn(string);
            }
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

