/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.noteswindow.PrivateNotesController;
import VASSAL.build.module.noteswindow.SecretNotesController;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.tools.LaunchButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class NotesWindow
extends AbstractConfigurable
implements GameComponent,
CommandEncoder {
    private JDialog frame;
    private LaunchButton launch;
    private TextConfigurer notes;
    private PrivateNotesController privateNotes = new PrivateNotesController();
    private SecretNotesController secretNotes = new SecretNotesController();
    private static final String COMMAND_PREFIX = "NOTES\t";
    public static final String HOT_KEY = "hotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    private String lastSavedNotes;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$NotesWindow$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;

    public NotesWindow() {
        this.frame = new NotesDialog();
        this.frame.setTitle("Notes");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesWindow.this.captureState();
                ((Component)NotesWindow.this.frame).setVisible(!NotesWindow.this.frame.isShowing());
            }
        };
        this.launch = new LaunchButton("Notes", BUTTON_TEXT, HOT_KEY, ICON, actionListener);
        this.launch.setAttribute(ICON, "/images/notes.gif");
        this.launch.setToolTipText("Notes");
        this.frame.pack();
        this.setup(false);
    }

    protected void captureState() {
        this.lastSavedNotes = (String)this.notes.getValue();
        this.privateNotes.captureState();
        this.secretNotes.captureState();
    }

    public void cancel() {
        this.restoreState();
        this.privateNotes.restoreState();
        this.secretNotes.restoreState();
    }

    protected void restoreState() {
        this.notes.setValue(this.lastSavedNotes);
    }

    protected void save() {
        NullCommand nullCommand = new NullCommand();
        if (!this.lastSavedNotes.equals(this.notes.getValue())) {
            nullCommand.append(new SetNote(this.notes.getValueString()));
        }
        nullCommand.append(this.privateNotes.save());
        nullCommand.append(this.secretNotes.save());
        GameModule.getGameModule().sendAndLog(nullCommand);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "NotesWindow");
    }

    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, ICON, HOT_KEY};
    }

    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof SetNote) {
            string = COMMAND_PREFIX + ((SetNote)command).msg;
        } else {
            string = this.privateNotes.encode(command);
            if (string == null) {
                string = this.secretNotes.encode(command);
            }
        }
        return string;
    }

    public Command decode(String string) {
        Command command;
        if (string.startsWith(COMMAND_PREFIX)) {
            command = new SetNote(string.substring(COMMAND_PREFIX.length()));
        } else {
            command = this.privateNotes.decode(string);
            if (command == null) {
                command = this.secretNotes.decode(string);
            }
        }
        return command;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Button text", "Button Icon", "Hotkey"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = NotesWindow.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$NotesWindow$IconConfig == null ? (class$VASSAL$build$module$NotesWindow$IconConfig = NotesWindow.class$("VASSAL.build.module.NotesWindow$IconConfig")) : class$VASSAL$build$module$NotesWindow$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = NotesWindow.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return "Notes Window";
    }

    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.privateNotes);
        GameModule.getGameModule().addCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.secretNotes);
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.privateNotes);
        GameModule.getGameModule().removeCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.secretNotes);
    }

    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
        if (!bl) {
            this.notes.setValue("");
        }
    }

    public Command getRestoreCommand() {
        SetNote setNote = new SetNote(this.notes.getValueString());
        setNote.append(this.privateNotes.getRestoreCommand());
        setNote.append(this.secretNotes.getRestoreCommand());
        return setNote;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SetNote
    extends Command {
        private String msg;

        private SetNote(String string) {
            this.msg = string;
        }

        protected void executeCommand() {
            NotesWindow.this.notes.setValue(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((NotesWindow)autoConfigurable).launch.getAttributeValueString(NotesWindow.ICON));
        }
    }

    private class NotesDialog
    extends JDialog {
        private NotesDialog() {
            super(GameModule.getGameModule().getFrame());
            this.initComponents();
            this.setLocationRelativeTo(this.getOwner());
        }

        private void initComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ NotesDialog this$1;
                {
                    this.this$1 = notesDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    NotesDialog.access$300(this.this$1).cancel();
                    ((Component)this.this$1).setVisible(false);
                }
            });
            NotesWindow.this.notes = new TextConfigurer(null, null);
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.getContentPane().add(jTabbedPane);
            Box box = Box.createVerticalBox();
            box.add(new JLabel("Visible to all"));
            box.add(NotesWindow.this.notes.getControls());
            jTabbedPane.addTab("Public", box);
            jTabbedPane.addTab("Private", NotesWindow.this.privateNotes.getControls());
            jTabbedPane.addTab("Delayed", NotesWindow.this.secretNotes.getControls());
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("Save");
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ NotesDialog this$1;
                {
                    this.this$1 = notesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    NotesDialog.access$300(this.this$1).save();
                    ((Component)this.this$1).setVisible(false);
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ NotesDialog this$1;
                {
                    this.this$1 = notesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    NotesDialog.access$300(this.this$1).cancel();
                    ((Component)this.this$1).setVisible(false);
                }
            });
            jPanel.add(jButton2);
            this.getContentPane().add(jPanel);
        }

        static /* synthetic */ NotesWindow access$300(NotesDialog notesDialog) {
            return notesDialog.NotesWindow.this;
        }
    }
}

