/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PlayerRoster;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;

public class ObscurableOptions
implements CommandEncoder,
GameComponent {
    private static ObscurableOptions instance;
    public static final String COMMAND_ID = "UNMASK\t";
    public static final String PREFS_KEY = "OpponentUnmaskable";
    private Vector allowed = new Vector();
    private Boolean override;

    private ObscurableOptions() {
    }

    public static ObscurableOptions getInstance() {
        if (instance == null) {
            instance = new ObscurableOptions();
        }
        return instance;
    }

    public void allowSome(String string) {
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(PREFS_KEY, string);
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        booleanConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    ObscurableOptions.getInstance().allow(GameModule.getUserId());
                    String string = PlayerRoster.getMySide();
                    if (string != null) {
                        ObscurableOptions.getInstance().allow(string);
                    }
                } else {
                    ObscurableOptions.getInstance().disallow(GameModule.getUserId());
                    String string = PlayerRoster.getMySide();
                    if (string != null) {
                        ObscurableOptions.getInstance().disallow(string);
                    }
                }
                GameModule.getGameModule().getServer().sendToOthers(new SetAllowed(instance.allowed));
            }
        });
        if (Boolean.TRUE.equals(booleanConfigurer.getValue())) {
            this.allow(GameModule.getUserId());
        } else {
            this.disallow(GameModule.getUserId());
        }
    }

    public void setPrompt(String string) {
        Configurer configurer = GameModule.getGameModule().getPrefs().getOption(PREFS_KEY);
        if (configurer != null) {
            configurer.setName(string);
        }
    }

    public void allowAll() {
        this.override = Boolean.TRUE;
    }

    public void allowNone() {
        this.override = Boolean.FALSE;
    }

    public void allow(String string) {
        if (!this.allowed.contains(string)) {
            this.allowed.addElement(string);
        }
    }

    public void disallow(String string) {
        this.allowed.removeElement(string);
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_ID)) {
            string = string.substring(COMMAND_ID.length());
            Vector<String> vector = new Vector<String>();
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            while (decoder.hasMoreTokens()) {
                vector.addElement(decoder.nextToken());
            }
            return new SetAllowed(vector);
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof SetAllowed) {
            Vector vector = ((SetAllowed)command).getAllowedIds();
            if (vector.size() == 0) {
                return COMMAND_ID;
            }
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sequenceEncoder.append((String)enumeration.nextElement());
            }
            return COMMAND_ID + sequenceEncoder.getValue();
        }
        return null;
    }

    public Command getRestoreCommand() {
        return new SetAllowed(this.allowed);
    }

    public void setup(boolean bl) {
        if (!bl) {
            this.allowed.removeAllElements();
        } else if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(PREFS_KEY))) {
            this.allow(GameModule.getUserId());
        }
    }

    public boolean isUnmaskable(String string) {
        if (this.override != null) {
            return this.override;
        }
        return this.allowed.contains(string);
    }

    public static class SetAllowed
    extends Command {
        private Vector allowed = new Vector();

        public SetAllowed(Vector vector) {
            this.allowed = vector;
        }

        public Vector getAllowedIds() {
            return this.allowed;
        }

        protected void executeCommand() {
            ObscurableOptions.getInstance().override = null;
            ObscurableOptions.getInstance().allowed = this.allowed;
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

