/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.UniqueIdManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class PieceWindow
extends Widget
implements UniqueIdManager.Identifyable {
    private String id;
    private LaunchButton launch;
    private boolean hidden;
    public static final String DEPRECATED_NAME = "entryName";
    public static final String NAME = "name";
    public static final String BUTTON_TEXT = "text";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN = "hidden";
    private static UniqueIdManager idMgr = new UniqueIdManager("PieceWindow");
    private JComponent root = new JPanel(new BorderLayout());
    private ComponentSplitter.SplitPane mainWindowDock;
    static /* synthetic */ Class class$VASSAL$build$widget$TabWidget;
    static /* synthetic */ Class class$VASSAL$build$widget$PanelWidget;
    static /* synthetic */ Class class$VASSAL$build$widget$BoxWidget;
    static /* synthetic */ Class class$VASSAL$build$widget$ListWidget;
    static /* synthetic */ Class class$VASSAL$build$widget$PieceSlot;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$PieceWindow$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;

    public PieceWindow() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PieceWindow.this.launchButtonPressed();
            }
        };
        this.launch = new LaunchButton("Pieces", BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.launch.setToolTipText("Show/Hide the Pieces window");
    }

    private Window initFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            final JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame());
            jDialog.getContentPane().add(this.root);
            jDialog.setDefaultCloseOperation(1);
            jDialog.setTitle(this.getConfigureName());
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (PieceWindow.NAME.equals(propertyChangeEvent.getPropertyName())) {
                        jDialog.setTitle((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
            return jDialog;
        }
        final JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(this.root);
        jFrame.setDefaultCloseOperation(1);
        jFrame.setTitle(this.getConfigureName());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PieceWindow.NAME.equals(propertyChangeEvent.getPropertyName())) {
                    jFrame.setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        return jFrame;
    }

    public void launchButtonPressed() {
        if (this.mainWindowDock != null) {
            this.mainWindowDock.toggleVisibility();
        } else {
            this.root.getTopLevelAncestor().setVisible(!this.root.getTopLevelAncestor().isVisible());
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PieceWindow.htm");
    }

    public void build(Element element) {
        super.build(element);
        this.rebuild();
    }

    public boolean shouldDockIntoMainWindow() {
        return "PieceWindow0".equals(this.id);
    }

    public Component getComponent() {
        return this.root;
    }

    public static String getConfigureTypeName() {
        return "Game Piece Palette";
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$widget$TabWidget == null ? (class$VASSAL$build$widget$TabWidget = PieceWindow.class$("VASSAL.build.widget.TabWidget")) : class$VASSAL$build$widget$TabWidget, class$VASSAL$build$widget$PanelWidget == null ? (class$VASSAL$build$widget$PanelWidget = PieceWindow.class$("VASSAL.build.widget.PanelWidget")) : class$VASSAL$build$widget$PanelWidget, class$VASSAL$build$widget$BoxWidget == null ? (class$VASSAL$build$widget$BoxWidget = PieceWindow.class$("VASSAL.build.widget.BoxWidget")) : class$VASSAL$build$widget$BoxWidget, class$VASSAL$build$widget$ListWidget == null ? (class$VASSAL$build$widget$ListWidget = PieceWindow.class$("VASSAL.build.widget.ListWidget")) : class$VASSAL$build$widget$ListWidget, class$VASSAL$build$widget$PieceSlot == null ? (class$VASSAL$build$widget$PieceSlot = PieceWindow.class$("VASSAL.build.widget.PieceSlot")) : class$VASSAL$build$widget$PieceSlot};
    }

    public void add(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.add(((Widget)buildable).getComponent());
        }
        super.add(buildable);
    }

    public void remove(Buildable buildable) {
        if (buildable instanceof Widget) {
            this.root.remove(((Widget)buildable).getComponent());
        }
        super.remove(buildable);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void addTo(Buildable buildable) {
        idMgr.add(this);
        if (!this.hidden) {
            String string = PositionOption.key + this.getConfigureName();
            if ("PieceWindow0".equals(this.id) && GlobalOptions.getInstance().isUseSingleWindow()) {
                this.mainWindowDock = new ComponentSplitter().splitLeft(GameModule.getGameModule().getControlPanel(), this.root, false);
            } else {
                Window window = this.initFrame();
                VisibilityOption visibilityOption = new VisibilityOption(string, window);
                GameModule.getGameModule().getPrefs().addOption(visibilityOption);
            }
            GameModule.getGameModule().getToolBar().add(this.launch);
        }
    }

    public void removeFrom(Buildable buildable) {
        if (this.mainWindowDock == null && this.root != null && this.root.getTopLevelAncestor() != null) {
            this.root.getTopLevelAncestor().setVisible(false);
        }
        GameModule.getGameModule().getToolBar().remove(this.launch);
        idMgr.remove(this);
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Hidden (requires restart)", "Button text", "Button icon", "Hotkey to show/hide"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = PieceWindow.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PieceWindow.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PieceWindow.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$PieceWindow$IconConfig == null ? (class$VASSAL$build$module$PieceWindow$IconConfig = PieceWindow.class$("VASSAL.build.module.PieceWindow$IconConfig")) : class$VASSAL$build$module$PieceWindow$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = PieceWindow.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, HIDDEN, BUTTON_TEXT, ICON, HOTKEY};
    }

    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute(NAME, object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if (NAME.equals(string)) {
            String string2 = (String)object;
            this.setConfigureName(string2);
            this.launch.setToolTipText("Show/Hide the " + string2 + " window");
        } else if (HIDDEN.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.hidden = (Boolean)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (HIDDEN.equals(string)) {
            return String.valueOf(this.hidden);
        }
        return this.launch.getAttributeValueString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/counter.gif");
        }
    }
}

