/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PlayerRoster
implements Configurable,
CommandEncoder,
GameComponent {
    public static final String BUTTON_ICON = "buttonIcon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOL_TIP = "buttonToolTip";
    public static final String COMMAND_PREFIX = "PLAYER\t";
    protected List players = new ArrayList();
    protected List sides = new ArrayList();
    protected LaunchButton retireButton;
    protected List sideChangeListeners = new ArrayList();
    private static String OBSERVER = "<observer>";
    static /* synthetic */ Class class$VASSAL$build$module$PlayerRoster;

    public PlayerRoster() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerRoster.this.launch();
            }
        };
        this.retireButton = new LaunchButton("Retire", TOOL_TIP, BUTTON_TEXT, null, BUTTON_ICON, actionListener);
        this.retireButton.setToolTipText("Allow another player to take your side in this game");
        this.retireButton.setVisible(false);
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this);
    }

    public void remove(Buildable buildable) {
    }

    public void build(Element element) {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                this.retireButton.setAttribute(attr.getName(), attr.getValue());
            }
            NodeList nodeList = element.getElementsByTagName("*");
            this.sides.clear();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.sides.add(Builder.getText(element2));
            }
        }
    }

    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return "Definition of Player Sides";
    }

    public void add(Buildable buildable) {
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String string = this.retireButton.getAttributeValueString(BUTTON_TEXT);
        if (string != null) {
            element.setAttribute(BUTTON_TEXT, string);
        }
        if ((string = this.retireButton.getAttributeValueString(BUTTON_ICON)) != null) {
            element.setAttribute(BUTTON_ICON, string);
        }
        if ((string = this.retireButton.getAttributeValueString(TOOL_TIP)) != null) {
            element.setAttribute(TOOL_TIP, string);
        }
        Iterator iterator = this.sides.iterator();
        while (iterator.hasNext()) {
            Element element2 = document.createElement("entry");
            element2.appendChild(document.createTextNode((String)iterator.next()));
            element.appendChild(element2);
        }
        return element;
    }

    public Configurer getConfigurer() {
        return new Con();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public static void addSideChangeListener(SideChangeListener sideChangeListener) {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            playerRoster.sideChangeListeners.add(sideChangeListener);
        }
    }

    public static void removeSideChangeListener(SideChangeListener sideChangeListener) {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            playerRoster.sideChangeListeners.remove(sideChangeListener);
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "Definition_of_Player_Sides");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getToolBar().add(this.retireButton);
    }

    protected void launch() {
        String string = PlayerRoster.getMySide();
        if (string != null || this.sides.size() != this.players.size()) {
            Object[] objectArray;
            if (this.sides.size() == this.players.size()) {
                Object[] objectArray2 = new String[2];
                objectArray2[0] = "Yes";
                objectArray = objectArray2;
                objectArray2[1] = "No";
            } else {
                String[] stringArray = new String[3];
                stringArray[0] = "Become observer";
                stringArray[1] = "Join another side";
                objectArray = stringArray;
                stringArray[2] = "Cancel";
            }
            Object[] objectArray3 = objectArray;
            int n = objectArray3.length - 1;
            int n2 = JOptionPane.showOptionDialog(GameModule.getGameModule().getFrame(), "Give up your position as '" + string + "'?", "Retire", 0, 3, null, objectArray3, "Become observer");
            if (n2 == 0) {
                String string2 = PlayerRoster.getMySide();
                this.remove(GameModule.getUserId());
                String string3 = PlayerRoster.getMySide();
                this.fireSideChange(string2, string3);
            } else if (n2 != n) {
                String string4 = PlayerRoster.getMySide();
                this.remove(GameModule.getUserId());
                this.promptForSide();
                String string5 = PlayerRoster.getMySide();
                this.fireSideChange(string4, string5);
            }
        }
    }

    protected void fireSideChange(String string, String string2) {
        Iterator iterator = this.sideChangeListeners.iterator();
        while (iterator.hasNext()) {
            SideChangeListener sideChangeListener = (SideChangeListener)iterator.next();
            sideChangeListener.sideChanged(string, string2);
        }
    }

    public static boolean isActive() {
        return PlayerRoster.getInstance() != null;
    }

    protected static PlayerRoster getInstance() {
        PlayerRoster playerRoster = null;
        Enumeration enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$PlayerRoster == null ? (class$VASSAL$build$module$PlayerRoster = PlayerRoster.class$("VASSAL.build.module.PlayerRoster")) : class$VASSAL$build$module$PlayerRoster);
        if (enumeration.hasMoreElements()) {
            playerRoster = (PlayerRoster)enumeration.nextElement();
        }
        return playerRoster;
    }

    public static String getMySide() {
        PlayerRoster playerRoster = PlayerRoster.getInstance();
        if (playerRoster != null) {
            Entry[] entryArray = playerRoster.getPlayers();
            for (int i = 0; i < entryArray.length; ++i) {
                if (!entryArray[i].playerId.equals(GameModule.getUserId())) continue;
                return entryArray[i].side;
            }
        }
        return null;
    }

    public Entry[] getPlayers() {
        Entry[] entryArray = new Entry[this.players.size()];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = (Entry)this.players.get(i);
        }
        return entryArray;
    }

    public void add(String string, String string2, String string3) {
        Entry entry = new Entry(string, string2, string3);
        if (this.players.contains(entry)) {
            this.players.set(this.players.indexOf(entry), entry);
        } else {
            this.players.add(entry);
        }
    }

    public void remove(String string) {
        Entry entry = new Entry(string, null, null);
        this.players.remove(entry);
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            return new Add(this, decoder.nextToken(), decoder.nextToken(), decoder.nextToken());
        }
        return null;
    }

    public String encode(Command command) {
        if (command instanceof Add) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(((Add)command).id);
            sequenceEncoder.append(((Add)command).name);
            sequenceEncoder.append(((Add)command).side);
            return COMMAND_PREFIX + sequenceEncoder.getValue();
        }
        return null;
    }

    public Command getRestoreCommand() {
        Add add = null;
        Iterator iterator = this.players.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            Add add2 = new Add(this, entry.playerId, entry.playerName, entry.side);
            add = add == null ? add2 : add.append(add2);
        }
        return add;
    }

    public void setup(boolean bl) {
        if (bl) {
            Entry entry = new Entry(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
            if (this.players.contains(entry)) {
                Entry entry2 = (Entry)this.players.get(this.players.indexOf(entry));
                entry2.playerName = entry.playerName;
            } else if (this.sides.size() > 0) {
                this.promptForSide();
            }
        } else {
            this.players.clear();
        }
        this.retireButton.setVisible(bl && PlayerRoster.getMySide() != null);
    }

    protected void promptForSide() {
        ArrayList<String> arrayList = new ArrayList<String>(this.sides);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < this.players.size(); ++i) {
            arrayList2.add(((Entry)this.players.get((int)i)).side);
        }
        arrayList.removeAll(arrayList2);
        arrayList.add(0, OBSERVER);
        String string = (String)JOptionPane.showInputDialog(GameModule.getGameModule().getFrame(), "Join game as which side", "Choose side", 3, null, arrayList.toArray(new String[arrayList.size()]), OBSERVER);
        if (string != null && !OBSERVER.equals(string)) {
            Entry entry = new Entry(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), string);
            Add add = new Add(this, entry.playerId, entry.playerName, entry.side);
            add.execute();
            GameModule.getGameModule().getServer().sendToOthers(add);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface SideChangeListener {
        public void sideChanged(String var1, String var2);
    }

    private class Con
    extends Configurer {
        private StringArrayConfigurer sidesConfig;
        private IconConfigurer iconConfig;
        private StringConfigurer textConfig;
        private StringConfigurer tooltipConfig;
        private JPanel controls = new JPanel();

        private Con() {
            super(null, null);
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.sidesConfig = new StringArrayConfigurer(null, "Sides available to players:  ", PlayerRoster.this.sides.toArray(new String[PlayerRoster.this.sides.size()]));
            this.sidesConfig.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = con;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Con.access$400((Con)this.this$1).sides.clear();
                    Con.access$400((Con)this.this$1).sides.addAll(Arrays.asList(Con.access$500(this.this$1).getStringArray()));
                }
            });
            this.controls.add(this.sidesConfig.getControls());
            this.textConfig = new StringConfigurer(PlayerRoster.BUTTON_TEXT, "'Retire' button text", PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.BUTTON_TEXT));
            this.textConfig.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = con;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Con.access$400((Con)this.this$1).retireButton.setAttribute("buttonText", Con.access$600(this.this$1).getValueString());
                }
            });
            this.controls.add(this.textConfig.getControls());
            this.iconConfig = new IconConfigurer(PlayerRoster.BUTTON_ICON, "'Retire' button icon", null);
            this.iconConfig.setValue(PlayerRoster.this.retireButton.getIcon());
            this.iconConfig.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = con;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Con.access$400((Con)this.this$1).retireButton.setAttribute("buttonIcon", Con.access$700(this.this$1).getValueString());
                }
            });
            this.controls.add(this.iconConfig.getControls());
            this.tooltipConfig = new StringConfigurer(PlayerRoster.TOOL_TIP, "'Retire' button tooltip", PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.TOOL_TIP));
            this.tooltipConfig.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ Con this$1;
                {
                    this.this$1 = con;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Con.access$400((Con)this.this$1).retireButton.setAttribute("buttonToolTip", Con.access$800(this.this$1).getValueString());
                }
            });
            this.controls.add(this.tooltipConfig.getControls());
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }

        public Component getControls() {
            return this.controls;
        }

        static /* synthetic */ PlayerRoster access$400(Con con) {
            return con.PlayerRoster.this;
        }

        static /* synthetic */ StringArrayConfigurer access$500(Con con) {
            return con.sidesConfig;
        }

        static /* synthetic */ StringConfigurer access$600(Con con) {
            return con.textConfig;
        }

        static /* synthetic */ IconConfigurer access$700(Con con) {
            return con.iconConfig;
        }

        static /* synthetic */ StringConfigurer access$800(Con con) {
            return con.tooltipConfig;
        }
    }

    public static class Add
    extends Command {
        private PlayerRoster roster;
        private String id;
        private String name;
        private String side;

        public Add(PlayerRoster playerRoster, String string, String string2, String string3) {
            this.roster = playerRoster;
            this.id = string;
            this.name = string2;
            this.side = string3;
        }

        protected void executeCommand() {
            this.roster.add(this.id, this.name, this.side);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class Entry {
        public String playerId;
        public String playerName;
        public String side;

        public Entry(String string, String string2, String string3) {
            this.playerId = string;
            this.playerName = string2;
            this.side = string3;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry && this.playerId != null) {
                return this.playerId.equals(((Entry)object).playerId);
            }
            return false;
        }
    }
}

