/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.VisibilityCondition;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PredefinedSetup
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String FILE = "file";
    public static final String USE_FILE = "useFile";
    public static final String IS_MENU = "isMenu";
    private boolean isMenu;
    private boolean useFile = true;
    private String fileName;
    private JMenuItem menuItem = new JMenuItem();
    private JMenu menu = new JMenu();
    private JMenuItem originalItem;
    private VisibilityCondition showFile;
    private VisibilityCondition showUseFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$VASSAL$build$module$PredefinedSetup;

    public PredefinedSetup() {
        this.menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PredefinedSetup.this.launch();
            }
        });
        this.showFile = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu && PredefinedSetup.this.useFile;
            }
        };
        this.showUseFile = new VisibilityCondition(){

            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu;
            }
        };
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Contains sub-menus", "Use pre-defined file", "Saved Game"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = PredefinedSetup.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PredefinedSetup.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PredefinedSetup.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$io$File == null ? (class$java$io$File = PredefinedSetup.class$("java.io.File")) : class$java$io$File};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, IS_MENU, USE_FILE, FILE};
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        if (USE_FILE.equals(string)) {
            return String.valueOf(this.useFile);
        }
        if (IS_MENU.equals(string)) {
            return String.valueOf(this.isMenu);
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            this.menuItem.setText((String)object);
            this.menu.setText((String)object);
        } else if (USE_FILE.equals(string)) {
            this.useFile = "true".equals(object) || Boolean.TRUE.equals(object);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
        } else if (IS_MENU.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.setMenu((Boolean)object);
        }
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (FILE.equals(string)) {
            return this.showFile;
        }
        if (USE_FILE.equals(string)) {
            return this.showUseFile;
        }
        return super.getAttributeVisibility(string);
    }

    public void launch() {
        if (this.useFile && this.fileName != null) {
            try {
                int n = this.fileName.indexOf(".");
                String string = n > 3 ? this.fileName.substring(0, n) : "VSL";
                String string2 = n >= 0 ? this.fileName.substring(n) : ".sav";
                File file = File.createTempFile(string, string2);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getFileStream(this.fileName));
                int n2 = 0;
                byte[] byArray = new byte[bufferedInputStream.available()];
                while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
                File file2 = new File(file.getParent(), this.fileName);
                if (file.renameTo(file2)) {
                    file = file2;
                }
                GameModule.getGameModule().getGameState().loadGame(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                String string = "Unable to start game";
                if (iOException.getMessage() != null) {
                    string = string + ":  " + iOException.getMessage();
                }
                GameModule.getGameModule().warn(string);
            }
        } else {
            GameModule.getGameModule().getGameState().setup(false);
            GameModule.getGameModule().getGameState().setup(true);
        }
    }

    private JMenuItem getMenuInUse() {
        return this.isMenu ? this.menu : this.menuItem;
    }

    private void setMenu(boolean bl) {
        if (bl != this.isMenu && this.getMenuInUse().getParent() != null) {
            JMenuItem jMenuItem = this.getMenuInUse();
            int n = -1;
            int n2 = jMenuItem.getParent().getComponentCount();
            for (int i = 0; i < n2; ++i) {
                if (jMenuItem.getParent().getComponent(i) != jMenuItem) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                JMenuItem jMenuItem2 = this.isMenu ? this.menuItem : this.menu;
                jMenuItem.getParent().add((Component)jMenuItem2, n);
                jMenuItem.getParent().remove(jMenuItem);
            }
        }
        this.isMenu = bl;
    }

    public void addTo(Buildable buildable) {
        if (buildable instanceof GameModule) {
            JMenu jMenu = GameModule.getGameModule().getFileMenu();
            this.originalItem = (JMenuItem)jMenu.getMenuComponent(0);
            jMenu.insert(this.getMenuInUse(), 0);
            jMenu.remove(this.originalItem);
        } else if (buildable instanceof PredefinedSetup) {
            PredefinedSetup predefinedSetup = (PredefinedSetup)buildable;
            predefinedSetup.menu.add(this.getMenuInUse());
        }
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.isMenu) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = class$VASSAL$build$module$PredefinedSetup == null ? (class$VASSAL$build$module$PredefinedSetup = PredefinedSetup.class$("VASSAL.build.module.PredefinedSetup")) : class$VASSAL$build$module$PredefinedSetup;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public static String getConfigureTypeName() {
        return "Pre-defined setup";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "PredefinedSetup");
    }

    public void removeFrom(Buildable buildable) {
        if (buildable instanceof GameModule) {
            JMenu jMenu = GameModule.getGameModule().getFileMenu();
            jMenu.insert(this.originalItem, 0);
            jMenu.remove(this.getMenuInUse());
        } else if (buildable instanceof PredefinedSetup) {
            PredefinedSetup predefinedSetup = (PredefinedSetup)buildable;
            predefinedSetup.menu.remove(this.getMenuInUse());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

