/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.tools.AdjustableSpeedScrollPane;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

public class PrivateMap
extends Map {
    private String[] owners = new String[0];
    private boolean visibleToAll;
    private Map surrogate;
    public static final String VISIBLE = "visible";
    public static final String SIDE = "side";
    public static final String USE_BOARDS = "useBoards";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$PlayerRoster;

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{SIDE, VISIBLE, USE_BOARDS};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Belongs to side", "Visible to all players", "Use same boards as this map"};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public Class[] getAttributeTypes() {
        Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = PrivateMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrivateMap.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PrivateMap.class$("java.lang.String")) : class$java$lang$String};
        Class[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray, 0, classArray3, 0, classArray.length);
        System.arraycopy(classArray2, 0, classArray3, classArray.length, classArray2.length);
        return classArray3;
    }

    public void setAttribute(String string, Object stringArray) {
        if (VISIBLE.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = new Boolean((String)stringArray);
            }
            this.visibleToAll = (Boolean)stringArray;
        } else if (SIDE.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.owners = stringArray;
        } else if (USE_BOARDS.equals(string)) {
            Iterator iterator = Map.getAllMaps();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (!map.getMapName().equals(stringArray)) continue;
                this.surrogate = map;
                break;
            }
        } else {
            super.setAttribute(string, stringArray);
        }
    }

    public String getAttributeValueString(String string) {
        if (VISIBLE.equals(string)) {
            return "" + this.visibleToAll;
        }
        if (SIDE.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.owners);
        }
        if (USE_BOARDS.equals(string)) {
            return this.surrogate == null ? null : this.surrogate.getMapName();
        }
        return super.getAttributeValueString(string);
    }

    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.scroll = new AdjustableSpeedScrollPane(this.theMap, 22, 32);
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        }
        return this.theMap;
    }

    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog jDialog = new JDialog(GameModule.getGameModule().getFrame()){

                public void setVisible(boolean bl) {
                    super.setVisible(bl && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
                }
            };
            jDialog.setDefaultCloseOperation(0);
            jDialog.setTitle(this.getDefaultWindowTitle());
            return jDialog;
        }
        JFrame jFrame = new JFrame(){

            public void setVisible(boolean bl) {
                super.setVisible(bl && (PrivateMap.this.visibleToAll || PrivateMap.this.isAccessibleTo(PlayerRoster.getMySide())));
            }
        };
        jFrame.setDefaultCloseOperation(0);
        jFrame.setTitle(this.getDefaultWindowTitle());
        return jFrame;
    }

    public void sideChanged(String string, String string2) {
        super.sideChanged(string, string2);
        ((View)this.getView()).disableListeners();
        if (this.isAccessibleTo(string2)) {
            ((View)this.getView()).enableListeners();
        }
        this.launchButton.setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
    }

    public boolean shouldDockIntoMainWindow() {
        return false;
    }

    public boolean isAccessibleTo(String string) {
        for (int i = 0; i < this.owners.length; ++i) {
            if (!this.owners[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleTo(String string) {
        return this.visibleToAll || this.isAccessibleTo(string);
    }

    public void setup(boolean bl) {
        super.setup(bl);
        if (!bl) {
            ((View)this.theMap).disableListeners();
        } else if (this.isAccessibleTo(PlayerRoster.getMySide())) {
            ((View)this.theMap).enableListeners();
        }
        this.launchButton.setEnabled(this.isVisibleTo(PlayerRoster.getMySide()));
    }

    public void setBoards(Enumeration enumeration) {
        if (this.surrogate != null) {
            enumeration = this.surrogate.getAllBoards();
            this.edgeBuffer = this.surrogate.getEdgeBuffer();
        }
        super.setBoards(enumeration);
    }

    public static String getConfigureTypeName() {
        return "Private Window";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PrivateWindow.htm");
    }

    public void build(Element element) {
        this.validator = new ValidityChecker(){

            public void validate(Buildable buildable, ValidationReport validationReport) {
                if (!PlayerRoster.isActive()) {
                    validationReport.addWarning("Must add " + ConfigureTree.getConfigureName(class$VASSAL$build$module$PlayerRoster == null ? (class$VASSAL$build$module$PlayerRoster = PrivateMap.class$("VASSAL.build.module.PlayerRoster")) : class$VASSAL$build$module$PlayerRoster) + " in order to use " + ConfigureTree.getConfigureName(this.getClass()));
                }
            }
        };
        this.surrogate = null;
        super.build(element);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class View
    extends Map.View {
        private Vector keyListeners = new Vector();
        private Vector mouseListeners = new Vector();
        private Vector mouseMotionListeners = new Vector();
        private DropTarget dropTarget;

        public View(PrivateMap privateMap) {
            super(privateMap);
        }

        public synchronized void setDropTarget(DropTarget dropTarget) {
            if (dropTarget != null) {
                this.dropTarget = dropTarget;
            }
        }

        public synchronized void addKeyListener(KeyListener keyListener) {
            this.keyListeners.addElement(keyListener);
        }

        public synchronized void addMouseListener(MouseListener mouseListener) {
            this.mouseListeners.addElement(mouseListener);
        }

        public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
            this.mouseMotionListeners.addElement(mouseMotionListener);
        }

        protected void disableListeners() {
            Enumeration enumeration = this.keyListeners.elements();
            while (enumeration.hasMoreElements()) {
                this.removeKeyListener((KeyListener)enumeration.nextElement());
            }
            enumeration = this.mouseListeners.elements();
            while (enumeration.hasMoreElements()) {
                this.removeMouseListener((MouseListener)enumeration.nextElement());
            }
            enumeration = this.mouseMotionListeners.elements();
            while (enumeration.hasMoreElements()) {
                this.removeMouseMotionListener((MouseMotionListener)enumeration.nextElement());
            }
            super.setDropTarget(null);
        }

        protected void enableListeners() {
            Enumeration enumeration = this.keyListeners.elements();
            while (enumeration.hasMoreElements()) {
                super.addKeyListener((KeyListener)enumeration.nextElement());
            }
            enumeration = this.mouseListeners.elements();
            while (enumeration.hasMoreElements()) {
                super.addMouseListener((MouseListener)enumeration.nextElement());
            }
            enumeration = this.mouseMotionListeners.elements();
            while (enumeration.hasMoreElements()) {
                super.addMouseMotionListener((MouseMotionListener)enumeration.nextElement());
            }
            super.setDropTarget(this.dropTarget);
        }
    }
}

