/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.FormattedString;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrototypeDefinition
implements Configurable,
UniqueIdManager.Identifyable,
ValidityChecker {
    private String name = "Prototype";
    private Map pieces = new HashMap();
    private String pieceDefinition;
    private static UniqueIdManager idMgr = new UniqueIdManager("prototype-");
    private PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public String getConfigureName() {
        return this.name;
    }

    public void setConfigureName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propSupport.firePropertyChange("name", string2, this.name);
    }

    public Configurer getConfigurer() {
        return new Config(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "Definition");
    }

    public void remove(Buildable buildable) {
        idMgr.remove(this);
    }

    public void removeFrom(Buildable buildable) {
    }

    public void add(Buildable buildable) {
    }

    public String getId() {
        return null;
    }

    public void setId(String string) {
    }

    public void validate(Buildable buildable, ValidationReport validationReport) {
        idMgr.validate(this, validationReport);
    }

    public void addTo(Buildable buildable) {
        idMgr.add(this);
    }

    public GamePiece getPiece() {
        return this.getPiece(this.pieceDefinition);
    }

    public GamePiece getPiece(PropertySource propertySource) {
        String string = propertySource == null ? this.pieceDefinition : new FormattedString(this.pieceDefinition).getText(propertySource);
        return this.getPiece(string);
    }

    protected GamePiece getPiece(String string) {
        GamePiece gamePiece = (GamePiece)this.pieces.get(string);
        if (gamePiece == null && string != null) {
            AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(string);
            if (addPiece == null) {
                System.err.println("Couldn't build piece " + string);
                string = null;
            } else {
                gamePiece = addPiece.getTarget();
                gamePiece.setState(addPiece.getState());
            }
        }
        return gamePiece;
    }

    public void setPiece(GamePiece gamePiece) {
        this.pieceDefinition = gamePiece == null ? null : GameModule.getGameModule().encode(new AddPiece(gamePiece));
        this.pieces.clear();
    }

    public void build(Element element) {
        if (element != null) {
            this.setConfigureName(element.getAttribute("name"));
            this.pieceDefinition = Builder.getText(element);
        }
    }

    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        element.setAttribute("name", this.name);
        element.appendChild(document.createTextNode(this.pieceDefinition));
        return element;
    }

    public static String getConfigureTypeName() {
        return "Definition";
    }

    public static class Config
    extends Configurer {
        private Box box = Box.createVerticalBox();
        private PieceDefiner pieceDefiner;
        private StringConfigurer name;
        private PrototypeDefinition def;

        public Config(PrototypeDefinition prototypeDefinition) {
            super(null, null, prototypeDefinition);
            this.name = new StringConfigurer(null, "Name", prototypeDefinition.name);
            this.box.add(this.name.getControls());
            this.pieceDefiner = new Definer();
            this.pieceDefiner.setPiece(prototypeDefinition.getPiece());
            this.box.add(this.pieceDefiner);
            this.def = prototypeDefinition;
        }

        public Object getValue() {
            if (this.def != null) {
                this.def.setPiece(this.pieceDefiner.getPiece());
                this.def.setConfigureName(this.name.getValueString());
            }
            return this.def;
        }

        public Component getControls() {
            return this.box;
        }

        public String getValueString() {
            return null;
        }

        public void setValue(String string) {
        }

        public static class Definer
        extends PieceDefiner {
            public void setPiece(GamePiece gamePiece) {
                if (gamePiece != null) {
                    GamePiece gamePiece2 = Decorator.getInnermost(gamePiece);
                    if (!(gamePiece2 instanceof Plain)) {
                        Plain plain = new Plain();
                        Object object = gamePiece2.getProperty("Outer");
                        if (object instanceof Decorator) {
                            ((Decorator)object).setInner(plain);
                        }
                        gamePiece = Decorator.getOutermost(plain);
                    }
                } else {
                    gamePiece = new Plain();
                }
                super.setPiece(gamePiece);
            }

            protected void removeTrait(int n) {
                if (n > 0) {
                    super.removeTrait(n);
                }
            }

            private static class Plain
            extends BasicPiece {
                public Plain() {
                    super("piece;;;;;");
                }

                public String getDescription() {
                    return "";
                }

                public PieceEditor getEditor() {
                    return null;
                }
            }
        }
    }
}

