/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.SpecialDie;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class SpecialDiceButton
extends AbstractConfigurable
implements CommandEncoder,
UniqueIdManager.Identifyable {
    private static UniqueIdManager idMgr = new UniqueIdManager("SpecialDiceButton");
    public static final String SHOW_RESULTS_COMMAND = "SHOW_RESULTS\t";
    private List dice = new ArrayList();
    protected Random ran;
    protected boolean reportResultAsText = true;
    protected boolean reportResultInWindow = false;
    protected boolean reportResultInButton = false;
    private LaunchButton launch;
    protected String id;
    protected String sMapName;
    private JDialog dialog;
    private JLabel dialogLabel;
    private Color bgColor;
    private ResultsIcon resultsIcon = new ResultsIcon();
    private FormattedString format = new FormattedString();
    private String chatResultFormat = "** $name$ = [$result1$] *** <$playerName$>";
    private String windowTitleResultFormat = "$name$";
    public static final String BUTTON_TEXT = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String RESULT_CHATTER = "resultChatter";
    public static final String CHAT_RESULT_FORMAT = "format";
    public static final String RESULT_N = "result#";
    public static final String RESULT_TOTAL = "numericalTotal";
    public static final String RESULT_WINDOW = "resultWindow";
    public static final String WINDOW_TITLE_RESULT_FORMAT = "windowTitleResultFormat";
    public static final String RESULT_BUTTON = "resultButton";
    public static final String WINDOW_X = "windowX";
    public static final String WINDOW_Y = "windowY";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String DICE_SET = "diceSet";
    public static final String HOTKEY = "hotkey";
    public static final String NONE = "<none>";
    private static final int[] EMPTY = new int[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$SpecialDiceButton$IconConfig;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$VASSAL$build$module$SpecialDie;

    public SpecialDiceButton() {
        this.dialog = new JDialog(GameModule.getGameModule().getFrame());
        this.dialogLabel = new JLabel();
        this.dialogLabel.setIcon(this.resultsIcon);
        this.dialog.getContentPane().add(this.dialogLabel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpecialDiceButton.this.DR();
            }
        };
        this.launch = new LaunchButton(null, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, "Symbols");
        this.setAttribute(BUTTON_TEXT, "Sym");
    }

    public static String getConfigureTypeName() {
        return "Symbolic Dice Button";
    }

    protected String getReportPrefix() {
        return " *** " + this.getConfigureName() + " = ";
    }

    protected String getReportSuffix() {
        return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
    }

    protected void DR() {
        int[] nArray = new int[this.dice.size()];
        int n = 0;
        Object object = this.dice.iterator();
        while (object.hasNext()) {
            nArray[n++] = this.ran.nextInt(((SpecialDie)object.next()).getFaceCount());
        }
        object = this.reportResults(nArray);
        if (this.reportResultAsText) {
            object = ((Command)object).append(this.reportTextResults(nArray));
        }
        GameModule.getGameModule().sendAndLog((Command)object);
    }

    private Command reportResults(int[] nArray) {
        this.resultsIcon.setResults(nArray);
        if (this.reportResultInWindow) {
            ((Component)this.dialog).setVisible(true);
            this.format.setFormat(this.windowTitleResultFormat);
            this.dialog.setTitle(this.format.getText());
            this.dialogLabel.repaint();
        }
        if (this.reportResultInButton) {
            this.launch.repaint();
        }
        return new ShowResults(this, nArray);
    }

    private Command reportTextResults(int[] nArray) {
        Object object;
        this.format.setProperty(NAME, this.getConfigureName());
        int n = 0;
        for (int i = 0; i < this.dice.size(); ++i) {
            object = (SpecialDie)this.dice.get(i);
            this.format.setProperty("result" + (i + 1), ((SpecialDie)object).getTextValue(nArray[i]));
            n += ((SpecialDie)object).getIntValue(nArray[i]);
        }
        this.format.setProperty(RESULT_TOTAL, "" + n);
        this.format.setFormat(this.chatResultFormat);
        String string = this.format.getText();
        string = string.startsWith("*") ? "*" + string : "* " + string;
        object = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
        ((Command)object).execute();
        return object;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{NAME, BUTTON_TEXT, ICON, HOTKEY, RESULT_CHATTER, CHAT_RESULT_FORMAT, RESULT_WINDOW, WINDOW_TITLE_RESULT_FORMAT, RESULT_BUTTON, WINDOW_X, WINDOW_Y, BACKGROUND_COLOR};
        return stringArray;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name", "Button text", "Button icon", "Hotkey", "Report results as text", "Report format", "Show result in window", "Window title format", "Show result in button", "Width", "Heidght", "Background color"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = SpecialDiceButton.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SpecialDiceButton.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$SpecialDiceButton$IconConfig == null ? (class$VASSAL$build$module$SpecialDiceButton$IconConfig = SpecialDiceButton.class$("VASSAL.build.module.SpecialDiceButton$IconConfig")) : class$VASSAL$build$module$SpecialDiceButton$IconConfig, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = SpecialDiceButton.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SpecialDiceButton.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig == null ? (class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig = SpecialDiceButton.class$("VASSAL.build.module.SpecialDiceButton$ReportFormatConfig")) : class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SpecialDiceButton.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig == null ? (class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig = SpecialDiceButton.class$("VASSAL.build.module.SpecialDiceButton$ReportFormatConfig")) : class$VASSAL$build$module$SpecialDiceButton$ReportFormatConfig, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SpecialDiceButton.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = SpecialDiceButton.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = SpecialDiceButton.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Color == null ? (class$java$awt$Color = SpecialDiceButton.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (WINDOW_X.equals(string) || WINDOW_Y.equals(string) || BACKGROUND_COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultInWindow || SpecialDiceButton.this.reportResultInButton;
                }
            };
        }
        if (CHAT_RESULT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultAsText;
                }
            };
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultInWindow;
                }
            };
        }
        return null;
    }

    public void addSpecialDie(SpecialDie specialDie) {
        this.dice.add(specialDie);
    }

    public void removeSpecialDie(SpecialDie specialDie) {
        this.dice.remove(specialDie);
    }

    public void addTo(Buildable buildable) {
        this.resultsIcon.setResults(new int[this.dice.size()]);
        this.launch.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (SpecialDiceButton.this.launch.isShowing()) {
                    SpecialDiceButton.this.dialog.setLocationRelativeTo(SpecialDiceButton.this.launch);
                    SpecialDiceButton.this.launch.removeHierarchyListener(this);
                }
            }
        });
        GameModule gameModule = GameModule.getGameModule();
        this.ran = gameModule.getRNG();
        gameModule.getToolBar().add(this.launch);
        idMgr.add(this);
        gameModule.addCommandEncoder(this);
    }

    public void removeFrom(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.removeCommandEncoder(this);
        gameModule.getToolBar().remove(this.launch);
        gameModule.getToolBar().revalidate();
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    private boolean getBoolVal(Object object) {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            return bl;
        }
        if (object instanceof String) {
            return "true".equals(object);
        }
        return false;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            this.launch.setToolTipText((String)object);
        } else if (RESULT_CHATTER.equals(string)) {
            this.reportResultAsText = this.getBoolVal(object);
        } else if (CHAT_RESULT_FORMAT.equals(string)) {
            this.chatResultFormat = (String)object;
        } else if (RESULT_BUTTON.equals(string)) {
            this.reportResultInButton = this.getBoolVal(object);
            if (this.reportResultInButton) {
                this.launch.setIcon(this.resultsIcon);
            }
        } else if (RESULT_WINDOW.equals(string)) {
            this.reportResultInWindow = this.getBoolVal(object);
        } else if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            this.windowTitleResultFormat = (String)object;
        } else if (WINDOW_X.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.resultsIcon.width = (Integer)object;
            this.dialog.pack();
        } else if (WINDOW_Y.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.resultsIcon.height = (Integer)object;
            this.dialog.pack();
        } else if (BACKGROUND_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.bgColor = (Color)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (RESULT_CHATTER.equals(string)) {
            return "" + this.reportResultAsText;
        }
        if (CHAT_RESULT_FORMAT.equals(string)) {
            return this.chatResultFormat;
        }
        if (RESULT_BUTTON.equals(string)) {
            return "" + this.reportResultInButton;
        }
        if (RESULT_WINDOW.equals(string)) {
            return "" + this.reportResultInWindow;
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            return this.windowTitleResultFormat;
        }
        if (WINDOW_X.equals(string)) {
            return "" + this.resultsIcon.width;
        }
        if (WINDOW_Y.equals(string)) {
            return "" + this.resultsIcon.height;
        }
        if (BACKGROUND_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        return this.launch.getAttributeValueString(string);
    }

    public Class[] getAllowableConfigureComponents() {
        Class[] classArray = new Class[]{class$VASSAL$build$module$SpecialDie == null ? (class$VASSAL$build$module$SpecialDie = SpecialDiceButton.class$("VASSAL.build.module.SpecialDie")) : class$VASSAL$build$module$SpecialDie};
        return classArray;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SpecialDiceButton.htm");
    }

    public static String intArrayToString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "";
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < nArray.length; ++i) {
            sequenceEncoder.append(String.valueOf(nArray[i]));
        }
        return sequenceEncoder.getValue();
    }

    public static int[] stringToIntArray(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        Vector<String> vector = new Vector<String>();
        while (decoder.hasMoreTokens()) {
            vector.addElement(decoder.nextToken());
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt((String)vector.elementAt(i));
        }
        return nArray;
    }

    public String encode(Command command) {
        if (command instanceof ShowResults) {
            ShowResults showResults = (ShowResults)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(showResults.target.getIdentifier(), '\t');
            for (int i = 0; i < showResults.rolls.length; ++i) {
                sequenceEncoder.append(showResults.rolls[i] + "");
            }
            return SHOW_RESULTS_COMMAND + sequenceEncoder.getValue();
        }
        return null;
    }

    public Command decode(String string) {
        SequenceEncoder.Decoder decoder = null;
        if (string.startsWith(SHOW_RESULTS_COMMAND + this.getConfigureName()) || string.startsWith(SHOW_RESULTS_COMMAND + this.getId())) {
            decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            decoder.nextToken();
        } else if (string.startsWith(this.getId() + '\t')) {
            decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
        }
        if (decoder != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (decoder.hasMoreTokens()) {
                arrayList.add(decoder.nextToken());
            }
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nArray[n++] = Integer.parseInt((String)iterator.next());
            }
            return new ShowResults(this, nArray);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResultsIcon
    implements Icon {
        private int width;
        private int height;
        private Icon[] icons;

        private void setResults(int[] nArray) {
            this.icons = new Icon[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                String string = ((SpecialDie)SpecialDiceButton.this.dice.get(i)).getImageName(nArray[i]);
                try {
                    Image image = GameModule.getGameModule().getDataArchive().getCachedImage(string);
                    this.icons[i] = new ImageIcon(image);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Unable to locate image " + string);
                }
            }
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (SpecialDiceButton.this.bgColor != null) {
                graphics.setColor(SpecialDiceButton.this.bgColor);
                graphics.fillRect(n, n2, this.width, this.height);
            }
            int n3 = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                if (this.icons[i] == null) continue;
                this.icons[i].paintIcon(component, graphics, n + n3, n2);
                n3 += this.icons[i].getIconWidth();
            }
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    public static class ShowResults
    extends Command {
        private SpecialDiceButton target;
        private int[] rolls;

        public ShowResults(SpecialDiceButton specialDiceButton, int[] nArray) {
            this.target = specialDiceButton;
            this.rolls = new int[nArray.length];
            System.arraycopy(nArray, 0, this.rolls, 0, nArray.length);
        }

        protected void executeCommand() {
            this.target.reportResults(this.rolls);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class ReportFormatConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{SpecialDiceButton.NAME, SpecialDiceButton.RESULT_N, SpecialDiceButton.RESULT_TOTAL});
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/die.gif");
        }
    }
}

