/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ToolbarMenu
extends AbstractConfigurable
implements ContainerListener,
PropertyChangeListener,
GameComponent {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String BUTTON_HOTKEY = "hotkey";
    public static final String MENU_ITEMS = "menuItems";
    public static final String MENU_PROPERTY = "ToolbarMenu.popup";
    protected List menuItems = new ArrayList();
    protected Map buttonsToMenuMap = new HashMap();
    protected LaunchButton launch = new LaunchButton("Menu", "text", "hotkey", "icon", new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarMenu.this.launch();
        }
    });
    protected JToolBar toolbar;
    protected JPopupMenu menu = new JPopupMenu();
    protected Runnable menuBuilder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$KeyStroke;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ToolbarMenu() {
        this.launch.putClientProperty(MENU_PROPERTY, this.menu);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public void launch() {
        this.menu.show(this.launch, 0, 0);
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Button text", "Button Icon", "Hotkey", "Menu Entries"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ToolbarMenu.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$Icon == null ? (class$javax$swing$Icon = ToolbarMenu.class$("javax.swing.Icon")) : class$javax$swing$Icon, class$javax$swing$KeyStroke == null ? (class$javax$swing$KeyStroke = ToolbarMenu.class$("javax.swing.KeyStroke")) : class$javax$swing$KeyStroke, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ToolbarMenu.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    }

    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, BUTTON_ICON, BUTTON_HOTKEY, MENU_ITEMS};
    }

    public String getAttributeValueString(String string) {
        if (MENU_ITEMS.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.menuItems.toArray(new String[this.menuItems.size()]));
        }
        return this.launch.getAttributeValueString(string);
    }

    public void setAttribute(String string, Object stringArray) {
        if (MENU_ITEMS.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.menuItems = Arrays.asList((String[])stringArray);
            if (this.toolbar != null) {
                this.scheduleBuildMenu();
            }
        } else if (BUTTON_TEXT.equals(string)) {
            this.setConfigureName((String)stringArray);
            this.launch.setAttribute(string, stringArray);
        } else {
            this.launch.setAttribute(string, stringArray);
        }
    }

    public void addTo(Buildable buildable) {
        if (buildable instanceof ToolBarComponent) {
            this.toolbar = ((ToolBarComponent)((Object)buildable)).getToolBar();
        }
        this.toolbar.add(this.launch);
        this.toolbar.addContainerListener(this);
        this.scheduleBuildMenu();
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ToolbarMenu.htm");
    }

    public static String getConfigureTypeName() {
        return "Toolbar Menu";
    }

    public void removeFrom(Buildable buildable) {
        this.toolbar.remove(this.launch);
        this.toolbar.removeContainerListener(this);
    }

    protected void buildMenu() {
        JButton jButton;
        Object object = this.buttonsToMenuMap.keySet().iterator();
        while (object.hasNext()) {
            AbstractButton abstractButton = (AbstractButton)object.next();
            abstractButton.setVisible(true);
            abstractButton.removePropertyChangeListener(this);
        }
        this.buttonsToMenuMap.clear();
        this.menu.removeAll();
        object = new HashMap();
        if (this.toolbar != null) {
            int n = this.toolbar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this.toolbar.getComponentAtIndex(i) instanceof JButton)) continue;
                jButton = (JButton)this.toolbar.getComponentAtIndex(i);
                object.put(jButton.getText(), jButton);
            }
        }
        Iterator iterator = this.menuItems.iterator();
        while (iterator.hasNext()) {
            JComponent jComponent;
            String string = (String)iterator.next();
            jButton = (JButton)object.get(string);
            if (jButton == null) continue;
            Object object2 = jButton.getClientProperty(MENU_PROPERTY);
            jButton.addPropertyChangeListener(this);
            jButton.setVisible(false);
            if (object2 instanceof JPopupMenu) {
                jComponent = (JPopupMenu)object2;
                jComponent.addContainerListener(this);
                JMenu jMenu = new JMenu(jButton.getText());
                Component[] componentArray = jComponent.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    final JMenuItem jMenuItem = (JMenuItem)componentArray[i];
                    JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getText(), jMenuItem.getIcon());
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jMenuItem.doClick();
                        }
                    });
                    jMenu.add(jMenuItem2);
                    this.buttonsToMenuMap.put(jMenuItem, jMenuItem2);
                }
                this.buttonsToMenuMap.put(jButton, jMenu);
                this.menu.add(jMenu);
                continue;
            }
            jComponent = new JMenuItem(jButton.getText(), jButton.getIcon());
            ((JMenuItem)jComponent).setEnabled(jButton.isEnabled());
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jButton.doClick();
                }
            });
            this.buttonsToMenuMap.put(jButton, jComponent);
            this.menu.add((JMenuItem)jComponent);
        }
    }

    protected void scheduleBuildMenu() {
        if (this.menuBuilder == null) {
            this.menuBuilder = new Runnable(){

                public void run() {
                    ToolbarMenu.this.buildMenu();
                    ToolbarMenu.this.menuBuilder = null;
                }
            };
            SwingUtilities.invokeLater(this.menuBuilder);
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.scheduleBuildMenu();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.scheduleBuildMenu();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JButton jButton = (JButton)propertyChangeEvent.getSource();
        JMenuItem jMenuItem = (JMenuItem)this.buttonsToMenuMap.get(jButton);
        if (jMenuItem != null) {
            if (BUTTON_TEXT.equals(propertyChangeEvent.getPropertyName())) {
                this.scheduleBuildMenu();
            } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                jMenuItem.setEnabled(jButton.isEnabled());
            } else if (BUTTON_ICON.equals(propertyChangeEvent.getPropertyName())) {
                jMenuItem.setIcon(jButton.getIcon());
            }
        }
    }

    public void setup(boolean bl) {
        this.scheduleBuildMenu();
    }

    public Command getRestoreCommand() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

