/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.tools.DataArchive;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JWindow;

public class AboutScreen
extends AbstractConfigurable {
    private Image image;
    private String title;
    private String fileName;
    private JMenuItem launch = new JMenuItem();
    private Window window;
    public static final String TITLE = "title";
    public static final String FILE = "fileName";
    static /* synthetic */ Class class$VASSAL$build$module$ModuleExtension;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;

    public AboutScreen() {
        this.launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutScreen.this.launch();
            }
        });
    }

    public AboutScreen(Image image) {
        this();
        this.image = image;
    }

    public void launch() {
        if (this.image == null) {
            return;
        }
        if (this.window == null) {
            this.initComponents();
        }
        ((Component)this.window).setVisible(true);
        this.window.toFront();
    }

    protected void initComponents() {
        Object object;
        if (this.image == null) {
            return;
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        JWindow jWindow = new JWindow(GameModule.getGameModule() != null ? GameModule.getGameModule().getFrame() : null);
        jWindow.getContentPane().setBackground(Color.black);
        jWindow.getContentPane().setLayout(new BoxLayout(jWindow.getContentPane(), 1));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setAlignmentX(0.5f);
        jWindow.getContentPane().add(jLabel);
        jWindow.getContentPane().add(this.createLabel(GameModule.getGameModule().getGameName() + " module version " + GameModule.getGameModule().getGameVersion()));
        Enumeration enumeration = GameModule.getGameModule().getComponents(class$VASSAL$build$module$ModuleExtension == null ? (class$VASSAL$build$module$ModuleExtension = AboutScreen.class$("VASSAL.build.module.ModuleExtension")) : class$VASSAL$build$module$ModuleExtension);
        while (enumeration.hasMoreElements()) {
            object = (ModuleExtension)enumeration.nextElement();
            jWindow.getContentPane().add(this.createLabel("Extension " + ((ModuleExtension)object).getName() + " version " + ((ModuleExtension)object).getVersion()));
        }
        jWindow.getContentPane().add(this.createLabel("VASSAL engine version " + Info.getVersion()));
        jWindow.pack();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jWindow).setLocation(((Dimension)object).width / 2 - jWindow.getSize().width / 2, ((Dimension)object).height / 2 - jWindow.getSize().height / 2);
        this.window = jWindow;
        this.window.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ((Component)AboutScreen.this.window).setVisible(false);
            }
        });
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(Color.blue);
        jLabel.setForeground(Color.white);
        jLabel.setHorizontalAlignment(0);
        jLabel.setAlignmentX(0.5f);
        return jLabel;
    }

    public static String getConfigureTypeName() {
        return "About Screen";
    }

    public String[] getAttributeNames() {
        return new String[]{TITLE, FILE};
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Entry", "Image"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = AboutScreen.class$("java.lang.String")) : class$java$lang$String, class$java$awt$Image == null ? (class$java$awt$Image = AboutScreen.class$("java.awt.Image")) : class$java$awt$Image};
    }

    public String getAttributeValueString(String string) {
        if (TITLE.equals(string)) {
            return this.title;
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (TITLE.equals(string)) {
            this.title = (String)object;
            this.setConfigureName(this.title);
            this.launch.setText(this.title);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
            this.image = this.getImage();
            this.window = null;
        }
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void removeFrom(Buildable buildable) {
        ((Documentation)buildable).getHelpMenu().remove(this.launch);
    }

    public void addTo(Buildable buildable) {
        Documentation documentation = (Documentation)buildable;
        documentation.getHelpMenu().add(this.launch);
        if (this.image == null && this.fileName != null) {
            throw new IllegalBuildException("File " + this.fileName + " not found in " + GameModule.getGameModule().getDataArchive().getName());
        }
    }

    private Image getImage() throws IllegalBuildException {
        Image image = null;
        if (this.fileName != null && this.fileName.length() > 0) {
            try {
                if (this.fileName.charAt(0) != '/') {
                    return GameModule.getGameModule().getDataArchive().getCachedImage(this.fileName);
                }
                image = DataArchive.getImage(this.getClass().getResourceAsStream(this.fileName));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return image;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "AboutScreen");
    }

    public static void main(String[] stringArray) {
        Image image = Toolkit.getDefaultToolkit().getImage("/Command Bunker/VASSAL!/latest source/images/Splash.gif");
        System.err.println("" + image);
        AboutScreen aboutScreen = new AboutScreen(image);
        aboutScreen.launch();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

