/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JMenuItem;

public class HelpFile
extends AbstractConfigurable {
    public static final String TITLE = "title";
    public static final String FILE = "fileName";
    public static final String TYPE = "fileType";
    private static final String IMAGE = "image";
    public static final String ARCHIVE_ENTRY = "archive";
    public static final String RESOURCE = "resource";
    public static final String LOCAL_FILE = "file";
    private HelpWindow frame;
    private URL contents;
    private String title;
    private String fileName;
    private JMenuItem launch = new JMenuItem();
    private String fileType = "archive";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$awt$Image;

    public static String getConfigureTypeName() {
        return "Help File";
    }

    public HelpFile() {
        this.setConfigureName("help");
        this.setMenuItem();
        this.launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpFile.this.showWindow();
            }
        });
    }

    public HelpFile(String string, File file, String string2) throws MalformedURLException {
        this();
        this.title = string;
        this.contents = new URL(HelpFile.toURL(file), string2);
        this.setConfigureName(string);
        this.setMenuItem();
    }

    public HelpFile(String string, File file) throws MalformedURLException {
        this();
        this.title = string;
        this.contents = HelpFile.toURL(file);
        this.setConfigureName(string);
        this.setMenuItem();
    }

    public HelpFile(String string, URL uRL) {
        this();
        this.title = string;
        this.contents = uRL;
        this.setConfigureName(string);
        this.setMenuItem();
    }

    public void showWindow() {
        HelpWindow helpWindow = this.getHelpWindow();
        ((Component)helpWindow).setVisible(true);
        helpWindow.toFront();
    }

    protected HelpWindow getHelpWindow() {
        if (this.frame == null) {
            this.frame = new HelpWindow(this.title, this.getContents());
        }
        return this.frame;
    }

    public URL getContents() {
        if (this.contents == null && this.fileName != null) {
            if (ARCHIVE_ENTRY.equals(this.fileType)) {
                try {
                    this.contents = GameModule.getGameModule().getDataArchive().getURL(this.fileName);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (RESOURCE.equals(this.fileType)) {
                this.contents = this.getClass().getResource(this.fileName);
            } else if (LOCAL_FILE.equals(this.fileType)) {
                File file = new File(this.fileName);
                if (this.fileName.startsWith("docs/")) {
                    file = new File(Documentation.getDocumentationBaseDir(), this.fileName.substring("docs/".length()));
                }
                try {
                    this.contents = HelpFile.toURL(file);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }
        return this.contents;
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL(LOCAL_FILE, "", string);
    }

    public HelpFile getHelpFile() {
        File file = Documentation.getDocumentationBaseDir();
        file = new File(file, "ReferenceManual");
        try {
            return new HelpFile(null, new File(file, "HelpMenu.htm"), "#HelpFile");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void setMenuItem() {
        this.launch.setText(this.getConfigureName());
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{TITLE, FILE, IMAGE, TYPE};
        return stringArray;
    }

    public String getAttributeValueString(String string) {
        if (TITLE.equals(string)) {
            return this.title;
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        if (TYPE.equals(string)) {
            return this.fileType;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (TITLE.equals(string)) {
            this.title = (String)object;
            this.setConfigureName(this.title);
            this.launch.setText(this.title);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
                this.fileType = ARCHIVE_ENTRY;
            }
            this.fileName = (String)object;
            if ("Intro.txt".equals(string)) {
                this.fileType = RESOURCE;
            }
        } else if (TYPE.equals(string)) {
            this.fileType = (String)object;
        }
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Entry", "Text/HTML File", "Add Image"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = HelpFile.class$("java.lang.String")) : class$java$lang$String, class$java$io$File == null ? (class$java$io$File = HelpFile.class$("java.io.File")) : class$java$io$File, class$java$awt$Image == null ? (class$java$awt$Image = HelpFile.class$("java.awt.Image")) : class$java$awt$Image};
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void removeFrom(Buildable buildable) {
        ((Documentation)buildable).getHelpMenu().remove(this.launch);
        this.launch.setEnabled(false);
    }

    public void addTo(Buildable buildable) {
        ((Documentation)buildable).getHelpMenu().add(this.launch);
    }

    public static HelpFile getReferenceManualPage(String string) {
        return HelpFile.getReferenceManualPage(string, null);
    }

    public static HelpFile getReferenceManualPage(String string, String string2) {
        if (string2 != null && !string2.startsWith("#")) {
            string2 = "#" + string2;
        }
        File file = Documentation.getDocumentationBaseDir();
        file = new File(file, "ReferenceManual");
        try {
            return string2 == null ? new HelpFile(null, new File(file, string)) : new HelpFile(null, new File(file, string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

