/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.widget.HtmlChart;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JFrame
implements HyperlinkListener {
    private JEditorPane pane;

    public HelpWindow(String string, URL uRL) {
        super(string);
        this.setDefaultCloseOperation(1);
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        this.pane.setContentType("text/html");
        HtmlChart.XTMLEditorKit xTMLEditorKit = new HtmlChart.XTMLEditorKit(new HtmlChart());
        this.pane.setEditorKit(xTMLEditorKit);
        ScrollPane scrollPane = new ScrollPane(this.pane);
        this.getContentPane().add(scrollPane);
        this.update(uRL);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.max(dimension.width / 2, this.getSize().width);
        int n2 = Math.max(dimension.height / 2, this.getSize().height);
        n = Math.min(n, dimension.width * 2 / 3);
        n2 = Math.min(n2, dimension.height * 2 / 3);
        ((Component)this).setSize(n, n2);
        ((Component)this).setLocation(dimension.width / 2 - n / 2, 0);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType()) && hyperlinkEvent.getURL() != null) {
            this.update(hyperlinkEvent.getURL());
        }
    }

    public void update(URL uRL) {
        if (uRL != null) {
            try {
                this.pane.setPage(uRL);
            }
            catch (IOException iOException) {
                this.pane.setText("Unable to read " + uRL);
            }
        } else {
            this.pane.setText("");
        }
    }
}

