/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.VisibilityCondition;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Tutorial
extends AbstractConfigurable {
    public static final String FILE_NAME = "logfile";
    public static final String NAME = "name";
    public static final String LAUNCH_ON_STARTUP = "launchOnStartup";
    public static final String PROMPT_MESSAGE = "promptMessage";
    public static final String WELCOME_MESSAGE = "welcomeMessage";
    private String fileName;
    private Action launch = new AbstractAction("Tutorial"){

        public void actionPerformed(ActionEvent actionEvent) {
            Tutorial.this.launch();
        }
    };
    private JMenuItem item;
    private boolean launchOnFirstStartup;
    private String welcomeMessage = "Hit the \"Step forward\" button in the toolbar to step through the tutorial";
    private String promptMessage = "Load the tutorial?";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Boolean;

    private void launch() {
        try {
            int n = this.fileName.indexOf(".");
            String string = n > 3 ? this.fileName.substring(0, n) : "VSL";
            String string2 = n >= 0 ? this.fileName.substring(n) : ".log";
            File file = File.createTempFile(string, string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getFileStream(this.fileName));
            int n2 = 0;
            byte[] byArray = new byte[bufferedInputStream.available()];
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            File file2 = new File(file.getParent(), (String)this.launch.getValue("Name"));
            if (file.renameTo(file2)) {
                file = file2;
            }
            if (this.welcomeMessage != null && this.welcomeMessage.length() > 0) {
                GameModule.getGameModule().warn(this.welcomeMessage);
            }
            GameModule.getGameModule().getGameState().loadGame(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = "Unable to launch tutorial " + this.name;
            if (iOException.getMessage() != null) {
                string = string + ":  " + iOException.getMessage();
            }
            GameModule.getGameModule().warn(string);
        }
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Text", "Logfile", "Launch automatically on first startup", "Auto-launch confirm message", "Welcome message"};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = Tutorial.class$("java.lang.String")) : class$java$lang$String, class$java$io$File == null ? (class$java$io$File = Tutorial.class$("java.io.File")) : class$java$io$File, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Tutorial.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = Tutorial.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Tutorial.class$("java.lang.String")) : class$java$lang$String};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, FILE_NAME, LAUNCH_ON_STARTUP, PROMPT_MESSAGE, WELCOME_MESSAGE};
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (string.equals(PROMPT_MESSAGE)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Tutorial.this.launchOnFirstStartup;
                }
            };
        }
        return null;
    }

    public String getAttributeValueString(String string) {
        if (FILE_NAME.equals(string)) {
            return this.fileName;
        }
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (LAUNCH_ON_STARTUP.equals(string)) {
            return "" + this.launchOnFirstStartup;
        }
        if (PROMPT_MESSAGE.equals(string)) {
            return this.promptMessage;
        }
        if (WELCOME_MESSAGE.equals(string)) {
            return this.welcomeMessage;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (FILE_NAME.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
        } else if (NAME.equals(string)) {
            this.launch.putValue("Name", object);
            this.setConfigureName((String)object);
        } else if (LAUNCH_ON_STARTUP.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.launchOnFirstStartup = (Boolean)object;
        } else if (PROMPT_MESSAGE.equals(string)) {
            this.promptMessage = (String)object;
        } else if (WELCOME_MESSAGE.equals(string)) {
            this.welcomeMessage = (String)object;
        }
    }

    public void addTo(Buildable buildable) {
        this.item = ((Documentation)buildable).getHelpMenu().add(this.launch);
        final String string = "viewedTutorial" + this.getConfigureName();
        GameModule.getGameModule().getPrefs().addOption(null, new BooleanConfigurer(string, null, Boolean.FALSE));
        if (this.launchOnFirstStartup && !Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(string))) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Object[] objectArray = new String[]{"Yes", "No", "Don't ask me again"};
                    switch (JOptionPane.showOptionDialog(GameModule.getGameModule().getFrame(), Tutorial.this.promptMessage, Tutorial.this.getConfigureName(), 0, 3, null, objectArray, objectArray[0])) {
                        case 0: {
                            Tutorial.this.launch();
                        }
                        case 2: {
                            GameModule.getGameModule().getPrefs().setValue(string, Boolean.TRUE);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "Tutorial");
    }

    public void removeFrom(Buildable buildable) {
        if (this.item != null) {
            ((Documentation)buildable).getHelpMenu().remove(this.item);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

