/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class ColorManager
extends AbstractConfigurable {
    protected static ColorManager instance;
    public static final Color DEFAULT_COLOR;
    public static final String SELECT_COLOR = "Select...";
    protected static Color[] standardColors;
    protected static String[] standardColorNames;
    protected HashMap userColors = new HashMap();
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$ColorSwatch;

    public static ColorManager getColorManager() {
        return instance;
    }

    protected static String getStandardColorName(Color color) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColors[i].equals(color)) continue;
            return standardColorNames[i];
        }
        return null;
    }

    protected static Color getStandardColor(String string) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColorNames[i].equals(string)) continue;
            return standardColors[i];
        }
        return null;
    }

    public ColorManager() {
        instance = this;
    }

    public ColorSwatch getColorSwatch(String string) {
        ColorSwatch colorSwatch = (ColorSwatch)this.userColors.get(string);
        if (colorSwatch == null) {
            colorSwatch = new ColorSwatch(string, ColorManager.getStandardColor(string));
        }
        return colorSwatch;
    }

    public ColorSwatch getColorSwatch(Color color) {
        ColorSwatch colorSwatch = null;
        if (color == null) {
            return new ColorSwatch("CLEAR", null);
        }
        Iterator iterator = this.userColors.values().iterator();
        while (iterator.hasNext() && colorSwatch == null) {
            ColorSwatch colorSwatch2 = (ColorSwatch)iterator.next();
            if (!colorSwatch2.getColor().equals(color)) continue;
            colorSwatch = colorSwatch2;
        }
        if (colorSwatch == null) {
            for (int i = 0; i < standardColors.length && colorSwatch == null; ++i) {
                if (standardColors[i] == null || !standardColors[i].equals(color)) continue;
                colorSwatch = new ColorSwatch(standardColorNames[i], standardColors[i]);
            }
        }
        if (colorSwatch == null) {
            colorSwatch = new ColorSwatch(SELECT_COLOR, color);
        }
        return colorSwatch;
    }

    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    public Class[] getAttributeTypes() {
        return new Class[0];
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public void setAttribute(String string, Object object) {
    }

    public Configurer getConfigurer() {
        return null;
    }

    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$gamepieceimage$ColorSwatch == null ? (class$VASSAL$build$module$gamepieceimage$ColorSwatch = ColorManager.class$("VASSAL.build.module.gamepieceimage.ColorSwatch")) : class$VASSAL$build$module$gamepieceimage$ColorSwatch};
    }

    public static String getConfigureTypeName() {
        return "Named Colors";
    }

    public void add(Buildable buildable) {
        super.add(buildable);
        if (buildable instanceof ColorSwatch) {
            ColorSwatch colorSwatch = (ColorSwatch)buildable;
            this.userColors.put(colorSwatch.getConfigureName(), colorSwatch);
            colorSwatch.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        ColorManager.this.userColors.remove(propertyChangeEvent.getOldValue());
                        ColorManager.this.userColors.put(propertyChangeEvent.getNewValue(), propertyChangeEvent.getSource());
                    }
                }
            });
        }
    }

    public void remove(Buildable buildable) {
        super.remove(buildable);
        if (buildable instanceof ColorSwatch) {
            this.userColors.remove(((ColorSwatch)buildable).getConfigureName());
        }
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.htm", "NamedColors");
    }

    public void removeFrom(Buildable buildable) {
    }

    public Color getColorByName(String string) {
        ColorSwatch colorSwatch = this.getColorSwatch(string);
        if (colorSwatch != null) {
            Color color = colorSwatch.getColor();
            return color;
        }
        return DEFAULT_COLOR;
    }

    public String[] getColorNames() {
        String[] stringArray = new String[this.userColors.size() + standardColors.length];
        ArrayList<ColorSwatch> arrayList = new ArrayList<ColorSwatch>();
        Iterator<Object> iterator = this.userColors.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add((ColorSwatch)iterator.next());
        }
        Collections.sort(arrayList);
        iterator = ((AbstractList)arrayList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = ((ColorSwatch)iterator.next()).getConfigureName();
        }
        for (int i = 0; i < standardColorNames.length; ++i) {
            stringArray[n++] = standardColorNames[i];
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_COLOR = Color.WHITE;
        standardColors = new Color[]{Color.WHITE, Color.GRAY, Color.BLACK, null, Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.PINK, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.LIGHT_GRAY, Color.DARK_GRAY};
        standardColorNames = new String[]{"WHITE", "GRAY", "BLACK", "CLEAR", "RED", "GREEN", "BLUE", "ORANGE", "PINK", "CYAN", "MAGENTA", "YELLOW", "LIGHT GRAY", "DARK GRAY"};
    }
}

