/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.configure.ColorConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;

public class ColorSwatch
extends AbstractConfigurable
implements Comparable {
    protected static final String NAME = "name";
    protected static final String COLOR = "color";
    public static final String BLACK = "BLACK";
    public static final String WHITE = "WHITE";
    public static final String CLEAR = "CLEAR";
    public static final String RED = "RED";
    protected Color color;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;

    public ColorSwatch() {
        this.name = "";
        this.color = null;
    }

    public ColorSwatch(String string, Color color) {
        this();
        this.name = string;
        this.color = color;
    }

    public ColorSwatch(String string) {
        this();
        this.decode(string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Color Name:  ", "Color:  "};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = ColorSwatch.class$("java.lang.String")) : class$java$lang$String, class$java$awt$Color == null ? (class$java$awt$Color = ColorSwatch.class$("java.awt.Color")) : class$java$awt$Color};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, COLOR};
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        }
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        return null;
    }

    public void removeFrom(Buildable buildable) {
    }

    public HelpFile getHelpFile() {
        return null;
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return "Named Color";
    }

    public void addTo(Buildable buildable) {
    }

    public static ColorSwatch getBlack() {
        return new ColorSwatch(BLACK, Color.BLACK);
    }

    public static ColorSwatch getWhite() {
        return new ColorSwatch(WHITE, Color.WHITE);
    }

    public static ColorSwatch getRed() {
        return new ColorSwatch(RED, Color.RED);
    }

    public static ColorSwatch getClear() {
        return new ColorSwatch(CLEAR, null);
    }

    public String encode() {
        return this.getConfigureName();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setConfigureName(decoder.nextToken());
        Color color = ColorManager.getColorManager().getColorByName(this.getConfigureName());
        if (color == null && !this.getConfigureName().equals(CLEAR)) {
            color = ColorManager.getColorManager().getColorByName(BLACK);
        }
        this.setColor(color);
    }

    public static ColorSwatch getDefaultSwatch() {
        return ColorManager.getColorManager().getColorSwatch(ColorManager.DEFAULT_COLOR);
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((ColorSwatch)object).name);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

