/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.SwatchComboBox;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ColorSwatchConfigurer
extends Configurer {
    protected JPanel p;
    protected JPanel swatchPanel;
    protected JComboBox swatches;
    protected Box colorBox;
    protected ColorConfigurer config;

    public ColorSwatchConfigurer(String string, String string2) {
        this(string, string2, ColorSwatch.getDefaultSwatch());
    }

    public ColorSwatchConfigurer(String string, String string2, ColorSwatch colorSwatch) {
        super(string, string2);
        this.setValue(colorSwatch);
    }

    public ColorSwatchConfigurer(String string, String string2, String string3) {
        this(string, string2, ColorManager.getColorManager().getColorSwatch(string3));
    }

    public ColorSwatchConfigurer(String string, String string2, Color color) {
        this(string, string2, ColorManager.getColorManager().getColorSwatch(color));
    }

    public String getValueString() {
        return (String)this.value;
    }

    public Color getValueColor() {
        return ((ColorSwatch)this.value).getColor();
    }

    public ColorSwatch getValueColorSwatch() {
        return (ColorSwatch)this.value;
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.swatchPanel = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.name));
            this.buildSwatches();
            box.add(this.swatchPanel);
            this.p.add(box);
            this.colorBox = Box.createHorizontalBox();
            this.config = new ColorConfigurer("", "Select Color  ");
            this.config.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Color color = (Color)ColorSwatchConfigurer.this.config.getValue();
                    ColorSwatch colorSwatch = ColorManager.getColorManager().getColorSwatch(color);
                    ColorSwatchConfigurer.this.setValue(colorSwatch);
                    ColorSwatchConfigurer.this.buildSwatches();
                    ColorSwatchConfigurer.this.updateValue();
                }
            });
            this.colorBox.add(this.config.getControls());
            this.p.add(this.colorBox);
            this.repack();
        }
        return this.p;
    }

    protected void buildSwatches() {
        if (this.swatchPanel == null) {
            return;
        }
        if (this.swatches != null) {
            this.swatchPanel.remove(this.swatches);
        }
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ColorSwatchConfigurer.this.updateValue();
            }
        };
        this.swatches = new SwatchComboBox(itemListener, ((ColorSwatch)this.value).getConfigureName());
        this.swatchPanel.add(this.swatches);
    }

    protected void updateValue() {
        String string = (String)this.swatches.getSelectedItem();
        if (string.equals("Select...")) {
            this.setValue(ColorManager.getColorManager().getColorSwatch((Color)this.config.getValue()));
        } else {
            this.setValue(ColorManager.getColorManager().getColorSwatch(string));
        }
        this.repack();
    }

    protected void repack() {
        this.colorBox.setVisible(((ColorSwatch)this.getValue()).getConfigureName().equals("Select..."));
        Window window = SwingUtilities.getWindowAncestor(this.colorBox);
        if (window != null) {
            window.pack();
        }
    }

    public void setValue(String string) {
        super.setValue(new ColorSwatch(string));
        this.buildSwatches();
    }

    public static ColorSwatch decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        return new ColorSwatch(decoder.nextToken(), decoder.nextColor(Color.WHITE));
    }

    public static String encode(ColorSwatch colorSwatch) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(colorSwatch.getConfigureName(), '|');
        sequenceEncoder.append(ColorConfigurer.colorToString(colorSwatch.getColor()));
        return sequenceEncoder.getValue();
    }
}

