/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.InstanceConfigurer;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ImageSource;
import VASSAL.tools.UniqueIdManager;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class GamePieceImage
extends AbstractConfigurable
implements Visualizable,
Cloneable,
ImageSource,
UniqueIdManager.Identifyable {
    protected static final String NAME = "name";
    protected static final String PROPS = "props";
    public static final String PART_SIZE = "Size";
    public static final String PART_SYMBOL1 = "Symbol1";
    public static final String PART_SYMBOL2 = "Symbol2";
    public static final String BG_COLOR = "bgColor";
    public static final String BORDER_COLOR = "borderColor";
    protected ArrayList instances = new ArrayList(5);
    protected InstanceConfigurer defnConfig = null;
    protected GamePieceLayout layout;
    protected ColorSwatch bgColor = ColorSwatch.getWhite();
    protected ColorSwatch borderColor = ColorSwatch.getBlack();
    protected String id;
    protected static UniqueIdManager idMgr = new UniqueIdManager("GamePieceImage");
    protected String nameInUse;
    protected static Image NULL_IMAGE = new BufferedImage(1, 1, 6);
    private VisibilityCondition borderCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            if (GamePieceImage.this.getLayout() == null) {
                return false;
            }
            return GamePieceImage.this.getLayout().isColoredBorder();
        }
    };
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceImage$BgColorSwatchConfig;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceImage$BorderColorSwatchConfig;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceImage$DefnConfig;

    public GamePieceImage() {
        this.setConfigureName("");
    }

    public GamePieceImage(String string) {
        this.instances = InstanceConfigurer.StringToProperties(string, this);
    }

    public GamePieceImage(GamePieceLayout gamePieceLayout) {
        this();
        this.setConfigureName(gamePieceLayout.getConfigureName());
        this.layout = gamePieceLayout;
        this.rebuildInstances();
    }

    public GamePieceImage(GamePieceImage gamePieceImage) {
        this();
        this.setConfigureName(gamePieceImage.getConfigureName());
        this.layout = gamePieceImage.getLayout();
        this.bgColor = gamePieceImage.getBgColor();
        this.borderColor = gamePieceImage.getBorderColor();
        Iterator iterator = ((AbstractList)gamePieceImage.getInstances()).iterator();
        while (iterator.hasNext()) {
            this.instances.add(iterator.next());
        }
    }

    public Object clone() {
        return new GamePieceImage(this);
    }

    public ArrayList getInstances() {
        return this.instances;
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Background Color:  ", "Border Color:  ", ""};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = GamePieceImage.class$("java.lang.String")) : class$java$lang$String, class$VASSAL$build$module$gamepieceimage$GamePieceImage$BgColorSwatchConfig == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImage$BgColorSwatchConfig = GamePieceImage.class$("VASSAL.build.module.gamepieceimage.GamePieceImage$BgColorSwatchConfig")) : class$VASSAL$build$module$gamepieceimage$GamePieceImage$BgColorSwatchConfig, class$VASSAL$build$module$gamepieceimage$GamePieceImage$BorderColorSwatchConfig == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImage$BorderColorSwatchConfig = GamePieceImage.class$("VASSAL.build.module.gamepieceimage.GamePieceImage$BorderColorSwatchConfig")) : class$VASSAL$build$module$gamepieceimage$GamePieceImage$BorderColorSwatchConfig, class$VASSAL$build$module$gamepieceimage$GamePieceImage$DefnConfig == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImage$DefnConfig = GamePieceImage.class$("VASSAL.build.module.gamepieceimage.GamePieceImage$DefnConfig")) : class$VASSAL$build$module$gamepieceimage$GamePieceImage$DefnConfig};
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, BG_COLOR, BORDER_COLOR, PROPS};
    }

    public ColorSwatch getBgColor() {
        return this.bgColor;
    }

    public ColorSwatch getBorderColor() {
        return this.borderColor;
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            String string2 = (String)object;
            this.setConfigureName(string2);
        } else if (BG_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.bgColor = (ColorSwatch)object;
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (BORDER_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.borderColor = (ColorSwatch)object;
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (PROPS.equals(string)) {
            if (object instanceof String) {
                object = InstanceConfigurer.StringToProperties((String)object, this);
            }
            this.instances = (ArrayList)object;
            if (this.defnConfig != null) {
                this.rebuildInstances();
                this.defnConfig.visualizer.rebuild();
                this.defnConfig.repack();
            }
        }
        this.rebuildVisualizerImage();
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (BG_COLOR.equals(string)) {
            return this.bgColor.encode();
        }
        if (BORDER_COLOR.equals(string)) {
            return this.borderColor.encode();
        }
        if (PROPS.equals(string)) {
            return InstanceConfigurer.PropertiesToString(this.instances);
        }
        return null;
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if (BORDER_COLOR.equals(string)) {
            return this.borderCond;
        }
        return super.getAttributeVisibility(string);
    }

    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getDataArchive().removeImageSource(this.getConfigureName());
        idMgr.remove(this);
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImage.htm");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public void addTo(Buildable buildable) {
        this.layout = (GamePieceLayout)buildable;
        idMgr.add(this);
        this.validator = idMgr;
        this.rebuildInstances();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public static String getConfigureTypeName() {
        return "Game Piece Image";
    }

    public void refreshConfig() {
        this.rebuildVisualizerImage();
    }

    public GamePieceLayout getLayout() {
        return this.layout;
    }

    public int getVisualizerHeight() {
        return this.getLayout().getVisualizerHeight();
    }

    public int getVisualizerWidth() {
        return this.getLayout().getVisualizerWidth();
    }

    public Image getVisualizerImage() {
        try {
            return GameModule.getGameModule().getDataArchive().getCachedImage(this.getConfigureName());
        }
        catch (IOException iOException) {
            return NULL_IMAGE;
        }
    }

    public Image getImage() {
        Image image = this.layout.buildImage(this);
        GameModule.getGameModule().getArchiveWriter().addImage(this.getConfigureName(), this.getEncodedImage((BufferedImage)image));
        return image;
    }

    public void rebuildVisualizerImage() {
        if (GameModule.getGameModule().getArchiveWriter() != null) {
            if (this.nameInUse != null) {
                GameModule.getGameModule().getDataArchive().unCacheImage(this.nameInUse);
                if (!this.nameInUse.equals(this.getConfigureName())) {
                    GameModule.getGameModule().getDataArchive().removeImageSource(this.nameInUse);
                    GameModule.getGameModule().getArchiveWriter().removeImage(this.nameInUse);
                    this.nameInUse = null;
                }
            }
            if (this.nameInUse == null && this.getConfigureName() != null && this.getConfigureName().length() > 0 && GameModule.getGameModule().getDataArchive().addImageSource(this.getConfigureName(), this)) {
                this.nameInUse = this.getConfigureName();
            }
        }
    }

    public byte[] getEncodedImage(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new byte[1];
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ItemInstance getInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!string.equals(itemInstance.getName())) continue;
            return itemInstance;
        }
        return null;
    }

    public TextItemInstance getTextInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!(itemInstance instanceof TextItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (TextItemInstance)itemInstance;
        }
        return null;
    }

    public TextBoxItemInstance getTextBoxInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!(itemInstance instanceof TextBoxItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (TextBoxItemInstance)itemInstance;
        }
        return null;
    }

    public SymbolItemInstance getSymbolInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!(itemInstance instanceof SymbolItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (SymbolItemInstance)itemInstance;
        }
        return null;
    }

    public ShapeItemInstance getShapeInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!(itemInstance instanceof ShapeItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (ShapeItemInstance)itemInstance;
        }
        return null;
    }

    public ImageItemInstance getImageInstance(String string) {
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            if (!(itemInstance instanceof ImageItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (ImageItemInstance)itemInstance;
        }
        return null;
    }

    protected void rebuildInstances() {
        Item item;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = ((AbstractList)this.instances).iterator();
        while (iterator.hasNext()) {
            object = (ItemInstance)iterator.next();
            item = this.layout.getItem(((ItemInstance)object).getName());
            if (item == null || !item.getType().equals(((ItemInstance)object).getType())) continue;
            ((ItemInstance)object).setLocation(item.getLocation());
            arrayList.add(object);
        }
        object = ((AbstractList)this.layout.getItems()).iterator();
        while (object.hasNext()) {
            ItemInstance itemInstance;
            item = (Item)object.next();
            String string = item.getConfigureName();
            String string2 = item.getType();
            String string3 = item.getLocation();
            boolean bl = false;
            iterator = ((AbstractList)this.instances).iterator();
            while (iterator.hasNext() && !bl) {
                itemInstance = (ItemInstance)iterator.next();
                bl = string.equals(itemInstance.getName());
            }
            if (bl) continue;
            itemInstance = ItemInstance.newDefaultInstance(string, string2, string3);
            itemInstance.addTo(this);
            arrayList.add(itemInstance);
        }
        this.instances = arrayList;
        if (this.defnConfig != null) {
            this.defnConfig.setValue(this.instances);
        }
        this.rebuildVisualizerImage();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DefnConfig
    implements ConfigurerFactory {
        static GamePieceImage id;

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            id = (GamePieceImage)autoConfigurable;
            DefnConfig.id.defnConfig = new InstanceConfigurer(string, string2, id);
            return DefnConfig.id.defnConfig;
        }

        public static void refresh() {
            if (DefnConfig.id.defnConfig != null) {
                DefnConfig.id.defnConfig.repack();
            }
        }
    }

    public static class BorderColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((GamePieceImage)autoConfigurable).getBorderColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((GamePieceImage)autoConfigurable).getBgColor());
        }
    }
}

