/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.LayoutConfigurer;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.StringEnum;
import VASSAL.tools.SequenceEncoder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GamePieceLayout
extends AbstractConfigurable
implements Visualizable {
    protected static final String NAME = "name";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String BORDER = "border";
    protected static final String ITEMS = "layout";
    protected static final String N = "Top";
    protected static final String S = "Bottom";
    protected static final String E = "Right";
    protected static final String W = "Left";
    protected static final String NE = "Top Right";
    protected static final String NW = "Top Left";
    protected static final String SE = "Bottom Right";
    protected static final String SW = "Bottom Left";
    protected static final String CENTER = "Center";
    protected static final int POS_L = 15;
    protected static final int POS_R = 85;
    protected static final int POS_T = 15;
    protected static final int POS_B = 85;
    protected static final int POS_C = 50;
    protected static final String BORDER_PLAIN = "Plain";
    protected static final String BORDER_FANCY = "Fancy";
    protected static final String BORDER_3D = "3D";
    protected static final String BORDER_NONE = "None";
    public static final String[] LOCATIONS = new String[]{"Center", "Top", "Bottom", "Right", "Left", "Top Right", "Top Left", "Bottom Right", "Bottom Left"};
    public static final int[] X_POS = new int[]{50, 50, 50, 85, 15, 85, 15, 85, 15};
    public static final int[] Y_POS = new int[]{50, 15, 85, 50, 50, 15, 15, 85, 85};
    protected static Map compass = new HashMap();
    protected int width = 54;
    protected int height = 54;
    protected String border = "3D";
    protected GamePieceImage imageDefn;
    protected Image visImage;
    protected ArrayList items = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceLayout$BorderConfig;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceLayout$LayoutConfig;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$GamePieceImage;

    public static String getCompassPoint(String string) {
        return (String)compass.get(string);
    }

    public Point getPosition(Item item) {
        int n;
        int n2;
        String string = GamePieceLayout.getCompassPoint(item.getLocation());
        Dimension dimension = item.getSize();
        switch (string.charAt(string.length() - 1)) {
            case 'E': {
                n2 = this.getLayoutWidth() - dimension.width;
                break;
            }
            case 'W': {
                n2 = 0;
                break;
            }
            default: {
                n2 = this.getLayoutWidth() / 2 - dimension.width / 2;
            }
        }
        switch (string.charAt(0)) {
            case 'N': {
                n = 0;
                break;
            }
            case 'S': {
                n = this.getLayoutHeight() - dimension.height;
                break;
            }
            default: {
                n = this.getLayoutHeight() / 2 - dimension.height / 2;
            }
        }
        Point point = new Point(n2, n);
        point.translate(item.getXoffset(), item.getYoffset());
        return point;
    }

    public GamePieceLayout() {
        this.name = "";
        this.imageDefn = new GamePieceImage(this);
    }

    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Counter Width:  ", "Counter Height:  ", "Border Style:  ", ""};
    }

    public Class[] getAttributeTypes() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = GamePieceLayout.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = GamePieceLayout.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = GamePieceLayout.class$("java.lang.Integer")) : class$java$lang$Integer, class$VASSAL$build$module$gamepieceimage$GamePieceLayout$BorderConfig == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceLayout$BorderConfig = GamePieceLayout.class$("VASSAL.build.module.gamepieceimage.GamePieceLayout$BorderConfig")) : class$VASSAL$build$module$gamepieceimage$GamePieceLayout$BorderConfig, class$VASSAL$build$module$gamepieceimage$GamePieceLayout$LayoutConfig == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceLayout$LayoutConfig = GamePieceLayout.class$("VASSAL.build.module.gamepieceimage.GamePieceLayout$LayoutConfig")) : class$VASSAL$build$module$gamepieceimage$GamePieceLayout$LayoutConfig};
    }

    public boolean isColoredBorder() {
        return this.border.equals(BORDER_PLAIN) || this.border.equals(BORDER_FANCY);
    }

    public String[] getAttributeNames() {
        return new String[]{NAME, WIDTH, HEIGHT, BORDER, ITEMS};
    }

    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.setWidth((Integer)object);
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.setHeight((Integer)object);
        } else if (BORDER.equals(string)) {
            this.border = (String)object;
        } else if (ITEMS.equals(string)) {
            this.decodeItemList((String)object);
        }
        this.invalidate();
        LayoutConfig.refresh();
    }

    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (WIDTH.equals(string)) {
            return this.getLayoutWidth() + "";
        }
        if (HEIGHT.equals(string)) {
            return this.getLayoutHeight() + "";
        }
        if (BORDER.equals(string)) {
            return this.border + "";
        }
        if (ITEMS.equals(string)) {
            return this.encodeItemList();
        }
        return null;
    }

    public void removeFrom(Buildable buildable) {
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayouts.htm");
    }

    public Class[] getAllowableConfigureComponents() {
        return new Class[]{class$VASSAL$build$module$gamepieceimage$GamePieceImage == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImage = GamePieceLayout.class$("VASSAL.build.module.gamepieceimage.GamePieceImage")) : class$VASSAL$build$module$gamepieceimage$GamePieceImage};
    }

    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return "Game Piece Layout";
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getLayoutWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getLayoutHeight() {
        return this.height;
    }

    public String getBorder() {
        return this.border;
    }

    public ArrayList getItems() {
        return this.items;
    }

    protected int getItemCount() {
        return this.items.size();
    }

    protected Item getItem(int n) {
        return (Item)this.items.get(n);
    }

    protected Item getItem(String string) {
        Iterator iterator = ((AbstractList)this.items).iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (!item.getConfigureName().equals(string)) continue;
            return item;
        }
        return null;
    }

    protected void removeItem(int n) {
        this.items.remove(n);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void moveItem(int n, int n2) {
        Item item = (Item)this.items.get(n2);
        this.items.set(n2, this.items.get(n));
        this.items.set(n, item);
    }

    public void add(Buildable buildable) {
        super.add(buildable);
    }

    public void remove(Buildable buildable) {
        super.remove(buildable);
    }

    public Image getVisualizerImage() {
        if (this.visImage == null) {
            this.rebuildVisualizerImage();
        }
        return this.visImage;
    }

    public Image buildImage(GamePieceImage gamePieceImage) {
        Object object;
        Object object2;
        BufferedImage bufferedImage = new BufferedImage(Math.max(this.width, 1), Math.max(this.height, 1), 2);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        Color color = gamePieceImage.getBgColor().getColor();
        graphics.setColor(color);
        if (this.getBorder().equals(BORDER_3D)) {
            if (color != null) {
                graphics.fill3DRect(0, 0, this.width, this.height, true);
            }
        } else {
            if (color != null) {
                graphics.fillRect(0, 0, this.width, this.height);
            }
            if (this.getBorder().equals(BORDER_PLAIN) || this.getBorder().equals(BORDER_FANCY)) {
                object2 = color == null ? Color.WHITE : color;
                graphics.setColor(gamePieceImage.getBorderColor().getColor());
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 1, 1));
                graphics.drawRect(0, 0, this.width - 1, this.height - 1);
                if (this.getBorder().equals(BORDER_FANCY)) {
                    object = new Color(((Color)object2).getRed() / 2, ((Color)object2).getGreen() / 2, ((Color)object2).getBlue() / 2);
                    Color color2 = new Color(((Color)object2).getRed() + (255 - ((Color)object2).getRed()) / 2, ((Color)object2).getGreen() + (255 - ((Color)object2).getGreen()) / 2, ((Color)object2).getBlue() + (255 - ((Color)object2).getBlue()) / 2);
                    graphics.setColor(color2);
                    graphics.drawLine(1, 1, this.width - 3, 1);
                    graphics.drawLine(1, 2, 1, this.height - 3);
                    graphics.setColor((Color)object);
                    graphics.drawLine(this.width - 2, 2, this.width - 2, this.height - 2);
                    graphics.drawLine(2, this.height - 2, this.width - 3, this.height - 2);
                }
            }
        }
        object2 = ((AbstractList)this.items).iterator();
        while (object2.hasNext()) {
            object = (Item)object2.next();
            if (object == null) continue;
            ((Item)object).draw(graphics, gamePieceImage);
        }
        return bufferedImage;
    }

    public void refresh() {
        this.invalidate();
        LayoutConfig.refresh();
    }

    protected void invalidate() {
        this.imageDefn.rebuildVisualizerImage();
        Enumeration enumeration = this.getComponents(class$VASSAL$build$module$gamepieceimage$GamePieceImage == null ? (class$VASSAL$build$module$gamepieceimage$GamePieceImage = GamePieceLayout.class$("VASSAL.build.module.gamepieceimage.GamePieceImage")) : class$VASSAL$build$module$gamepieceimage$GamePieceImage);
        while (enumeration.hasMoreElements()) {
            ((GamePieceImage)enumeration.nextElement()).rebuildVisualizerImage();
        }
    }

    protected void decodeItemList(String string) {
        this.items.clear();
        if (string.length() > 0) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
            while (decoder.hasMoreTokens()) {
                Item item = Item.decode(this, decoder.nextToken());
                this.addItem(item);
            }
        }
    }

    protected String encodeItemList() {
        Object object;
        String[] stringArray = new String[this.getItemCount()];
        Iterator iterator = ((AbstractList)this.items).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Item)iterator.next();
            stringArray[n++] = ((Item)object).encode();
        }
        object = new SequenceEncoder('#');
        ((SequenceEncoder)object).append(stringArray);
        return ((SequenceEncoder)object).getValue();
    }

    public int getVisualizerHeight() {
        return this.getLayoutHeight();
    }

    public int getVisualizerWidth() {
        return this.getLayoutWidth();
    }

    public void rebuildVisualizerImage() {
        this.visImage = this.buildImage(this.imageDefn);
    }

    public void setImageDefn(GamePieceImage gamePieceImage) {
        this.imageDefn = gamePieceImage;
    }

    public GamePieceImage getGenericDefn(String string) {
        GamePieceImage gamePieceImage = null;
        Enumeration enumeration = this.getBuildComponents();
        while (enumeration.hasMoreElements() && gamePieceImage == null) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GamePieceImage) || !((GamePieceImage)e).getConfigureName().equals(string)) continue;
            return (GamePieceImage)e;
        }
        return gamePieceImage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        compass.put(N, "N");
        compass.put(S, "S");
        compass.put(E, "E");
        compass.put(W, "W");
        compass.put(NE, "NE");
        compass.put(NW, "NW");
        compass.put(SE, "SE");
        compass.put(SW, "SW");
        compass.put(CENTER, "CENTER");
    }

    public static class BorderConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{GamePieceLayout.BORDER_PLAIN, GamePieceLayout.BORDER_FANCY, GamePieceLayout.BORDER_3D, GamePieceLayout.BORDER_NONE};
        }
    }

    public static class LayoutConfig
    implements ConfigurerFactory {
        protected static LayoutConfigurer configurer;

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            configurer = new LayoutConfigurer(string, string2, (GamePieceLayout)autoConfigurable);
            return configurer;
        }

        public static void refresh() {
            if (configurer != null) {
                configurer.repack();
            }
        }
    }
}

