/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class ImageItem
extends Item {
    public static final String TYPE = "Image";
    public static final String SRC_VARIABLE = "Specified in individual images";
    public static final String SRC_FIXED = "Fixed for this layout";
    protected static final String IMAGE = "image";
    public static final String SOURCE = "source";
    protected String imageSource = "Fixed for this layout";
    protected String imageName = "";
    protected Image image = null;
    protected Rectangle imageBounds = new Rectangle();
    private VisibilityCondition falseCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return false;
        }
    };
    private VisibilityCondition fixedCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return ImageItem.this.imageSource.equals(ImageItem.SRC_FIXED);
        }
    };
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$VASSAL$build$module$gamepieceimage$ImageItem$TextSource;

    public ImageItem() {
    }

    public ImageItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
    }

    public ImageItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    public String[] getAttributeDescriptions() {
        String[] stringArray = new String[]{"Image:  ", "Image is:  "};
        String[] stringArray2 = super.getAttributeDescriptions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    public Class[] getAttributeTypes() {
        Class[] classArray = new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = ImageItem.class$("java.awt.Image")) : class$java$awt$Image, class$VASSAL$build$module$gamepieceimage$ImageItem$TextSource == null ? (class$VASSAL$build$module$gamepieceimage$ImageItem$TextSource = ImageItem.class$("VASSAL.build.module.gamepieceimage.ImageItem$TextSource")) : class$VASSAL$build$module$gamepieceimage$ImageItem$TextSource};
        Class[] classArray2 = super.getAttributeTypes();
        Class[] classArray3 = new Class[classArray.length + classArray2.length];
        System.arraycopy(classArray2, 0, classArray3, 0, 2);
        System.arraycopy(classArray, 0, classArray3, 2, classArray.length);
        System.arraycopy(classArray2, 2, classArray3, classArray.length + 2, classArray2.length - 2);
        return classArray3;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[]{IMAGE, SOURCE};
        String[] stringArray2 = super.getAttributeNames();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, 2);
        System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
        System.arraycopy(stringArray2, 2, stringArray3, stringArray.length + 2, stringArray2.length - 2);
        return stringArray3;
    }

    public void setAttribute(String string, Object object) {
        if (IMAGE.equals(string)) {
            this.imageName = object instanceof String ? (String)object : (object == null ? null : ((File)object).getName());
        } else if (SOURCE.equals(string)) {
            this.imageSource = (String)object;
        } else {
            super.setAttribute(string, object);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    public String getAttributeValueString(String string) {
        if (IMAGE.equals(string)) {
            return this.imageName;
        }
        if (SOURCE.equals(string)) {
            return this.imageSource + "";
        }
        return super.getAttributeValueString(string);
    }

    public VisibilityCondition getAttributeVisibility(String string) {
        if ("rotation".equals(string)) {
            return this.falseCond;
        }
        if (IMAGE.equals(string)) {
            return this.fixedCond;
        }
        return super.getAttributeVisibility(string);
    }

    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        this.loadImage(gamePieceImage);
        Point point = this.layout.getPosition(this);
        if (this.isAntialias()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.image != null) {
            graphics.drawImage(this.image, point.x, point.y, null);
        }
    }

    public String getType() {
        return TYPE;
    }

    public Dimension getSize() {
        return this.imageBounds.getSize();
    }

    public boolean isFixed() {
        return this.imageSource.equals(SRC_FIXED);
    }

    protected void loadImage(GamePieceImage gamePieceImage) {
        ImageItemInstance imageItemInstance = null;
        if (gamePieceImage != null) {
            imageItemInstance = gamePieceImage.getImageInstance(this.getConfigureName());
        }
        if (imageItemInstance == null) {
            imageItemInstance = new ImageItemInstance();
        }
        String string = this.imageSource.equals(SRC_FIXED) ? this.imageName : imageItemInstance.getImageName();
        this.image = null;
        this.imageBounds = new Rectangle();
        if (string != null) {
            if (string.trim().length() == 0) {
                this.image = new BufferedImage(10, 10, 6);
                Graphics graphics = this.image.getGraphics();
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, 9, 9);
                graphics.drawLine(0, 0, 9, 9);
                graphics.drawLine(0, 9, 9, 0);
                this.imageBounds = new Rectangle(-5, -5, 10, 10);
            } else {
                try {
                    this.image = GameModule.getGameModule().getDataArchive().getCachedImage(string);
                    this.imageBounds = DataArchive.getImageBounds(this.image);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        ImageItem imageItem = new ImageItem(gamePieceLayout);
        decoder.nextToken();
        imageItem.imageName = decoder.nextToken("");
        imageItem.imageSource = decoder.nextToken(SRC_FIXED);
        return imageItem;
    }

    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.imageName + "");
        sequenceEncoder.append(this.imageSource + "");
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TextSource
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{ImageItem.SRC_VARIABLE, ImageItem.SRC_FIXED};
        }
    }
}

