/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.build.module.gamepieceimage.Visualizer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class InstanceConfigurer
extends Configurer {
    protected GamePieceImage defn;
    protected Box visBox;
    protected Visualizer visualizer = new Visualizer();
    protected JPanel panel;
    protected SymbolPanel symbolPanel;
    protected InstanceConfigurer me;
    static /* synthetic */ Class class$java$lang$String;

    protected InstanceConfigurer() {
        super(null, null);
        this.me = this;
    }

    protected InstanceConfigurer(String string, String string2, GamePieceImage gamePieceImage) {
        super(string, string2);
        this.defn = gamePieceImage;
        this.setValue(gamePieceImage.getInstances());
        this.me = this;
    }

    public String getValueString() {
        return InstanceConfigurer.PropertiesToString((ArrayList)this.value);
    }

    public ArrayList getValueArrayList() {
        return (ArrayList)this.getValue();
    }

    public void setValue(String string) {
        this.setValue(InstanceConfigurer.StringToProperties(string, this.defn));
        if (this.symbolPanel != null) {
            this.symbolPanel.reset();
        }
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            Box box = Box.createHorizontalBox();
            box.setPreferredSize(new Dimension(50, 10));
            this.panel.add(box);
            this.visBox = Box.createHorizontalBox();
            this.visBox.setAlignmentX(0.5f);
            this.visualizer = new Visualizer(this.defn);
            this.visBox.add(new ScrollPane(this.visualizer));
            this.panel.add(this.visBox);
            box = Box.createHorizontalBox();
            box.setPreferredSize(new Dimension(50, 10));
            this.panel.add(box);
            this.symbolPanel = new SymbolPanel();
            this.panel.add(this.symbolPanel);
        }
        return this.panel;
    }

    public static String PropertiesToString(ArrayList arrayList) {
        String[] stringArray = new String[arrayList.size()];
        Iterator iterator = ((AbstractList)arrayList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ItemInstance itemInstance = (ItemInstance)iterator.next();
            stringArray[n++] = itemInstance.encode();
        }
        return StringArrayConfigurer.arrayToString(stringArray);
    }

    public static ArrayList StringToProperties(String string, GamePieceImage gamePieceImage) {
        ArrayList<ItemInstance> arrayList = new ArrayList<ItemInstance>();
        String[] stringArray = StringArrayConfigurer.stringToArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("Symbol")) {
                arrayList.add(new SymbolItemInstance(stringArray[i], gamePieceImage));
                continue;
            }
            if (stringArray[i].startsWith("TextBox")) {
                arrayList.add(new TextBoxItemInstance(stringArray[i], gamePieceImage));
                continue;
            }
            if (stringArray[i].startsWith("Text")) {
                arrayList.add(new TextItemInstance(stringArray[i], gamePieceImage));
                continue;
            }
            if (stringArray[i].startsWith("Box")) {
                arrayList.add(new ShapeItemInstance(stringArray[i], gamePieceImage));
                continue;
            }
            if (!stringArray[i].startsWith("Image")) continue;
            arrayList.add(new ImageItemInstance(stringArray[i], gamePieceImage));
        }
        return arrayList;
    }

    public void refresh() {
        if (this.symbolPanel != null) {
            this.symbolPanel.refresh();
        }
        this.visualizer.rebuild();
    }

    public void rebuildViz() {
        if (this.visualizer != null) {
            this.visualizer.rebuild();
        }
    }

    public void repack() {
        Window window;
        if (this.panel != null && (window = SwingUtilities.getWindowAncestor(this.panel)) != null) {
            window.pack();
        }
        this.rebuildViz();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SymbolPanel
    extends JPanel {
        protected JTable table;
        protected AbstractTableModel model;
        protected JScrollPane scrollPane;
        protected JButton addSymbolBtn;
        protected JButton addTextBtn;
        protected JButton remBtn;
        protected JPanel mainPanel;
        protected JPanel detailPanel;
        protected Component detailControls;
        protected int currentDetail;
        protected static final int NO_CURRENT_ITEM = -1;
        final int NAME_COL = 0;
        final int TYPE_COL = 1;
        final int LOC_COL = 2;
        final int MAX_COL = 2;

        public SymbolPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Items"));
            this.mainPanel.add(box);
            this.model = new SymbolTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            if (InstanceConfigurer.this.getValueArrayList() != null && InstanceConfigurer.this.getValueArrayList().size() > 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ SymbolPanel this$1;
                {
                    this.this$1 = symbolPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        this.this$1.showItem(-1);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        this.this$1.showItem(n);
                    }
                }
            });
            this.scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
            this.mainPanel.add(this.scrollPane);
            this.detailPanel = new JPanel();
            this.mainPanel.add(new ScrollPane(this.detailPanel));
            this.add(this.mainPanel);
            this.showItem(0);
        }

        protected void showItem(int n) {
            if (this.detailControls != null) {
                this.detailPanel.remove(this.detailControls);
                this.detailControls = null;
                this.currentDetail = -1;
            }
            int n2 = InstanceConfigurer.this.getValueArrayList().size();
            if (n != -1 && n2 > 0 && n < n2) {
                ItemInstance itemInstance = (ItemInstance)InstanceConfigurer.this.getValueArrayList().get(n);
                itemInstance.setConfig(InstanceConfigurer.this.me);
                Configurer configurer = itemInstance.getConfigurer();
                this.detailControls = configurer.getControls();
                this.detailPanel.add(this.detailControls);
                this.currentDetail = n;
            }
            this.reshow();
        }

        public void reset() {
            this.showItem(this.currentDetail);
        }

        public void reshow() {
            this.repack();
            this.detailPanel.repaint();
        }

        public void refresh() {
            this.showItem(this.currentDetail);
            this.reshow();
        }

        protected void repack() {
            Window window = SwingUtilities.getWindowAncestor(InstanceConfigurer.this.panel);
            if (window != null) {
                window.pack();
            }
        }

        class SymbolTableModel
        extends AbstractTableModel {
            private String[] columnNames = new String[]{"Name", "Type", "Position"};

            SymbolTableModel() {
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                return InstanceConfigurer.this.getValueArrayList() == null ? 0 : InstanceConfigurer.this.getValueArrayList().size();
            }

            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ((ItemInstance)InstanceConfigurer.this.getValueArrayList().get(n)).getName();
                }
                if (n2 == 1) {
                    return ((ItemInstance)InstanceConfigurer.this.getValueArrayList().get(n)).getItem().getDisplayName();
                }
                if (n2 == 2) {
                    return ((ItemInstance)InstanceConfigurer.this.getValueArrayList().get(n)).getLocation();
                }
                return null;
            }

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = InstanceConfigurer.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
            }
        }
    }
}

