/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ShapeItem;
import VASSAL.build.module.gamepieceimage.SymbolItem;
import VASSAL.build.module.gamepieceimage.TextBoxItem;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.build.module.gamepieceimage.Visualizer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class LayoutConfigurer
extends Configurer {
    protected static final String ADD_SYMBOL = "Symbol";
    protected static final String ADD_IMAGE = "Image";
    protected static final String ADD_TEXT = "Label";
    protected static final String ADD_TEXTBOX = "Text Box";
    protected static final String ADD_SHAPE = "Shape";
    protected static final String REMOVE = "Remove";
    protected static final String UP = "Up";
    protected static final String DOWN = "Down";
    protected static final int NO_CURRENT_ITEM = -1;
    protected JPanel panel;
    protected ItemPanel itemPanel;
    protected JPanel itemConfigPanel;
    protected Component currentItemControls;
    protected int currentItem = -1;
    protected Box visBox;
    protected Visualizer visualizer = new Visualizer();
    protected JLabel visLabel;
    protected Box filler;
    protected GamePieceLayout layout;
    protected StringConfigurer defName;
    protected NewIntConfigurer height;
    protected NewIntConfigurer width;
    static /* synthetic */ Class class$java$lang$String;

    protected LayoutConfigurer() {
        super(null, null);
    }

    protected LayoutConfigurer(String string, String string2, GamePieceLayout gamePieceLayout) {
        super(string, string2);
        this.layout = gamePieceLayout;
    }

    public Object getValue() {
        if (this.layout != null) {
            this.layout.setConfigureName(this.defName.getValueString());
            this.layout.setHeight((Integer)this.height.getValue());
            this.layout.setWidth((Integer)this.width.getValue());
        }
        return this.layout;
    }

    public void setValue(String string) {
        if (this.itemPanel != null) {
            this.itemPanel.reshow();
        }
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            this.visBox = Box.createHorizontalBox();
            this.visBox.setAlignmentX(0.5f);
            this.visualizer = new Visualizer(this.layout);
            this.visBox.add(new ScrollPane(this.visualizer));
            this.panel.add(this.visBox);
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            this.itemPanel = new ItemPanel();
            this.panel.add(this.itemPanel);
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            Window window = SwingUtilities.getWindowAncestor(this.itemPanel);
            if (window != null) {
                window.pack();
            }
        }
        return this.panel;
    }

    public String getValueString() {
        return null;
    }

    protected void repack() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        if (window != null) {
            window.pack();
        }
        if (this.visualizer != null) {
            this.visualizer.rebuild();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class NewIntConfigurer
    extends IntConfigurer {
        NewIntConfigurer(String string, String string2, Integer n) {
            super(string, string2, n);
        }

        public void setColumns(int n) {
            this.nameField.setColumns(n);
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }

    protected class ItemPanel
    extends JPanel
    implements ActionListener {
        protected JTable table;
        protected AbstractTableModel model;
        protected JScrollPane scrollPane;
        protected JButton addSymbolBtn;
        protected JButton addTextBtn;
        protected JButton addTextBoxBtn;
        protected JButton addImageBtn;
        protected JButton addShapeBtn;
        protected JButton remBtn;
        protected JButton upBtn;
        protected JButton dnBtn;
        protected JPanel mainPanel;

        public ItemPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Items"));
            this.mainPanel.add(box);
            this.model = new MyTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            if (LayoutConfigurer.this.layout.getItemCount() > 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ItemPanel this$1;
                {
                    this.this$1 = itemPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        this.this$1.showItem(-1);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        this.this$1.showItem(n);
                    }
                }
            });
            this.scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
            this.mainPanel.add(this.scrollPane);
            box = Box.createHorizontalBox();
            this.addSymbolBtn = new JButton(LayoutConfigurer.ADD_SYMBOL);
            this.addSymbolBtn.setToolTipText("Add a Symbol to the Layout");
            this.addSymbolBtn.addActionListener(this);
            box.add(this.addSymbolBtn);
            this.addTextBtn = new JButton(LayoutConfigurer.ADD_TEXT);
            this.addTextBtn.setToolTipText("Add Text to the Layout");
            this.addTextBtn.addActionListener(this);
            box.add(this.addTextBtn);
            this.addTextBoxBtn = new JButton(LayoutConfigurer.ADD_TEXTBOX);
            this.addTextBoxBtn.setToolTipText("Add Text Box to the Layout");
            this.addTextBoxBtn.addActionListener(this);
            box.add(this.addTextBoxBtn);
            this.addImageBtn = new JButton(LayoutConfigurer.ADD_IMAGE);
            this.addImageBtn.setToolTipText("Add an Image to the Layout");
            this.addImageBtn.addActionListener(this);
            box.add(this.addImageBtn);
            this.addShapeBtn = new JButton(LayoutConfigurer.ADD_SHAPE);
            this.addShapeBtn.setToolTipText("Add a Colored Shape to the Layout");
            this.addShapeBtn.addActionListener(this);
            box.add(this.addShapeBtn);
            this.mainPanel.add(box);
            box = Box.createHorizontalBox();
            this.remBtn = new JButton(LayoutConfigurer.REMOVE);
            this.remBtn.setToolTipText("Remove the selected Item");
            this.remBtn.addActionListener(this);
            box.add(this.remBtn);
            this.upBtn = new JButton(LayoutConfigurer.UP);
            this.upBtn.setToolTipText("Move the selected Item up the list (draw earlier)");
            this.upBtn.addActionListener(this);
            box.add(this.upBtn);
            this.dnBtn = new JButton(LayoutConfigurer.DOWN);
            this.dnBtn.setToolTipText("Move the selected Item down the list (draw later)");
            this.dnBtn.addActionListener(this);
            box.add(this.dnBtn);
            this.mainPanel.add(box);
            this.add(this.mainPanel);
            box = Box.createHorizontalBox();
            box.setPreferredSize(new Dimension(50, 10));
            this.add(box);
            LayoutConfigurer.this.itemConfigPanel = new JPanel();
            LayoutConfigurer.this.itemConfigPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add(new ScrollPane(LayoutConfigurer.this.itemConfigPanel));
            this.showItem(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = LayoutConfigurer.this.layout.getItemCount();
            int n2 = this.table.getSelectedRow();
            if (string.equals(LayoutConfigurer.ADD_SYMBOL)) {
                this.addItem(new SymbolItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_SYMBOL + n));
            } else if (string.equals(LayoutConfigurer.ADD_TEXT)) {
                TextItem textItem = new TextItem(LayoutConfigurer.this.layout, "Text" + n);
                this.addItem(textItem);
            } else if (string.equals(LayoutConfigurer.ADD_TEXTBOX)) {
                TextBoxItem textBoxItem = new TextBoxItem(LayoutConfigurer.this.layout, "TextBox" + n);
                this.addItem(textBoxItem);
            } else if (string.equals(LayoutConfigurer.ADD_IMAGE)) {
                this.addItem(new ImageItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_IMAGE + n));
            } else if (string.equals(LayoutConfigurer.ADD_SHAPE)) {
                this.addItem(new ShapeItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_SHAPE + n));
            } else if (string.equals(LayoutConfigurer.REMOVE)) {
                if (n2 >= 0) {
                    LayoutConfigurer.this.layout.removeItem(n2);
                    this.model.fireTableRowsDeleted(n2, n2);
                }
                if (LayoutConfigurer.this.layout.getItemCount() > 1) {
                    if (n2 >= LayoutConfigurer.this.layout.getItemCount()) {
                        this.table.getSelectionModel().setSelectionInterval(LayoutConfigurer.this.layout.getItemCount() - 1, LayoutConfigurer.this.layout.getItemCount() - 1);
                    } else {
                        this.table.getSelectionModel().setSelectionInterval(n2, n2);
                    }
                }
            } else if (string.equals(LayoutConfigurer.UP)) {
                if (n2 > 0) {
                    this.moveItem(n2, n2 - 1);
                }
            } else if (string.equals(LayoutConfigurer.DOWN) && n2 < n - 1) {
                this.moveItem(n2, n2 + 1);
            }
            this.rebuildViz();
        }

        protected void addItem(Item item) {
            LayoutConfigurer.this.layout.addItem(item);
            int n = LayoutConfigurer.this.layout.getItemCount() - 1;
            this.model.fireTableRowsInserted(n, n);
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }

        protected void moveItem(int n, int n2) {
            LayoutConfigurer.this.layout.moveItem(n, n2);
            this.model.fireTableRowsUpdated(n, n2);
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.rebuildViz();
        }

        protected void rebuildViz() {
            LayoutConfigurer.this.layout.setImageDefn(new GamePieceImage(LayoutConfigurer.this.layout));
            LayoutConfigurer.this.visualizer.rebuild();
        }

        protected void showItem(int n) {
            if (LayoutConfigurer.this.currentItemControls != null) {
                LayoutConfigurer.this.itemConfigPanel.remove(LayoutConfigurer.this.currentItemControls);
                LayoutConfigurer.this.currentItemControls = null;
                LayoutConfigurer.this.currentItem = -1;
            }
            if (n != -1 && LayoutConfigurer.this.layout.getItemCount() > 0 && n < LayoutConfigurer.this.layout.getItemCount()) {
                Item item = LayoutConfigurer.this.layout.getItem(n);
                Configurer configurer = item.getConfigurer();
                LayoutConfigurer.this.currentItemControls = configurer.getControls();
                LayoutConfigurer.this.itemConfigPanel.add(LayoutConfigurer.this.currentItemControls);
                LayoutConfigurer.this.currentItem = n;
            }
            this.reshow();
        }

        public void reshow() {
            LayoutConfigurer.this.repack();
            this.rebuildViz();
            LayoutConfigurer.this.itemConfigPanel.repaint();
        }

        class MyTableModel
        extends AbstractTableModel {
            private String[] columnNames = new String[]{"Name", "Type", "Position"};

            MyTableModel() {
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                return ((ItemPanel)ItemPanel.this).LayoutConfigurer.this.layout.getItemCount();
            }

            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ((ItemPanel)ItemPanel.this).LayoutConfigurer.this.layout.getItem(n).getConfigureName();
                }
                if (n2 == 1) {
                    return ((ItemPanel)ItemPanel.this).LayoutConfigurer.this.layout.getItem(n).getDisplayName();
                }
                if (n2 == 2) {
                    return ((ItemPanel)ItemPanel.this).LayoutConfigurer.this.layout.getItem(n).getLocation();
                }
                return null;
            }

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = LayoutConfigurer.class$("java.lang.String")) : class$java$lang$String;
            }
        }
    }
}

